/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add;

import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterAddActionDTO;
import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class ChangesFilterAddRequest
extends BaseNodesRequest<ChangesFilterAddRequest> {
    private final String initiatedOnNode;
    private final ChangesFilterAddActionDTO addFilterAction;

    public ChangesFilterAddRequest(String initiatedOnNode, List<DiscoveryNode> nodeRecipients, ChangesFilterAddActionDTO addFilterAction) {
        super(nodeRecipients.toArray(new DiscoveryNode[0]));
        this.initiatedOnNode = initiatedOnNode;
        this.addFilterAction = addFilterAction;
    }

    public ChangesFilterAddRequest(StreamInput in) throws IOException {
        super(in);
        this.initiatedOnNode = in.readString();
        this.addFilterAction = (ChangesFilterAddActionDTO)in.readOptionalWriteable(ChangesFilterAddActionDTO::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.initiatedOnNode);
        out.writeOptionalWriteable((Writeable)this.addFilterAction);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.initiatedOnNode == null) {
            validationException = ValidateActions.addValidationError((String)"no 'initiatedOnNode' specified", validationException);
        }
        if (this.addFilterAction == null) {
            validationException = ValidateActions.addValidationError((String)"no 'addFilterAction' specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getInitiatedOnNode() {
        return this.initiatedOnNode;
    }

    public ChangesFilterAddActionDTO getAddFilterAction() {
        return this.addFilterAction;
    }
}

