/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation;

import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class IndexOperationRequest
extends BaseNodesRequest<IndexOperationRequest> {
    private final String initiatedOnNode;
    private final IndexOperationDTO indexOperation;

    public IndexOperationRequest(String initiatedOnNode, IndexOperationDTO indexOperation) {
        super(new String[0]);
        this.initiatedOnNode = initiatedOnNode;
        this.indexOperation = indexOperation;
    }

    public IndexOperationRequest(StreamInput in) throws IOException {
        super(in);
        this.initiatedOnNode = in.readString();
        this.indexOperation = (IndexOperationDTO)in.readOptionalWriteable(IndexOperationDTO::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.initiatedOnNode);
        out.writeOptionalWriteable((Writeable)this.indexOperation);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.initiatedOnNode == null) {
            validationException = ValidateActions.addValidationError((String)"no 'initiatedOnNode' specified", validationException);
        }
        if (this.indexOperation == null) {
            validationException = ValidateActions.addValidationError((String)"no 'indexOperation' specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getInitiatedOnNode() {
        return this.initiatedOnNode;
    }

    public IndexOperationDTO getIndexOperation() {
        return this.indexOperation;
    }
}

