/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class ChangesFilterAddActionDTO
implements OpenSearchPluginDTO {
    private final String serverUUID;
    private final String index;
    private final boolean sendIndexEventsOnlyForModifiedSources;

    public ChangesFilterAddActionDTO(String serverUUID, String index, boolean sendIndexEventsOnlyForModifiedSources) {
        Objects.requireNonNull(serverUUID, "serverUUID cannot be null");
        Objects.requireNonNull(index, "index cannot be null");
        this.serverUUID = serverUUID;
        this.index = index;
        this.sendIndexEventsOnlyForModifiedSources = sendIndexEventsOnlyForModifiedSources;
    }

    public ChangesFilterAddActionDTO(Map<String, Object> actionMap) {
        this(MapUtil.getValueAsString(actionMap, (String)"serverUUID", null), MapUtil.getValueAsString(actionMap, (String)"index", null), MapUtil.getValueAsBoolean(actionMap, (String)"sendIndexEventsOnlyForModifiedSources", (boolean)false));
    }

    public ChangesFilterAddActionDTO(StreamInput in) throws IOException {
        this.serverUUID = in.readString();
        this.index = in.readString();
        this.sendIndexEventsOnlyForModifiedSources = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.serverUUID);
        out.writeString(this.index);
        out.writeBoolean(this.sendIndexEventsOnlyForModifiedSources);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("serverUUID", this.serverUUID);
        builder.field("index", this.index);
        builder.field("sendIndexEventsOnlyForModifiedSources", this.sendIndexEventsOnlyForModifiedSources);
        builder.endObject();
        return builder;
    }

    public ChangesFilterAddActionDTO fromXContent(XContentParser parser) throws IOException {
        return new ChangesFilterAddActionDTO(parser.map());
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isSendIndexEventsOnlyForModifiedSources() {
        return this.sendIndexEventsOnlyForModifiedSources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangesFilterAddActionDTO that = (ChangesFilterAddActionDTO)o;
        return this.sendIndexEventsOnlyForModifiedSources == that.sendIndexEventsOnlyForModifiedSources && Objects.equals(this.serverUUID, that.serverUUID) && Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hash(this.serverUUID, this.index, this.sendIndexEventsOnlyForModifiedSources);
    }

    public String toString() {
        return "ChangesFilterAddActionDTO{serverUUID='" + this.serverUUID + "', index='" + this.index + "', sendIndexEventsOnlyForModifiedSources=" + this.sendIndexEventsOnlyForModifiedSources + "}";
    }
}

