/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class ConnectedServerDTO
implements OpenSearchPluginDTO {
    private final String nodeName;
    private final String websocketId;
    private String serverUUID;
    private String serverHostname;
    private String serverAddress;
    private String serverHttpPort;
    private String serverHttpsPort;
    private String bpcName;
    private String bpcUrl;
    private boolean maintenanceModeEnabled;
    private boolean availableForReplication;
    private boolean masterServer;
    private Instant lastStateUpdateInUtc;
    private final LoadedModulesDTO loadedModules;

    public ConnectedServerDTO(String nodeName, String websocketId, ServerStateInfoDTO serverStateInfo, LoadedModulesDTO serverLoadedModules) {
        this.nodeName = nodeName;
        this.websocketId = websocketId;
        if (serverStateInfo != null) {
            this.serverUUID = serverStateInfo.getServerUUID();
            this.serverHostname = serverStateInfo.getServerHostname();
            this.serverAddress = serverStateInfo.getServerAddress();
            this.serverHttpPort = serverStateInfo.getServerHttpPort();
            this.serverHttpsPort = serverStateInfo.getServerHttpsPort();
            this.bpcName = serverStateInfo.getBpcName();
            this.bpcUrl = serverStateInfo.getBpcUrl();
            this.maintenanceModeEnabled = serverStateInfo.isMaintenanceModeEnabled();
            this.availableForReplication = serverStateInfo.isAvailableForReplication();
            this.masterServer = serverStateInfo.isMasterServer();
            this.lastStateUpdateInUtc = serverStateInfo.getSendedAtInUtc();
        }
        this.loadedModules = serverLoadedModules != null ? serverLoadedModules : new LoadedModulesDTO();
    }

    public ConnectedServerDTO(Map<String, Object> serverData) {
        this.nodeName = MapUtil.getValueAsString(serverData, (String)"nodeName", null);
        this.websocketId = MapUtil.getValueAsString(serverData, (String)"websocketId", null);
        this.serverUUID = MapUtil.getValueAsString(serverData, (String)"serverUUID", null);
        this.serverHostname = MapUtil.getValueAsString(serverData, (String)"serverHostname", null);
        this.serverAddress = MapUtil.getValueAsString(serverData, (String)"serverAddress", null);
        this.serverHttpPort = MapUtil.getValueAsString(serverData, (String)"serverHttpPort", null);
        this.serverHttpsPort = MapUtil.getValueAsString(serverData, (String)"serverHttpsPort", null);
        this.bpcName = MapUtil.getValueAsString(serverData, (String)"bpcName", null);
        this.bpcUrl = MapUtil.getValueAsString(serverData, (String)"bpcUrl", null);
        this.maintenanceModeEnabled = MapUtil.getValueAsBoolean(serverData, (String)"maintenanceModeEnabled", (boolean)false);
        this.availableForReplication = MapUtil.getValueAsBoolean(serverData, (String)"availableForReplication", (boolean)true);
        this.masterServer = MapUtil.getValueAsBoolean(serverData, (String)"masterServer", (boolean)false);
        this.lastStateUpdateInUtc = MapUtil.getValueAsInstant(serverData, (String)"lastStateUpdate", (Instant)TimestampUtil.nowInUtc());
        List loadedModulesList = MapUtil.getValueAsList(serverData, (String)"loadedModules", null);
        this.loadedModules = loadedModulesList != null ? new LoadedModulesDTO(loadedModulesList) : new LoadedModulesDTO();
    }

    public ConnectedServerDTO(StreamInput in) throws IOException {
        this.nodeName = in.readString();
        this.websocketId = in.readString();
        this.serverUUID = in.readOptionalString();
        this.serverHostname = in.readOptionalString();
        this.serverAddress = in.readOptionalString();
        this.serverHttpPort = in.readOptionalString();
        this.serverHttpsPort = in.readOptionalString();
        this.bpcName = in.readOptionalString();
        this.bpcUrl = in.readOptionalString();
        this.maintenanceModeEnabled = in.readOptionalBoolean();
        this.availableForReplication = in.readOptionalBoolean();
        this.masterServer = in.readOptionalBoolean();
        this.lastStateUpdateInUtc = in.readOptionalInstant();
        LoadedModulesDTO readLoadedModulesDTO = (LoadedModulesDTO)in.readOptionalWriteable(LoadedModulesDTO::new);
        this.loadedModules = readLoadedModulesDTO != null ? readLoadedModulesDTO : new LoadedModulesDTO();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.websocketId);
        out.writeOptionalString(this.serverUUID);
        out.writeOptionalString(this.serverHostname);
        out.writeOptionalString(this.serverAddress);
        out.writeOptionalString(this.serverHttpPort);
        out.writeOptionalString(this.serverHttpsPort);
        out.writeOptionalString(this.bpcName);
        out.writeOptionalString(this.bpcUrl);
        out.writeOptionalBoolean(Boolean.valueOf(this.maintenanceModeEnabled));
        out.writeOptionalBoolean(Boolean.valueOf(this.availableForReplication));
        out.writeOptionalBoolean(Boolean.valueOf(this.masterServer));
        out.writeOptionalInstant(this.lastStateUpdateInUtc);
        out.writeOptionalWriteable((Writeable)this.loadedModules);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("nodeName", this.getNodeName());
        builder.field("websocketId", this.getWebsocketId());
        builder.field("serverUUID", this.getServerUUID());
        builder.field("serverHostname", this.getServerHostname());
        builder.field("serverAddress", this.getServerAddress());
        builder.field("serverHttpPort", this.getServerHttpPort());
        builder.field("serverHttpsPort", this.getServerHttpsPort());
        builder.field("bpcName", this.getBpcName());
        builder.field("bpcUrl", this.getBpcUrl());
        builder.field("maintenanceModeEnabled", this.isMaintenanceModeEnabled());
        builder.field("availableForReplication", this.isAvailableForReplication());
        builder.field("masterServer", this.isMasterServer());
        builder.field("lastStateUpdate", TimestampUtil.formatAsIsoInstantString((Instant)this.getLastStateUpdateInUtc()));
        if (this.loadedModules != null) {
            builder.field("loadedModules", (ToXContent)this.loadedModules, params);
        }
        builder.endObject();
        return builder;
    }

    public ConnectedServerDTO fromXContent(XContentParser parser) throws IOException {
        return new ConnectedServerDTO(parser.map());
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getWebsocketId() {
        return this.websocketId;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public String getServerHostname() {
        return this.serverHostname;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerHttpPort() {
        return this.serverHttpPort;
    }

    public String getServerHttpsPort() {
        return this.serverHttpsPort;
    }

    public String getBpcName() {
        return this.bpcName;
    }

    public String getBpcUrl() {
        return this.bpcUrl;
    }

    public boolean isMaintenanceModeEnabled() {
        return this.maintenanceModeEnabled;
    }

    public boolean isAvailableForReplication() {
        return this.availableForReplication;
    }

    public boolean isMasterServer() {
        return this.masterServer;
    }

    public Instant getLastStateUpdateInUtc() {
        return this.lastStateUpdateInUtc;
    }

    public LocalDateTime getLastStateUpdateInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.lastStateUpdateInUtc);
    }

    public LoadedModulesDTO getLoadedModules() {
        return this.loadedModules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedServerDTO that = (ConnectedServerDTO)o;
        return this.maintenanceModeEnabled == that.maintenanceModeEnabled && this.availableForReplication == that.availableForReplication && this.masterServer == that.masterServer && Objects.equals(this.nodeName, that.nodeName) && Objects.equals(this.websocketId, that.websocketId) && Objects.equals(this.serverUUID, that.serverUUID) && Objects.equals(this.serverHostname, that.serverHostname) && Objects.equals(this.serverAddress, that.serverAddress) && Objects.equals(this.serverHttpPort, that.serverHttpPort) && Objects.equals(this.serverHttpsPort, that.serverHttpsPort) && Objects.equals(this.bpcName, that.bpcName) && Objects.equals(this.bpcUrl, that.bpcUrl) && Objects.equals(this.lastStateUpdateInUtc, that.lastStateUpdateInUtc) && Objects.equals(this.loadedModules, that.loadedModules);
    }

    public int hashCode() {
        return this.serverUUID.hashCode();
    }

    public String toString() {
        return "ConnectedServerDTO{nodeName='" + this.nodeName + "', websocketId='" + this.websocketId + "', serverUUID='" + this.serverUUID + "', serverHostname='" + this.serverHostname + "', serverAddress='" + this.serverAddress + "', serverHttpPort='" + this.serverHttpPort + "', serverHttpsPort='" + this.serverHttpsPort + "', bpcName='" + this.bpcName + "', bpcUrl='" + this.bpcUrl + "', maintenanceModeEnabled=" + this.maintenanceModeEnabled + ", availableForReplication=" + this.availableForReplication + ", masterServer=" + this.masterServer + ", lastStateUpdateInUtc=" + this.lastStateUpdateInUtc + ", loadedModules=" + this.loadedModules + "}";
    }
}

