/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.FilterDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;

public class FiltersDTO
implements OpenSearchPluginDTO,
Iterable<FilterDTO> {
    private final List<FilterDTO> filters = new ArrayList<FilterDTO>();

    public FiltersDTO() {
    }

    public FiltersDTO(Map<String, Object> filtersMap) {
        this();
        this.filters.addAll(MapUtil.getArrayValueAsListOfObjects(filtersMap, (String)"filters", FilterDTO.class));
    }

    public FiltersDTO(StreamInput in) throws IOException {
        this();
        this.filters.addAll(in.readList(FilterDTO::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.filters);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("filters");
        for (FilterDTO filter : this.filters) {
            filter.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public int size() {
        return this.filters.size();
    }

    public FilterDTO get(int index) {
        return this.filters.get(index);
    }

    public List<FilterDTO> getFilters() {
        return new ArrayList<FilterDTO>(this.filters);
    }

    public void addFilter(FilterDTO filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    public boolean containsFilter(FilterDTO filter) {
        return this.filters.contains(filter);
    }

    @Override
    public Iterator<FilterDTO> iterator() {
        return this.filters.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FiltersDTO that = (FiltersDTO)o;
        return Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    public String toString() {
        return "FiltersDTO{filters=" + this.filters + "}";
    }
}

