/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.analysis;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.module.analysis.AnalysisModuleInstance;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class AnalysisModule
extends AbstractInstantiableModule {
    private static final Logger LOG = Logger.getLogger(AnalysisModule.class.getName());
    public static final String MODULE_ID = "analysis";
    private static AnalysisModule instance;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public AnalysisModule(ModuleManager moduleManager) {
        super(moduleManager);
        instance = this;
    }

    public static AnalysisModule getInstance() {
        return instance;
    }

    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BpcServicesTracker.stopAll((Object)((Object)this));
        this.openSearchServiceTracker = new BpcServicesTracker(moduleBundle.getBundleContext(), OpenSearchService.class);
        this.openSearchServiceTracker.start();
    }

    public void destroy() {
        LOG.info("destroy");
        super.destroy();
        BpcServicesTracker.stopAll((Object)((Object)this));
        instance = null;
    }

    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/default_module_settings.json").build();
    }

    public String getModuleId() {
        return MODULE_ID;
    }

    public String getModuleName() {
        return "Data Analysis";
    }

    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/default_instance_settings.json").build();
    }

    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        return AnalysisModuleInstance.class;
    }

    public synchronized OpenSearchService getOpenSearchService() throws ServiceNotFoundException {
        LOG.info("getOpenSearchService");
        return (OpenSearchService)this.openSearchServiceTracker.getService();
    }
}

