/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.analysis.modifier;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import de.virtimo.bpc.module.analysis.modifier.EngineNotFoundException;
import de.virtimo.bpc.module.analysis.modifier.Modifier;
import de.virtimo.bpc.module.analysis.util.AnalysisUtil;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.graalvm.polyglot.Context;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class JavascriptModifier
implements Modifier {
    private static final Logger LOG = Logger.getLogger(JavascriptModifier.class.getName());
    private ScriptEngine jsScriptEngine;
    private Map dataSetConfig;

    public JavascriptModifier(Map dataSetConfig) throws EngineNotFoundException {
        this.dataSetConfig = dataSetConfig;
        this.jsScriptEngine = this.getSecureJsScriptEngine();
    }

    @Override
    public Object modify(String data, String modifier, Map<String, List<String>> variables) throws ScriptException, NoSuchMethodException {
        Map vars = AnalysisUtil.getVarsForModifier(this.dataSetConfig, variables);
        Object[] params = new Object[]{data, vars};
        modifier = this.adjustModifier(modifier);
        this.jsScriptEngine.eval(modifier);
        Invocable inv = (Invocable)((Object)this.jsScriptEngine);
        Object result = inv.invokeFunction("getModifiedData", params);
        return result;
    }

    private ScriptEngine getSecureJsScriptEngine() throws EngineNotFoundException {
        GraalJSScriptEngine jsScriptEngine = GraalJSScriptEngine.create(null, (Context.Builder)Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(false).option("js.ecmascript-version", "2021"));
        if (jsScriptEngine == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            LOG.warning(bundleContext.getBundle().getSymbolicName() + "*** jsScriptEngine not found ***");
            throw new EngineNotFoundException("JS Engine not found");
        }
        return jsScriptEngine;
    }

    private String adjustModifier(String sourceModifier) {
        return sourceModifier.concat("function getModifiedData (data, vars) {   const dataObj = JSON.parse(data);   const result = modify(dataObj, vars);   if (typeof result === 'object') {       return JSON.stringify(result);   } else {       return result;   }}");
    }
}

