/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BackupSupport;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.module.forms.Manager;
import de.virtimo.bpc.module.forms.ModuleInstance;
import de.virtimo.bpc.module.forms.OpenSearchManagerImpl;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class Module
extends AbstractInstantiableModule
implements BackupSupport {
    private static final Logger LOG = Logger.getLogger(Module.class.getName());
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private static Module instance;
    private Manager manager;

    public Module(ModuleManager moduleManager) {
        super(moduleManager);
        instance = this;
    }

    public static Module getInstance() {
        return instance;
    }

    public Manager getManager() {
        return this.manager;
    }

    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/default_module_settings.json").build();
    }

    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/default_instance_settings.json").build();
    }

    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BpcServicesTracker.stopAll((Object)((Object)this));
        this.openSearchServiceTracker = new BpcServicesTracker(moduleBundle.getBundleContext(), OpenSearchService.class);
        try {
            OpenSearchService es = (OpenSearchService)this.openSearchServiceTracker.getService();
            Map managedIndicesConfigMap = JsonDefaultsUtil.loadJsonFileAsMap((Bundle)moduleBundle, (String)"managed_indices.json");
            es.prepareManagedIndices(managedIndicesConfigMap);
            this.manager = new OpenSearchManagerImpl(es);
        }
        catch (ServiceNotFoundException e) {
            LOG.log(Level.SEVERE, "OpenSearchService not found", e);
        }
        catch (OpenSearchRelatedException e) {
            LOG.log(Level.SEVERE, "Problem with OpenSearchService", e);
        }
    }

    public String getModuleId() {
        return "forms";
    }

    public String getModuleName() {
        return "Forms";
    }

    public Class<? extends de.virtimo.bpc.api.ModuleInstance> getModuleInstanceClass() {
        return ModuleInstance.class;
    }

    public void destroy() {
        LOG.info("destroy");
        super.destroy();
        BpcServicesTracker.stopAll((Object)((Object)this));
        instance = null;
    }

    public BackupSetting getBackupSetting() {
        return BackupSetting.withEnabled((boolean)true).withIntervalInSeconds(86400L).withKeepBackupsDurationInSeconds(2592000L).withIndicesToBackup(new String[]{"bpc-forms"}).build();
    }
}

