/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.module.forms.Form;
import de.virtimo.bpc.module.forms.InvalidFormConfigException;
import de.virtimo.bpc.module.forms.Module;
import de.virtimo.bpc.module.forms.NoFormFoundException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;

@Path(value="/")
@ApplicationPath(value="cxf/bpc-forms")
public class RestInterface {
    private static final Logger LOG = Logger.getLogger(RestInterface.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<EventAdmin> eventAdminTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public RestInterface(BundleContext bundleContext) {
        LOG.info("RestInterface bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker(this.bundleContext, ErrorResponseService.class);
        this.eventAdminTracker = new BpcServicesTracker(this.bundleContext, EventAdmin.class);
        this.eventAdminTracker.start();
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll((Object)this);
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms")
    @BpcRoleOrRightRequired(right="FORMS_READ_ALL", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response getFormsList() {
        return Response.ok(Module.getInstance().getManager().getForms()).build();
    }

    @Produces(value={"application/json"})
    @POST
    @Path(value="/forms/{formId}")
    @BpcRoleOrRightRequired(right="FORMS_ADD", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response addForm(@PathParam(value="formId") String formId, Map<String, Object> formInput) {
        return this.addOrUpdateForm(formId, formInput);
    }

    @Produces(value={"application/json"})
    @PUT
    @Path(value="/forms/{formId}/{version}")
    @BpcRoleOrRightRequired(right="FORMS_UPDATE", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response updateForm(@PathParam(value="formId") String formId, @PathParam(value="version") String version, Map<String, Object> formInput) {
        return this.addOrUpdateForm(formId, formInput);
    }

    private Response addOrUpdateForm(String formId, Map<String, Object> formInput) {
        Form form = null;
        try {
            form = Module.getInstance().getManager().addForm(formId, (String)formInput.get("name"), (Map)formInput.get("config"));
        }
        catch (InvalidFormConfigException e) {
            return ErrorResponse.forException((Exception)((Object)e)).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)form).build();
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms/{formId}")
    @BpcUserSessionRequired
    public Response getForm(@PathParam(value="formId") String formId) {
        Form form = null;
        try {
            form = Module.getInstance().getManager().getForm(formId);
        }
        catch (NoFormFoundException e) {
            Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)form).build();
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms/{formId}/{version}")
    @BpcUserSessionRequired
    public Response getFormVersion(@PathParam(value="formId") String formId, @PathParam(value="version") String version) {
        Form form = null;
        try {
            form = Module.getInstance().getManager().getForm(formId, Integer.parseInt(version));
        }
        catch (NoFormFoundException e) {
            Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)form).build();
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/history/{formId}")
    @BpcRoleOrRightRequired(right="FORMS_READ_HISTORY", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response getFormHistory(@PathParam(value="formId") String formId) {
        Set<Form> forms = null;
        try {
            forms = Module.getInstance().getManager().getFormHistory(formId);
        }
        catch (NoFormFoundException e) {
            Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(forms).build();
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/config/{formId}")
    @BpcUserSessionRequired
    public Response getFormConfig(@PathParam(value="formId") String formId) {
        Form form = null;
        try {
            form = Module.getInstance().getManager().getForm(formId);
        }
        catch (NoFormFoundException e) {
            Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(form.getConfig()).build();
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/config/{formId}/{version}")
    @BpcUserSessionRequired
    public Response getFormVersionConfig(@PathParam(value="formId") String formId, @PathParam(value="version") String version) {
        Form form = null;
        try {
            form = Module.getInstance().getManager().getForm(formId, Integer.parseInt(version));
        }
        catch (NoFormFoundException e) {
            Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(form.getConfig()).build();
    }
}

