/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

public class BroadcastWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "BroadcastMessage:::";
    private final String sender;
    private final long sendedAtUtcMilli;
    private final String type;
    private final Map<String, Object> data;

    public BroadcastWebsocketMessage(String sender, long sendedAtUtcMilli, String type, Map<String, Object> data) {
        this.sender = sender;
        this.sendedAtUtcMilli = sendedAtUtcMilli;
        this.type = type;
        this.data = data;
    }

    public BroadcastWebsocketMessage(String sender, LocalDateTime sendedAt, String type, Map<String, Object> data) {
        this.sender = sender;
        this.sendedAtUtcMilli = sendedAt.toInstant(ZoneOffset.UTC).toEpochMilli();
        this.type = type;
        this.data = data;
    }

    public BroadcastWebsocketMessage(Map<String, Object> dataMap) {
        this.sender = MapUtil.getValueAsString(dataMap, (String)"sender", null);
        this.sendedAtUtcMilli = MapUtil.getValueAsLong(dataMap, (String)"sendedAtUtcMilli", (long)0L);
        this.type = MapUtil.getValueAsString(dataMap, (String)"type", null);
        this.data = MapUtil.getValueAsMap(dataMap, (String)"data", null);
    }

    private Map<String, Object> asMap() {
        return MapUtil.mapOf((Object[])new Object[]{"sender", this.sender, "sendedAtUtcMilli", this.sendedAtUtcMilli, "type", this.type, "data", this.data});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BroadcastWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new BroadcastWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + BroadcastWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public String getSender() {
        return this.sender;
    }

    public long getSendedAtUtcMilli() {
        return this.sendedAtUtcMilli;
    }

    public String getType() {
        return this.type;
    }

    public boolean isType(String type) {
        return Objects.equals(this.type, type);
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String toString() {
        return "BroadcastWebsocketMessage{sender='" + this.sender + "', sendedAtUtcMilli=" + this.sendedAtUtcMilli + ", type='" + this.type + "', data=" + this.data + "}";
    }
}

