/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.DefaultTyrusServerEndpointConfig;

public interface TyrusServerEndpointConfig
extends ServerEndpointConfig {
    public int getMaxSessions();

    public static final class Builder {
        private String path;
        private Class<?> endpointClass;
        private List<String> subprotocols = Collections.emptyList();
        private List<Extension> extensions = Collections.emptyList();
        private List<Class<? extends Encoder>> encoders = Collections.emptyList();
        private List<Class<? extends Decoder>> decoders = Collections.emptyList();
        private ServerEndpointConfig.Configurator serverEndpointConfigurator;
        private int maxSessions = 0;

        public static Builder create(Class<?> endpointClass, String path) {
            return new Builder(endpointClass, path);
        }

        private Builder() {
        }

        public TyrusServerEndpointConfig build() {
            ServerEndpointConfig serverEndpointConfig = ServerEndpointConfig.Builder.create(this.endpointClass, (String)this.path).subprotocols(this.subprotocols).extensions(this.extensions).encoders(this.encoders).decoders(this.decoders).configurator(this.serverEndpointConfigurator).build();
            return new DefaultTyrusServerEndpointConfig(serverEndpointConfig, this.maxSessions);
        }

        private Builder(Class<?> endpointClass, String path) {
            if (endpointClass == null) {
                throw new IllegalArgumentException("endpointClass cannot be null");
            }
            this.endpointClass = endpointClass;
            if (path == null || !path.startsWith("/")) {
                throw new IllegalStateException("Path cannot be null and must begin with /");
            }
            this.path = path;
        }

        public Builder encoders(List<Class<? extends Encoder>> encoders) {
            this.encoders = encoders == null ? new ArrayList() : encoders;
            return this;
        }

        public Builder decoders(List<Class<? extends Decoder>> decoders) {
            this.decoders = decoders == null ? new ArrayList() : decoders;
            return this;
        }

        public Builder subprotocols(List<String> subprotocols) {
            this.subprotocols = subprotocols == null ? new ArrayList() : subprotocols;
            return this;
        }

        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions == null ? new ArrayList() : extensions;
            return this;
        }

        public Builder configurator(ServerEndpointConfig.Configurator serverEndpointConfigurator) {
            this.serverEndpointConfigurator = serverEndpointConfigurator;
            return this;
        }

        public Builder maxSessions(int maxSessions) {
            this.maxSessions = maxSessions;
            return this;
        }
    }
}

