/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;

public class StringUtil {
    private static final Logger LOG = Loggers.getLogger(StringUtil.class, (String[])new String[]{"os-bpc-plugin"});

    public static String implode(String glue, String[] pieces) {
        StringBuilder result = new StringBuilder();
        if (pieces != null && pieces.length > 0) {
            for (int i = 0; i < pieces.length; ++i) {
                String piece = pieces[i];
                if (piece != null) {
                    result.append(piece);
                }
                if (glue == null || i >= pieces.length - 1) continue;
                result.append(glue);
            }
        }
        return result.toString();
    }

    public static String implode(String glue, Collection<String> pieces) {
        return StringUtil.implode(glue, pieces == null ? null : pieces.toArray(new String[0]));
    }

    public static List<String> explode(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        if (delimiter == null || delimiter.length() == 0) {
            return Arrays.asList(s);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, delimiter);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken().trim());
        }
        return result;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

