/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.module.forms.Form;
import de.virtimo.bpc.module.forms.Module;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="/")
@ApplicationPath(value="cxf/bpc-forms")
public class RestInterface {
    private static final Logger LOGGER = LogManager.getLogger(RestInterface.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public RestInterface(BundleContext bundleContext) {
        LOGGER.info("RestInterface bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll((Object)this);
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms")
    @BpcRoleOrRightRequired(right="FORMS_READ_ALL", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response getFormsList() {
        try {
            Set<Form> forms = Module.getInstance().getManager().getForms();
            return Response.ok(forms).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @POST
    @Path(value="/forms/{formId}")
    @BpcRoleOrRightRequired(right="FORMS_ADD", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response addForm(@PathParam(value="formId") String formId, Map<String, Object> formInput) {
        try {
            Form form = Module.getInstance().getManager().addForm(formId, (String)formInput.get("name"), (Map)formInput.get("config"));
            return Response.ok((Object)form).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @PUT
    @Path(value="/forms/{formId}/{version}")
    @BpcRoleOrRightRequired(right="FORMS_UPDATE", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response updateForm(@PathParam(value="formId") String formId, @PathParam(value="version") String version, Map<String, Object> formInput) {
        try {
            Form form = Module.getInstance().getManager().addForm(formId, (String)formInput.get("name"), (Map)formInput.get("config"));
            return Response.ok((Object)form).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms/{formId}")
    @BpcUserSessionRequired
    public Response getForm(@PathParam(value="formId") String formId) {
        try {
            Form form = Module.getInstance().getManager().getForm(formId);
            return Response.ok((Object)form).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms/{formId}/{version}")
    @BpcUserSessionRequired
    public Response getFormVersion(@PathParam(value="formId") String formId, @PathParam(value="version") String version) {
        try {
            Form form = Module.getInstance().getManager().getForm(formId, Integer.parseInt(version));
            return Response.ok((Object)form).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/history/{formId}")
    @BpcRoleOrRightRequired(right="FORMS_READ_HISTORY", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response getFormHistory(@PathParam(value="formId") String formId) {
        try {
            Set<Form> forms = Module.getInstance().getManager().getFormHistory(formId);
            return Response.ok(forms).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/config/{formId}")
    @BpcUserSessionRequired
    public Response getFormConfig(@PathParam(value="formId") String formId) {
        try {
            Form form = Module.getInstance().getManager().getForm(formId);
            return Response.ok(form.getConfig()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/config/{formId}/{version}")
    @BpcUserSessionRequired
    public Response getFormVersionConfig(@PathParam(value="formId") String formId, @PathParam(value="version") String version) {
        try {
            Form form = Module.getInstance().getManager().getForm(formId, Integer.parseInt(version));
            return Response.ok(form.getConfig()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

