/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.EventHandlerEvent;
import de.virtimo.bpc.util.MapUtil;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.service.event.Event;

public abstract class AbstractServerModeChangedEventHandler
extends AbstractEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(AbstractServerModeChangedEventHandler.class);

    @Override
    protected void processEvent(Event event) {
        LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
        ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent = new ServerModeOfThisServerChangedEvent(event);
        if (serverModeOfThisServerChangedEvent.isNowTheMaster()) {
            this.processThisIsNowTheMasterServer(serverModeOfThisServerChangedEvent);
        } else if (serverModeOfThisServerChangedEvent.isNowASlave()) {
            this.processThisIsNowASlaveServer(serverModeOfThisServerChangedEvent);
        }
    }

    public abstract void processThisIsNowTheMasterServer(ServerModeOfThisServerChangedEvent var1);

    public abstract void processThisIsNowASlaveServer(ServerModeOfThisServerChangedEvent var1);

    public static class ServerModeOfThisServerChangedEvent
    implements EventHandlerEvent {
        private final String thisServerUUID;
        private final String masterServerUUID;

        public ServerModeOfThisServerChangedEvent(String thisServerUUID, String masterServerUUID) {
            Objects.requireNonNull(thisServerUUID, "thisServerUUID cannot be null");
            this.thisServerUUID = thisServerUUID;
            this.masterServerUUID = masterServerUUID;
        }

        public ServerModeOfThisServerChangedEvent(Event event) {
            this(String.valueOf(event.getProperty("thisServerUUID")), String.valueOf(event.getProperty("masterServerUUID")));
        }

        @Override
        public Map<String, Object> asMap() {
            return MapUtil.mapOf("serverMode", this.isNowTheMaster() ? "master" : "slave", "thisServerUUID", this.thisServerUUID, "masterServerUUID", this.masterServerUUID);
        }

        public boolean isNowTheMaster() {
            return Objects.equals(this.thisServerUUID, this.masterServerUUID);
        }

        public boolean isNowASlave() {
            return !this.isNowTheMaster();
        }

        public String getThisServerUUID() {
            return this.thisServerUUID;
        }

        public String getMasterServerUUID() {
            return this.masterServerUUID;
        }
    }
}

