/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class JsonSchemaSettingValidator
implements SettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(JsonSchemaSettingValidator.class);
    protected final BundleContext bundleContext;

    public JsonSchemaSettingValidator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void validateJsonSchemaOfSetting(Setting jsonSetting) throws ValidationException {
        try {
            Set<ValidationMessage> validationMessages = this.validate(jsonSetting, this.bundleContext.getBundle());
            if (validationMessages != null && validationMessages.size() > 0) {
                ValidationMessage firstValidationMessage = (ValidationMessage)validationMessages.stream().findFirst().get();
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "${field}: ${message}", MapUtil.mapOf("field", jsonSetting.getName(), "message", firstValidationMessage.getMessage()));
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to perform the JSON schema validation.", (Throwable)ex);
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<ValidationMessage> validate(Setting setting, Bundle schemaFromBundle) throws JsonProcessingException, FileNotFoundException {
        if (setting == null) return null;
        if (schemaFromBundle == null) return null;
        String jsonSchemaFile = setting.getCustomFields().getStringValue("_schema");
        if (StringUtil.isNullOrEmpty(jsonSchemaFile)) return null;
        if (!jsonSchemaFile.trim().endsWith(".json")) return null;
        try (InputStream jsonSchemaStream = schemaFromBundle.getResource(jsonSchemaFile).openStream();){
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909);
            JsonSchema jsonSchema = factory.getSchema(jsonSchemaStream);
            JsonNode settingValueAsJsonNode = this.getJsonSettingValue(setting);
            if (settingValueAsJsonNode == null) return null;
            Set set = jsonSchema.validate(settingValueAsJsonNode);
            return set;
        }
        catch (JsonProcessingException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new FileNotFoundException(jsonSchemaFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode getJsonSettingValue(Setting jsonSetting) throws JsonProcessingException {
        Object settingValueObject;
        if (jsonSetting != null && ((settingValueObject = jsonSetting.getValue()) instanceof Map || settingValueObject instanceof List)) {
            String settingValueAsString = JsonUtil.getInstance().convertPojoToJsonString(settingValueObject);
            ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
            try {
                JsonNode jsonNode = mapper.readTree(settingValueAsString);
                return jsonNode;
            }
            finally {
                if (mapper != null) {
                    ObjectMapperPool.getInstance().restore((Object)mapper);
                }
            }
        }
        return null;
    }
}

