/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch.querybuilder;

import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilter;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;

public class BpcQueryBuilder {
    private static final Logger LOGGER = LogManager.getLogger(BpcQueryBuilder.class);
    private final List<QueryBuilder> queries = new ArrayList<QueryBuilder>();

    public BpcQueryBuilder() {
    }

    @Deprecated(since="4.1.10", forRemoval=true)
    public BpcQueryBuilder(String index) {
    }

    public BpcQueryBuilder addSkipPercolatorDocumentsQuery() {
        return this.addQueryBuilder(this.getSkipPercolatorDocumentsQuery());
    }

    public BpcQueryBuilder addStringBasedQuery(String query) {
        if (!StringUtil.isNullOrEmpty(query)) {
            return this.addQueryBuilder(this.getStringBasedQuery(query));
        }
        return this;
    }

    public BpcQueryBuilder addQueriesForFilters(String filtersAsJsonArray, BpcIndexMapping indexMapping, String timeZoneId) {
        if (!StringUtil.isNullOrEmpty(filtersAsJsonArray)) {
            try {
                List<BpcDataFilter> filters = BpcDataFilter.fromJsonArray(filtersAsJsonArray);
                return this.addQueryBuilders(this.getQueriesForFilters(filters, indexMapping, timeZoneId));
            }
            catch (Exception ex) {
                LOGGER.error("Parsing a JSON filters string to a BpcDataFilter list failed.", (Throwable)ex);
            }
        }
        return this;
    }

    public BpcQueryBuilder addQueriesForFilters(List<BpcDataFilter> filters, BpcIndexMapping indexMapping, String timeZoneId) {
        return this.addQueryBuilders(this.getQueriesForFilters(filters, indexMapping, timeZoneId));
    }

    public BpcQueryBuilder addQueryForFilter(BpcDataFilter filter, BpcIndexMapping indexMapping, String timeZoneId) {
        return this.addQueryBuilder(this.getQueryForFilter(filter, indexMapping, timeZoneId));
    }

    public BpcQueryBuilder addDateRangeQuery(String dateField, String startDate, String endDate, String timeZoneId) {
        return this.addQueryBuilder(this.getDateRangeQuery(dateField, startDate, endDate, timeZoneId));
    }

    public BpcQueryBuilder addQueryBuilders(List<QueryBuilder> queryBuilders) {
        if (queryBuilders != null) {
            this.queries.addAll(queryBuilders);
        }
        return this;
    }

    public BpcQueryBuilder addQueryBuilder(QueryBuilder query) {
        if (query != null) {
            this.queries.add(query);
        }
        return this;
    }

    public QueryBuilder buildAsBoolMustQuery() {
        LOGGER.info("buildAsBoolMustQuery");
        BoolQueryBuilder finalQuery = QueryBuilders.boolQuery();
        if (!this.queries.isEmpty()) {
            for (QueryBuilder qb : this.queries) {
                finalQuery.must(qb);
            }
        }
        return finalQuery;
    }

    public QueryBuilder buildAsBoolFilterQuery() {
        LOGGER.info("buildAsBoolFilterQuery");
        BoolQueryBuilder finalQuery = QueryBuilders.boolQuery();
        if (!this.queries.isEmpty()) {
            BoolQueryBuilder bqb = QueryBuilders.boolQuery();
            for (QueryBuilder qb : this.queries) {
                bqb.must(qb);
            }
            finalQuery.filter(bqb);
        }
        return finalQuery;
    }

    private QueryBuilder getStringBasedQuery(String query) {
        LOGGER.info("getStringBasedQuery query={}", (Object)query);
        QueryStringQueryBuilder result = null;
        if (!StringUtil.isNullOrEmpty(query)) {
            result = QueryBuilders.queryStringQuery(query).defaultOperator(Operator.AND);
        }
        return result;
    }

    private List<QueryBuilder> getQueriesForFilters(List<BpcDataFilter> filters, BpcIndexMapping indexMapping, String timezoneId) {
        LOGGER.debug("getQueriesForFilters filters={}, indexMapping=..., timezoneId={}", filters, (Object)timezoneId);
        ArrayList<QueryBuilder> result = new ArrayList<QueryBuilder>();
        if (filters != null) {
            for (BpcDataFilter filter : filters) {
                result.add(this.getQueryForFilter(filter, indexMapping, timezoneId));
            }
        }
        return result;
    }

    private QueryBuilder getQueryForFilter(BpcDataFilter filter, BpcIndexMapping indexMapping, String timeZoneId) {
        QueryBuilder query;
        LOGGER.debug("getQueryForFilter filter={}, indexMapping=..., timeZoneId={}", (Object)filter, (Object)timeZoneId);
        if (Arrays.asList("gt", "gte", "lt", "lte", ">", ">=", "<", "<=").contains(filter.getOperator().toLowerCase())) {
            query = this.createRangeQuery(indexMapping, filter.getProperty(), filter.getValue(), filter.getOperator(), timeZoneId);
            LOGGER.debug("add range query: {}", (Object)query);
        } else if (filter.getOperator().equalsIgnoreCase("term")) {
            query = QueryBuilders.termQuery(filter.getProperty(), filter.getValue());
            LOGGER.debug("add term query: {}", (Object)query);
        } else {
            Object property = filter.getProperty();
            String fieldType = indexMapping.getFieldType((String)property);
            boolean textField = fieldType.equalsIgnoreCase("text") || fieldType.equalsIgnoreCase("keyword");
            boolean booleanField = fieldType.equalsIgnoreCase("boolean");
            String source = filter.getSource();
            if (source != null && source.length() > 0 && indexMapping.hasMultiField((String)property, source)) {
                property = (String)property + "." + source;
            }
            if (booleanField) {
                query = QueryBuilders.termQuery((String)property, filter.getValueAsBoolean());
            } else if (filter.hasMultiValues()) {
                BoolQueryBuilder multiQuery = QueryBuilders.boolQuery();
                for (String val : filter.getValues()) {
                    if (textField) {
                        multiQuery.should(this.createTextQuery((String)property, val, source, filter.getOperator()));
                        continue;
                    }
                    multiQuery.should(QueryBuilders.termQuery((String)property, val));
                }
                query = multiQuery;
            } else if (textField) {
                query = this.createTextQuery((String)property, filter.getValue(), source, filter.getOperator());
            } else {
                LOGGER.info("create a simple term query for type {} with property = value", (Object)fieldType);
                query = QueryBuilders.termQuery((String)property, filter.getValue());
            }
        }
        if (filter.isInvert()) {
            query = QueryBuilders.boolQuery().mustNot(query);
        }
        return query;
    }

    private QueryBuilder createRangeQuery(BpcIndexMapping indexMapping, String property, String value, String operator, String timeZoneId) {
        LOGGER.debug("createRangeQuery indexMapping=..., property={}, value=..., operator={}, timeZoneId={}", (Object)property, (Object)operator, (Object)timeZoneId);
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery(property);
        if (!StringUtil.isNullOrEmpty(timeZoneId) && indexMapping.getFieldType(property).equals("date")) {
            rangeQueryBuilder.timeZone(timeZoneId);
        }
        switch (operator) {
            case "gt": 
            case ">": {
                rangeQueryBuilder.gt(value);
                break;
            }
            case "gte": 
            case ">=": {
                rangeQueryBuilder.gte(value);
                break;
            }
            case "lt": 
            case "<": {
                rangeQueryBuilder.lt(value);
                break;
            }
            case "lte": 
            case "<=": {
                rangeQueryBuilder.lte(value);
            }
        }
        return rangeQueryBuilder;
    }

    private QueryBuilder createTextQuery(String property, String value, String source, String operator) {
        LOGGER.info("createTextQuery property={}, value{}=, source={}, operator={}", (Object)property, value, (Object)source, (Object)operator);
        AbstractQueryBuilder q = null;
        if (source == null || !source.equalsIgnoreCase("raw")) {
            value = ((String)value).toLowerCase();
        }
        if (operator.equalsIgnoreCase("=*") && !((String)value).endsWith("*")) {
            value = (String)value + "*";
        }
        if (operator.equalsIgnoreCase("=*") && !((String)value).startsWith("*")) {
            value = "*" + (String)value;
        }
        LOGGER.info("Using as text query value: {}", value);
        if (((String)value).equals("*!*") || ((String)value).equals("!")) {
            q = QueryBuilders.boolQuery().should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery(property))).should(QueryBuilders.termsQuery(property, ""));
        } else if (((String)value).startsWith("*!")) {
            q = QueryBuilders.boolQuery().mustNot(QueryBuilders.wildcardQuery(property, ((String)value).substring(2)));
        } else {
            q = QueryBuilders.wildcardQuery(property, (String)value);
            LOGGER.debug("add  query: {}", (Object)q);
        }
        return q;
    }

    private QueryBuilder getDateRangeQuery(String dateField, String startDate, String endDate, String timezoneId) {
        LOGGER.debug("getDateRangeQuery dateField={}, startDate={}, endDate={}, timezoneId={}", (Object)dateField, (Object)startDate, (Object)endDate, (Object)timezoneId);
        RangeQueryBuilder dateRangeQuery = null;
        if (!StringUtil.isNullOrEmpty(dateField) && !StringUtil.isNullOrEmpty(timezoneId)) {
            if (!StringUtil.isNullOrEmpty(startDate) && !StringUtil.isNullOrEmpty(endDate)) {
                dateRangeQuery = QueryBuilders.rangeQuery(dateField).gte(startDate).lte(endDate).timeZone(timezoneId).format("yyyy-MM-dd HH:mm:ss||strict_date_optional_time||epoch_millis");
            }
            if (StringUtil.isNullOrEmpty(startDate) && !StringUtil.isNullOrEmpty(endDate)) {
                dateRangeQuery = QueryBuilders.rangeQuery(dateField).lt(endDate).timeZone(timezoneId).format("yyyy-MM-dd HH:mm:ss||strict_date_optional_time||epoch_millis");
            }
            if (!StringUtil.isNullOrEmpty(startDate) && StringUtil.isNullOrEmpty(endDate)) {
                dateRangeQuery = QueryBuilders.rangeQuery(dateField).gt(startDate).timeZone(timezoneId).format("yyyy-MM-dd HH:mm:ss||strict_date_optional_time||epoch_millis");
            }
        }
        return dateRangeQuery;
    }

    private QueryBuilder getSkipPercolatorDocumentsQuery() {
        LOGGER.debug("getSkipPercolatorDocumentsQuery");
        return QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("_percolator_query"));
    }
}

