/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.apikey;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.apikey.APIKeyException;
import de.virtimo.bpc.core.apikey.APIKey;
import de.virtimo.bpc.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class APIKeys
implements Iterable<APIKey> {
    private final Map<String, APIKey> apiKeys = new HashMap<String, APIKey>();

    public static APIKeys of(Setting setting) throws APIKeyException {
        Map settingsValue;
        ArrayList<APIKey> apiKeys = new ArrayList<APIKey>();
        if (setting != null && (settingsValue = setting.getSettingValue().asMap()) != null) {
            Map apiKeysMap = settingsValue;
            for (String apiKey : apiKeysMap.keySet()) {
                Map apiKeyValuesMap = (Map)apiKeysMap.get(apiKey);
                apiKeys.add(APIKey.of(apiKey, apiKeyValuesMap));
            }
        }
        return new APIKeys(apiKeys);
    }

    public static boolean fixApiKeyIDs(Setting setting) {
        Map settingsValue;
        boolean updated = false;
        if (setting != null && (settingsValue = setting.getSettingValue().asMap()) != null) {
            Map apiKeysMap = settingsValue;
            for (String apiKey : apiKeysMap.keySet()) {
                Map apiKeyValuesMap = (Map)apiKeysMap.get(apiKey);
                String oldId = MapUtil.getValueAsString(apiKeyValuesMap, "id", null);
                String newId = APIKey.generateId(apiKey);
                if (oldId != null && oldId.equals(newId)) continue;
                updated = true;
                apiKeyValuesMap.put("id", newId);
            }
        }
        return updated;
    }

    public APIKeys(List<APIKey> apiKeys) {
        for (APIKey apiKey : apiKeys) {
            this.apiKeys.put(apiKey.getKey(), apiKey);
        }
    }

    public boolean isEmpty() {
        return this.apiKeys.isEmpty();
    }

    public boolean hasAPIKey(String apiKey) {
        return this.apiKeys.containsKey(apiKey);
    }

    public APIKey getAPIKey(String apiKeyValue) {
        return this.apiKeys.get(apiKeyValue);
    }

    @Override
    @NotNull
    public Iterator<APIKey> iterator() {
        return this.apiKeys.values().iterator();
    }
}

