/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auditlog;

import de.virtimo.bpc.api.AbstractRestoreBackupDoneEventHandler;
import de.virtimo.bpc.api.AbstractRestoreBackupStartEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.auditlog.AuditLogger;
import de.virtimo.bpc.api.auditlog.AuditLoggerException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.osgi.framework.BundleContext;

public class OpenSearchAuditLogger
implements AuditLogger {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchAuditLogger.class);
    public static final String INDEX_NAME = "bpc-auditlog";
    private ScheduledExecutorService executorService;
    private final int cleanupPeriodInMinutes;
    private final String deleteEntriesOlderThan;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private final EventRegistration eventRegistration;
    private boolean bpcAuditlogIndexRestoreInProgress = false;

    public OpenSearchAuditLogger(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.cleanupPeriodInMinutes = coreBundleConfiguration.getSystemPropertyValueAsInt(OpenSearchAuditLogger.class.getName() + ".auditlog.cleanupPeriodInMinutes", -1);
        this.deleteEntriesOlderThan = coreBundleConfiguration.getSystemPropertyValueAsString(OpenSearchAuditLogger.class.getName() + ".auditlog.deleteEntriesOlderThan", null);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-auditlog-opensearch"));
        this.startAuditLoggerIndexCleanupTask();
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forRestoreBackupStartEvents(new RestoreBackupStartEventHandler());
        this.eventRegistration.forRestoreBackupDoneEvents(new RestoreBackupDoneEventHandler());
    }

    @Override
    public AuditLogLevel getDefaultAuditLogLevel() {
        return AuditLogLevel.INFO;
    }

    @Override
    public void stop() {
        LOGGER.info("stop");
        this.stopAuditLoggerIndexCleanupTask();
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.executorService = null;
            }
            catch (InterruptedException | RuntimeException ex) {
                LOGGER.error("Could not shutdown the audit log cleanup task");
            }
        }
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public FutureTask<Exception> log(List<Map<String, Object>> logEntries) throws AuditLoggerException {
        LOGGER.info("log logEntries=...");
        if (logEntries == null || logEntries.isEmpty()) {
            return null;
        }
        if (this.bpcAuditlogIndexRestoreInProgress) {
            LOGGER.warn("Audit logging is ignored while a audit log backup gets restored.");
            return null;
        }
        try {
            final OpenSearchService oss = this.openSearchServiceTracker.getService();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (Map<String, Object> logEntry : logEntries) {
                bulkRequest.add(new IndexRequest(INDEX_NAME).source(logEntry, (MediaType)XContentType.JSON));
            }
            final BulkResponse bulkResponse = oss.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "Audit log bulk indexing failed: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        OpenSearchAuditLogger.this.percolatorsManagerTracker.getService().informClientsAboutReplicatedData(oss, OpenSearchAuditLogger.INDEX_NAME, bulkResponse);
                        return null;
                    }
                    catch (ServiceNotFoundException ex) {
                        LOGGER.warn("Failed to inform clients about new log entry. Can be ignored when a shutdown is in progress.");
                        return ex;
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        return ex;
                    }
                }
            });
        }
        catch (AuditLoggerException ex) {
            throw ex;
        }
        catch (ServiceNotFoundException ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "OpenSearchService is not registered.");
        }
        catch (OpenSearchRelatedException ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "Audit log indexing failed: ${error}", MapUtil.mapOf("error", ex.getMessage()));
        }
        catch (Exception ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, (Throwable)ex);
        }
    }

    private void stopAuditLoggerIndexCleanupTask() {
        LOGGER.info("stopAuditLoggerIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_NAME);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to stop/cancel the running cleanup task for the index 'bpc-auditlog'.", (Throwable)ex);
        }
    }

    private void startAuditLoggerIndexCleanupTask() {
        LOGGER.info("startAuditLoggerIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_NAME, "timestamp", this.deleteEntriesOlderThan, this.cleanupPeriodInMinutes, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to schedule the index cleanup task for the index 'bpc-auditlog'.", (Throwable)ex);
        }
    }

    private class RestoreBackupStartEventHandler
    extends AbstractRestoreBackupStartEventHandler {
        private RestoreBackupStartEventHandler() {
        }

        @Override
        public void processRestoreBackupStartEvent(AbstractRestoreBackupStartEventHandler.RestoreBackupStartEvent restoreBackupStartEvent) {
            LOGGER.info("{}.processRestoreBackupStartEvent restoreBackupStartEvent=...", (Object)this.getClass().getSimpleName());
            if (restoreBackupStartEvent.containsAlias(OpenSearchAuditLogger.INDEX_NAME)) {
                OpenSearchAuditLogger.this.bpcAuditlogIndexRestoreInProgress = true;
            }
        }
    }

    private class RestoreBackupDoneEventHandler
    extends AbstractRestoreBackupDoneEventHandler {
        private RestoreBackupDoneEventHandler() {
        }

        @Override
        public void processRestoreBackupDoneEvent(AbstractRestoreBackupDoneEventHandler.RestoreBackupDoneEvent restoreBackupDoneEvent) {
            LOGGER.info("{}.processRestoreBackupDoneEvent restoreBackupDoneEvent=...", (Object)this.getClass().getSimpleName());
            if (restoreBackupDoneEvent.containsAlias(OpenSearchAuditLogger.INDEX_NAME)) {
                OpenSearchAuditLogger.this.bpcAuditlogIndexRestoreInProgress = false;
            }
        }
    }
}

