/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.core.auth.IdentityProviderMappings;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationImpl;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import java.util.List;
import java.util.Map;

public class IdentityProviderConfiguration {
    private final ModuleConfiguration moduleConfiguration;

    public IdentityProviderConfiguration(Map<String, Setting> settings) {
        this.moduleConfiguration = new SimpleModuleConfig(settings);
    }

    public IdentityProviderConfiguration(ModuleConfiguration moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public String getInstanceId() {
        if (this.moduleConfiguration instanceof ModuleConfigurationImpl) {
            return ((ModuleConfigurationImpl)this.moduleConfiguration).getInstanceId();
        }
        return null;
    }

    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public String getIdentityProviderName() {
        return this.moduleConfiguration.getSettingValue("identityProvider").asString("karaf");
    }

    public String getIdentityProviderHealthCheckUrl() {
        return this.moduleConfiguration.getSettingValue("identityProvider_healthEndpoint").asString(null);
    }

    public int getSessionExpirationInMinutes() {
        return this.moduleConfiguration.getSettingValue("identityProvider_sessionExpirationMinutes").asInt(480);
    }

    public IdentityProviderMappings getIdentityProviderMappings() {
        Map identityProviderMappingsMap = this.moduleConfiguration.getSettingValue("identityProvider_mappings").asMap(null);
        return identityProviderMappingsMap == null ? null : new IdentityProviderMappings(identityProviderMappingsMap);
    }

    public String getUserSelfServiceUrl() {
        return this.moduleConfiguration.getSettingValue("identityProvider_ussUrl").asString(null);
    }

    public String getPasswordValidationRegExp() {
        return this.moduleConfiguration.getSettingValue("identityProvider_pwdValidationRegExp").asString(null);
    }

    public boolean isFetchAdditionalInfoEnabled() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoEnabled").asBoolean(false);
    }

    public String getFetchAdditionalInfoEntriesPrefix() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoEntriesPrefix").asString();
    }

    public String getFetchAdditionalInfoUrl() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoUrl").asString(null);
    }

    public String getFetchAdditionalInfoUrlBasicAuthUsername() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoUrlBasicAuthUsername").asString(null);
    }

    public String getFetchAdditionalInfoUrlBasicAuthPassword() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoUrlBasicAuthPassword").asString(null);
    }

    public String getJdbcDatasource() {
        return this.moduleConfiguration.getSettingValue("identityProvider_jdbc_dataSource").asString(null);
    }

    public String getInubitUrl() {
        return this.moduleConfiguration.getSettingValue("identityProvider_inubit_url").asString(null);
    }

    public String getOidcClientId() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_clientId").asTrimmedString(null);
    }

    public String getOidcClientSecret() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_clientSecret").asTrimmedString(null);
    }

    public String getOidcScope() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_scope").asTrimmedString(null);
    }

    public String getOidcClaimNameRoles() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_claimNameRoles").asTrimmedString(null);
    }

    public String getOidcClaimNameOrganisations() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_claimNameOrganisations").asTrimmedString(null);
    }

    public String getOidcClaimNameRights() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_claimNameRights").asTrimmedString(null);
    }

    public List<Map<String, Object>> getOidcMetadataDiscoveryUri() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_metadataDiscoveryUri").asList();
    }

    public List<Map<String, Object>> getOidcPostAuthenticationRedirectUri() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_postAuthenticationRedirectUri").asList();
    }

    public List<Map<String, Object>> getOidcPostLogoutRedirectUri() {
        return this.moduleConfiguration.getSettingValue("identityProvider_oidc_postLogoutRedirectUri").asList();
    }
}

