/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.util.StringUtil;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class UserIdentification {
    private final String remoteHost;
    private final String remoteAddress;
    private final String forwardedForAddress;
    private final String forwardedForHttpHeaderName;

    public UserIdentification(HttpServletRequest httpServletRequest, String forwardedForHttpHeaderName) {
        this.remoteHost = httpServletRequest.getRemoteHost();
        this.remoteAddress = httpServletRequest.getRemoteAddr();
        this.forwardedForHttpHeaderName = forwardedForHttpHeaderName;
        this.forwardedForAddress = httpServletRequest.getHeader(forwardedForHttpHeaderName);
    }

    @JsonProperty(value="host")
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @JsonProperty(value="address")
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @JsonProperty(value="forwardedFor")
    public String getForwardedForAddress() {
        return this.forwardedForAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIdentification that = (UserIdentification)o;
        if (!StringUtil.isNullOrEmpty(this.forwardedForAddress)) {
            return Objects.equals(this.forwardedForAddress, that.forwardedForAddress);
        }
        return this.remoteHost.equals(that.remoteHost) && this.remoteAddress.equals(that.remoteAddress);
    }

    public int hashCode() {
        return Objects.hash(this.remoteHost, this.remoteAddress, this.forwardedForAddress);
    }

    public String toString() {
        return "[host:" + this.remoteHost + "] [ip:" + this.remoteAddress + "] [" + this.forwardedForHttpHeaderName + ":" + this.forwardedForAddress + "]";
    }
}

