/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.jdbc;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.core.auth.UserFactory;
import de.virtimo.bpc.core.auth.jaas.BackingEngineDataConverter;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCQueriesConfiguration;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCUtils;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.StringUtil;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JDBCBackingEngine
implements BackingEngine,
IdentityManager {
    private static final Logger LOGGER = LogManager.getLogger(JDBCBackingEngine.class);
    private final DataSource dataSource;
    private final EncryptionSupport encryptionSupport;
    private final JDBCQueriesConfiguration queries;

    public JDBCBackingEngine(DataSource dataSource, EncryptionSupport encryptionSupport, JDBCQueriesConfiguration queries) {
        this.dataSource = dataSource;
        this.encryptionSupport = encryptionSupport;
        this.queries = queries;
    }

    @Override
    public void destroy() {
        LOGGER.debug("destroy");
    }

    private User _createUserFromRecord(Map<String, String> record) {
        return UserFactory.getUser(record.get("USERNAME"), record.get("FIRSTNAME") + " " + record.get("LASTNAME"), record.get("FIRSTNAME"), record.get("LASTNAME"), record.get("EMAIL"));
    }

    @Override
    public User getUser(String userName) throws IdentityManagerException {
        return this.getUser(null, userName);
    }

    @Override
    public User getUser(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        Iterator<Map<String, String>> iterator;
        block9: {
            LOGGER.info("getUser requestingUserSession={}, userName={}", (Object)requestingUserSession, (Object)userId);
            Connection connection = this.dataSource.getConnection();
            try {
                ArrayList<User> users = new ArrayList<User>();
                iterator = JDBCUtils.rawRecordSelect(connection, this.queries.getQuery("query.user"), userId).iterator();
                while (iterator.hasNext()) {
                    Map<String, String> record = iterator.next();
                    users.add(this._createUserFromRecord(record));
                }
                Iterator<Map<String, String>> iterator2 = iterator = users.isEmpty() ? null : (User)users.get(0);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER", e);
                }
            }
            connection.close();
        }
        return iterator;
    }

    @Override
    public List<User> getUsers() throws IdentityManagerException {
        return this.getUsers(null);
    }

    @Override
    public List<User> getUsers(UserSession requestingUserSession) throws IdentityManagerException {
        ArrayList<User> arrayList;
        block9: {
            LOGGER.info("getUsers");
            Connection connection = this.dataSource.getConnection();
            try {
                ArrayList<User> users = new ArrayList<User>();
                for (Map<String, String> record : JDBCUtils.rawRecordSelect(connection, this.queries.getQuery("query.users"), new String[0])) {
                    users.add(this._createUserFromRecord(record));
                }
                arrayList = users;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USERS", e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    @Override
    public Set<Organisation> getOrganisations() throws IdentityManagerException {
        return this.getOrganisations(null);
    }

    @Override
    public Set<Organisation> getOrganisations(UserSession requestingUserSession) throws IdentityManagerException {
        LOGGER.info("getOrganisations");
        return BackingEngineDataConverter.getOrganisations(this);
    }

    @Override
    public Set<Role> getRoles() throws IdentityManagerException {
        return this.getRoles(null);
    }

    @Override
    public Set<Role> getRoles(UserSession requestingUserSession) throws IdentityManagerException {
        LOGGER.info("getRoles");
        return BackingEngineDataConverter.asRoles(this.listRoles());
    }

    @Override
    public Set<Right> getRights() throws IdentityManagerException {
        return this.getRights(null);
    }

    @Override
    public Set<Right> getRights(UserSession requestingUserSession) throws IdentityManagerException {
        LOGGER.info("getRights");
        throw new UnsupportedOperationException("Get rights is not supported by this identity provider.");
    }

    @Override
    public Set<Organisation> getUserOrganisations(String userId) throws IdentityManagerException {
        return this.getUserOrganisations(null, userId);
    }

    @Override
    public Set<Organisation> getUserOrganisations(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.info("getUserOrganisations requestingUserSession={}, userId={}", (Object)requestingUserSession, (Object)userId);
        return BackingEngineDataConverter.getUserOrganisations(this, userId, false);
    }

    @Override
    public Set<Role> getUserRoles(String userId) throws IdentityManagerException {
        return this.getUserRoles(null, userId);
    }

    @Override
    public Set<Role> getUserRoles(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.info("getUserRoles requestingUserSession={}, userId={}", (Object)requestingUserSession, (Object)userId);
        return BackingEngineDataConverter.getUserRoles(this, userId, false);
    }

    @Override
    public Set<Right> getUserRights(String userId) throws IdentityManagerException {
        return this.getUserRights(null, userId);
    }

    @Override
    public Set<Right> getUserRights(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.info("getUserRights requestingUserSession={}, userId={}", (Object)requestingUserSession, (Object)userId);
        throw new UnsupportedOperationException("Get user rights is not supported by this identity provider.");
    }

    @Override
    public void addUser(String username, String password) {
        try {
            this.addUser(null, username, password);
        }
        catch (IdentityManagerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addUser(UserSession requestingUserSession, String userId, String userPassword) throws IdentityManagerException {
        LOGGER.info("addUser requestingUserSession={}, username={}, password=...", (Object)requestingUserSession, (Object)userId);
        try {
            this.addUser(userId, userPassword, "", "", "");
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error adding user", ex);
        }
    }

    @Override
    public void addUser(User user, String userPassword) throws IdentityManagerException {
        this.addUser(null, user, userPassword);
    }

    @Override
    public void addUser(UserSession requestingUserSession, User user, String userPassword) throws IdentityManagerException {
        LOGGER.info("addUser requestingUserSession={}, user={}, userPassword=...", (Object)requestingUserSession, (Object)user);
        try {
            this.addUser(user.getId(), userPassword, user.getFirstName(), user.getLastName(), user.getEmail());
        }
        catch (SQLException ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER", ex);
        }
    }

    private void addUser(String username, String password, String firstName, String lastName, String email) throws SQLException {
        LOGGER.info("addUser username={}, password=..., firstName={}, lastName={}, email={}", (Object)username, (Object)firstName, (Object)lastName, (Object)email);
        String encPassword = this.encrypt(password);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("insert.user"), username, encPassword, firstName, lastName, email);
        }
    }

    @Override
    public void addOrganisation(String userId, String orgName) throws IdentityManagerException {
        this.addOrganisation(null, userId, orgName);
    }

    @Override
    public void addOrganisation(UserSession requestingUserSession, String userId, String orgName) throws IdentityManagerException {
        LOGGER.info("addOrganisation requestingUserSession={}, userId={}, orgName={}", (Object)requestingUserSession, (Object)userId, (Object)orgName);
        this.addGroup(userId, orgName);
    }

    @Override
    public void addRight(String userId, String rightName) throws IdentityManagerException {
        this.addRight(null, userId, rightName);
    }

    @Override
    public void addRight(UserSession requestingUserSession, String userId, String rightName) throws IdentityManagerException {
        LOGGER.info("addRight requestingUserSession={}, userId={}, rightName={}", (Object)requestingUserSession, (Object)userId, (Object)rightName);
        throw new UnsupportedOperationException("Adding right to users is not supported by this identity provider.");
    }

    public void updatePassword(String username, String password) {
        LOGGER.info("updatePassword username={}, password=...", (Object)username);
        String encPassword = this.encrypt(password);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("update.pwd"), encPassword, username);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error updating password", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkPassword(String username, String password) {
        LOGGER.info("checkPassword username={}, password=...", (Object)username);
        try (Connection connection = this.dataSource.getConnection();){
            List<String> passwords = JDBCUtils.rawSelect(connection, this.queries.getQuery("query.pwd"), username);
            if (passwords.isEmpty()) {
                boolean bl2 = false;
                return bl2;
            }
            String passwordFromDatabase = passwords.get(0);
            boolean bl = this.encryptionSupport.checkPassword(password, passwordFromDatabase);
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting user password", e);
        }
    }

    private String encrypt(String password) {
        Encryption encryption;
        String encryptedPassword = this.encryptionSupport.encrypt(password);
        if (!StringUtil.isNullOrEmpty(password) && password.equals(encryptedPassword) && (encryption = this.encryptionSupport.getEncryption()) != null) {
            encryptedPassword = encryption.encryptPassword(password);
        }
        return encryptedPassword;
    }

    @Override
    public void deleteUser(String username) {
        try {
            this.deleteUser(null, username);
        }
        catch (IdentityManagerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteUser(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.info("deleteUser requestingUserSession={}, username={}", (Object)requestingUserSession, (Object)userId);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.roles"), userId);
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.groups"), userId);
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.user"), userId);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting user", e);
        }
    }

    @Override
    public void deleteOrganisation(String userId, String orgName) throws IdentityManagerException {
        this.deleteOrganisation(null, userId, orgName);
    }

    @Override
    public void deleteOrganisation(UserSession requestingUserSession, String userId, String orgName) throws IdentityManagerException {
        LOGGER.info("deleteOrganisation requestingUserSession={}, userId={}, orgName={}", (Object)requestingUserSession, (Object)userId, (Object)orgName);
        this.deleteGroup(userId, orgName);
    }

    public List<UserPrincipal> listUsers() {
        ArrayList<UserPrincipal> arrayList;
        block9: {
            LOGGER.info("listUsers");
            Connection connection = this.dataSource.getConnection();
            try {
                ArrayList<UserPrincipal> users = new ArrayList<UserPrincipal>();
                for (String name : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.users"), new String[0])) {
                    users.add(new UserPrincipal(name));
                }
                arrayList = users;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error listing users", e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserPrincipal lookupUser(String username) {
        LOGGER.info("lookupUser username={}", (Object)username);
        try (Connection connection = this.dataSource.getConnection();){
            List<Map<String, String>> select = JDBCUtils.rawRecordSelect(connection, this.queries.getQuery("query.user"), username);
            if (select.size() == 0) {
                UserPrincipal userPrincipal2 = null;
                return userPrincipal2;
            }
            UserPrincipal userPrincipal = new UserPrincipal(username);
            return userPrincipal;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting user", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RolePrincipal> listRoles(Principal principal) {
        LOGGER.info("listRoles principal={}", (Object)principal);
        try (Connection connection = this.dataSource.getConnection();){
            if (principal instanceof GroupPrincipal) {
                List<RolePrincipal> list2 = this.listRoles(connection, "_g_:" + principal.getName());
                return list2;
            }
            List<RolePrincipal> list = this.listRoles(connection, principal.getName());
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing roles", e);
        }
    }

    private List<RolePrincipal> listRoles(Connection connection, String name) throws SQLException {
        LOGGER.info("listRoles connection=..., name={}", (Object)name);
        ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
        for (String role : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.roles_of_user_or_group"), name)) {
            if (role.startsWith("_g_:")) {
                roles.addAll(this.listRoles(connection, role));
                continue;
            }
            roles.add(new RolePrincipal(role));
        }
        return roles;
    }

    private List<RolePrincipal> listRoles() {
        LOGGER.info("listRoles");
        try {
            ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
            try (Connection connection = this.dataSource.getConnection();){
                for (String name : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.roles"), new String[0])) {
                    roles.add(new RolePrincipal(name));
                }
            }
            return roles;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing roles", e);
        }
    }

    @Override
    public void addRole(String username, String role) {
        try {
            this.addRole(null, username, role);
        }
        catch (IdentityManagerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addRole(UserSession requestingUserSession, String userId, String roleName) throws IdentityManagerException {
        LOGGER.info("addRole requestingUserSession={}, userId={}, roleName={}", (Object)requestingUserSession, (Object)userId, (Object)roleName);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("insert.role"), userId, roleName);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error adding role to user", e);
        }
    }

    @Override
    public void addOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        this.addOrganisationRole(null, orgName, roleName);
    }

    @Override
    public void addOrganisationRole(UserSession requestingUserSession, String orgName, String roleName) throws IdentityManagerException {
        LOGGER.info("addOrganisationRole requestingUserSession={}, orgName={}, roleName={}", (Object)requestingUserSession, (Object)orgName, (Object)roleName);
        this.addGroupRole(orgName, roleName);
    }

    @Override
    public void deleteRole(String username, String role) {
        try {
            this.deleteRole(null, username, role);
        }
        catch (IdentityManagerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteRole(UserSession requestingUserSession, String userId, String roleName) throws IdentityManagerException {
        LOGGER.info("deleteRole requestingUserSession={}, userId={}, roleName={}", (Object)requestingUserSession, (Object)userId, (Object)roleName);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.role"), userId, roleName);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting role from user", e);
        }
    }

    @Override
    public void deleteOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        this.deleteOrganisationRole(null, orgName, roleName);
    }

    @Override
    public void deleteOrganisationRole(UserSession requestingUserSession, String orgName, String roleName) throws IdentityManagerException {
        LOGGER.info("deleteOrganisationRole requestingUserSession={}, orgName={}, roleName={}", (Object)requestingUserSession, (Object)orgName, (Object)roleName);
        this.deleteGroupRole(orgName, roleName);
    }

    @Override
    public void deleteRight(String userId, String rightName) throws IdentityManagerException {
        LOGGER.info("deleteRight userId={}, rightName={}", (Object)userId, (Object)rightName);
        throw new UnsupportedOperationException("Delete user right is not supported by this identity provider.");
    }

    @Override
    public void deleteRight(UserSession requestingUserSession, String userId, String rightName) throws IdentityManagerException {
        throw new UnsupportedOperationException("Delete user right is not supported by this identity provider.");
    }

    @Override
    public void updateUser(User user) throws IdentityManagerException {
        this.updateUser(null, user);
    }

    @Override
    public void updateUser(UserSession requestingUserSession, User user) throws IdentityManagerException {
        LOGGER.info("updateUser requestingUserSession={}, user=...", (Object)requestingUserSession);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("update.user"), user.getFirstName(), user.getLastName(), user.getEmail(), user.getId());
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER", e);
        }
    }

    @Override
    public void updateUserPassword(String userId, String userPassword) throws IdentityManagerException {
        LOGGER.info("updateUserPassword userId={}, userPassword=...", (Object)userId);
        this.updatePassword(userId, userPassword);
    }

    @Override
    public void updateUserPassword(UserSession requestingUserSession, String userId, String userPassword) throws IdentityManagerException {
        LOGGER.info("updateUserPassword requestingUserSession={}, userId={}, userPassword=...", (Object)requestingUserSession, (Object)userId);
        this.updatePassword(userId, userPassword);
    }

    @Override
    public boolean checkUserPassword(String userId, String userPassword) throws IdentityManagerException {
        return this.checkPassword(userId, userPassword);
    }

    @Override
    public boolean checkUserPassword(UserSession requestingUserSession, String userId, String userPassword) throws IdentityManagerException {
        LOGGER.info("checkUserPassword requestingUserSession={}, userId={}, userPassword=...", (Object)requestingUserSession, (Object)userId);
        return this.checkPassword(userId, userPassword);
    }

    public List<GroupPrincipal> listGroups(UserPrincipal principal) {
        ArrayList<GroupPrincipal> arrayList;
        block9: {
            LOGGER.info("listGroups principal={}", (Object)principal);
            Connection connection = this.dataSource.getConnection();
            try {
                ArrayList<GroupPrincipal> groups = new ArrayList<GroupPrincipal>();
                for (String group : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.groups_of_user"), principal.getName())) {
                    groups.add(new GroupPrincipal(group));
                }
                arrayList = groups;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error listing groups", e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    public void addGroup(String username, String groupName) {
        LOGGER.info("addGroup username={}, groupName={}", (Object)username, (Object)groupName);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("insert.group"), username, groupName);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error adding user to group", (Throwable)e);
        }
    }

    public void deleteGroup(String username, String group) {
        LOGGER.info("deleteGroup username={}, group={}", (Object)username, (Object)group);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.role"), username, "_g_:" + group);
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.group"), username, group);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error deleting user from group", (Throwable)e);
        }
    }

    public void addGroupRole(String group, String role) {
        LOGGER.info("addGroupRole group={}, role={}", (Object)group, (Object)role);
        this.addRole("_g_:" + group, role);
    }

    public void deleteGroupRole(String group, String role) {
        LOGGER.info("deleteGroupRole group={}, role={}", (Object)group, (Object)role);
        this.deleteRole("_g_:" + group, role);
    }

    public Map<GroupPrincipal, String> listGroups() {
        HashMap<GroupPrincipal, String> hashMap;
        block9: {
            LOGGER.info("listGroups");
            Connection connection = this.dataSource.getConnection();
            try {
                HashMap<GroupPrincipal, String> result = new HashMap<GroupPrincipal, String>();
                for (String group : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.groups"), new String[0])) {
                    result.put(new GroupPrincipal(group), StringUtil.implode(",", JDBCUtils.rawSelect(connection, this.queries.getQuery("query.roles_of_user_or_group"), "_g_:" + group)));
                }
                hashMap = result;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error listing groups", e);
                }
            }
            connection.close();
        }
        return hashMap;
    }

    public void createGroup(String group) {
        LOGGER.info("createGroup group={}", (Object)group);
        throw new UnsupportedOperationException("Create group is not supported by this identity provider.");
    }
}

