/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.keycloak;

import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.auth.UserNotFoundException;
import de.virtimo.bpc.core.auth.keycloak.KeycloakApi;
import de.virtimo.bpc.core.auth.keycloak.KeycloakException;
import de.virtimo.bpc.core.utils.RestWebServiceClientInitException;
import de.virtimo.bpc.util.ListUtil;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeycloakAdminApi {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakAdminApi.class);
    private static final int MAX_ENTITY_GET_VALUE = 1000000;

    public static Map<String, Object> getClient(String oidcDiscoveryUrl, UserSession userSession, String clientId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("getClient oidcDiscoveryUrl={}, userSession={}, clientId={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)clientId);
        List<Map<String, Object>> foundClients = KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/clients", MapUtil.mapOf("clientId", clientId));
        return foundClients != null && foundClients.size() == 1 ? foundClients.get(0) : null;
    }

    public static List<Map<String, Object>> getUsers(String oidcDiscoveryUrl, UserSession userSession) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("getUsers oidcDiscoveryUrl={}, userSession={}", (Object)oidcDiscoveryUrl, (Object)userSession);
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users", MapUtil.mapOf("max", 1000000));
    }

    public static List<Map<String, Object>> getUsers(String oidcDiscoveryUrl, UserSession userSession, long offset, long limit) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("getUsers oidcDiscoveryUrl={}, userSession={}, offset={}, limit={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)offset, (Object)limit);
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users", MapUtil.mapOf("briefRepresentation", Boolean.FALSE, "first", offset, "max", limit));
    }

    public static Map<String, Object> getUserByUserName(String oidcDiscoveryUrl, UserSession userSession, String username) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("getUserByUserName oidcDiscoveryUrl={}, userSession={}, username={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)username);
        username = username != null ? username.toLowerCase() : null;
        List<Map<String, Object>> foundUsers = KeycloakAdminApi.getUsersByByFilter(oidcDiscoveryUrl, userSession, MapUtil.mapOf("username", username));
        return foundUsers.size() == 1 ? foundUsers.get(0) : null;
    }

    public static List<Map<String, Object>> getGroups(String oidcDiscoveryUrl, UserSession userSession) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("getGroups oidcDiscoveryUrl={}, userSession={}", (Object)oidcDiscoveryUrl, (Object)userSession);
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/groups", MapUtil.mapOf("max", 1000000));
    }

    public static List<Map<String, Object>> getUserGroups(String oidcDiscoveryUrl, UserSession userSession, String userId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException, UserNotFoundException {
        LOGGER.info("getUserGroups oidcDiscoveryUrl={}, userSession={}, userId={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId);
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users/" + KeycloakAdminApi.getKeycloakUserIdByUsername(oidcDiscoveryUrl, userSession, userId) + "/groups", MapUtil.mapOf("max", 1000000));
    }

    public static List<Map<String, Object>> getRealmRoles(String oidcDiscoveryUrl, UserSession userSession) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("getRealmRoles oidcDiscoveryUrl={}, userSession={}", (Object)oidcDiscoveryUrl, (Object)userSession);
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/roles", null);
    }

    public static List<Map<String, Object>> getClientRoles(String oidcDiscoveryUrl, UserSession userSession, String clientId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("getClientRoles oidcDiscoveryUrl={}, userSession={}, clientId={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)clientId);
        String keycloakInternalClientId = (String)Objects.requireNonNull(KeycloakAdminApi.getClient(oidcDiscoveryUrl, userSession, clientId)).get("id");
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/clients/" + keycloakInternalClientId + "/roles", null);
    }

    public static List<Map<String, Object>> getUserRealmRoles(String oidcDiscoveryUrl, UserSession userSession, String userId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException, UserNotFoundException {
        LOGGER.info("getUserRealmRoles oidcDiscoveryUrl={}, userSession={}, userId={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId);
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users/" + KeycloakAdminApi.getKeycloakUserIdByUsername(oidcDiscoveryUrl, userSession, userId) + "/role-mappings/realm/composite", null);
    }

    public static List<Map<String, Object>> getUserClientRoles(String oidcDiscoveryUrl, UserSession userSession, String userId, String clientId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException, UserNotFoundException {
        LOGGER.info("getUserClientRoles oidcDiscoveryUrl={}, userSession={}, userId={}, clientId={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId, (Object)clientId);
        String keycloakInternalClientId = (String)Objects.requireNonNull(KeycloakAdminApi.getClient(oidcDiscoveryUrl, userSession, clientId)).get("id");
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users/" + KeycloakAdminApi.getKeycloakUserIdByUsername(oidcDiscoveryUrl, userSession, userId) + "/role-mappings/clients/" + keycloakInternalClientId + "/composite", null);
    }

    public static void updateUser(String oidcDiscoveryUrl, UserSession userSession, String userId, String firstName, String lastName, String email) throws UserNotFoundException, KeycloakException, IOException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException {
        LOGGER.info("updateUser oidcDiscoveryUrl={}, userSession={}, userId={}, firstName={}, lastName={}, email={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId, (Object)firstName, (Object)lastName, (Object)email);
        KeycloakApi.doPutRequest(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users/" + KeycloakAdminApi.getKeycloakUserIdByUsername(oidcDiscoveryUrl, userSession, userId), null, MapUtil.mapOf("firstName", firstName, "lastName", lastName, "email", email));
    }

    public static void updateUserAttributes(String oidcDiscoveryUrl, UserSession userSession, String userId, Map<String, Object> userAttributes) throws UserNotFoundException, KeycloakException, IOException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException {
        LOGGER.info("updateUserAttributes oidcDiscoveryUrl={}, userSession={}, userId={}, userAttributes={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId, userAttributes);
        KeycloakApi.doPutRequest(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users/" + KeycloakAdminApi.getKeycloakUserIdByUsername(oidcDiscoveryUrl, userSession, userId), null, MapUtil.mapOf("attributes", userAttributes, "firstName", userSession.getFirstName(), "lastName", userSession.getLastName(), "email", userSession.getEmail()));
    }

    public static void updateUserPassword(String oidcDiscoveryUrl, UserSession userSession, String userId, String newUserPassword) throws UserNotFoundException, KeycloakException, IOException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException {
        LOGGER.info("updateUserPassword oidcDiscoveryUrl={}, userSession={}, userId={}, newUserPassword=*", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId);
        KeycloakApi.doPutRequest(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users/" + KeycloakAdminApi.getKeycloakUserIdByUsername(oidcDiscoveryUrl, userSession, userId) + "/reset-password", null, MapUtil.mapOf("value", newUserPassword, "type", "password", "temporary", false));
    }

    public static void deleteUser(String oidcDiscoveryUrl, UserSession userSession, String userId) throws UserNotFoundException, KeycloakException, IOException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException {
        LOGGER.info("deleteUser oidcDiscoveryUrl={}, userSession={}, userId={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId);
        KeycloakApi.doDeleteRequest(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users/" + KeycloakAdminApi.getKeycloakUserIdByUsername(oidcDiscoveryUrl, userSession, userId), null);
    }

    public static void createUser(String oidcDiscoveryUrl, UserSession userSession, String userId, String firstName, String lastName, String email, String password) throws UserNotFoundException, KeycloakException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException {
        LOGGER.info("createUser oidcDiscoveryUrl={}, userSession={}, userId={}, firstName={}, lastName={}, email={}, password=*", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId, (Object)firstName, (Object)lastName, (Object)email);
        KeycloakApi.doPostRequest(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users", null, MapUtil.mapOf("username", userId, "firstName", firstName, "lastName", lastName, "email", email, "enabled", true, "credentials", ListUtil.listOf(MapUtil.mapOf("type", "password", "value", password, "temporary", false))));
    }

    private static String getKeycloakUserIdByUsername(String oidcDiscoveryUrl, UserSession userSession, String userId) throws KeycloakException, IOException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException, UserNotFoundException {
        Map<String, Object> user = KeycloakAdminApi.getUserByUserName(oidcDiscoveryUrl, userSession, userId);
        if (user != null) {
            return (String)user.get("id");
        }
        throw new UserNotFoundException(userId);
    }

    private static List<Map<String, Object>> getUsersByByFilter(String oidcDiscoveryUrl, UserSession userSession, Map<String, Object> filter) throws KeycloakException, IOException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException {
        LOGGER.info("getUsersByByFilter oidcDiscoveryUrl={}, userSession=..., filter={}", (Object)oidcDiscoveryUrl, filter);
        Map<String, Object> userFiler = MapUtil.mapOf("max", 1000000, "exact", true);
        userFiler.putAll(filter);
        return KeycloakApi.doGetRequestAsList(userSession, KeycloakAdminApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/users", userFiler);
    }

    static String getServerUrlFromOidcDiscoveryUrl(String oidcDiscoveryUrl) {
        return oidcDiscoveryUrl.substring(0, oidcDiscoveryUrl.indexOf("/realms/")) + "/admin/realms/" + KeycloakApi.getRealmFromOidcDiscoveryUrl(oidcDiscoveryUrl);
    }
}

