/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.keycloak;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.auth.keycloak.KeycloakException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.core.utils.RestWebServiceClientInitException;
import de.virtimo.bpc.util.JacksonJsonProvider;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeycloakApi {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakApi.class);
    private static final Object KEYCLOAK_CALLS_LOCK = new Object();

    static String getRealmFromOidcDiscoveryUrl(String oidcDiscoveryUrl) {
        return oidcDiscoveryUrl.substring(oidcDiscoveryUrl.indexOf("/realms/") + "/realms/".length(), oidcDiscoveryUrl.indexOf("/.well-known/"));
    }

    static List<Map<String, Object>> doGetRequestAsList(UserSession userSession, String endpointUri, Map<String, Object> queryParams) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("doGetRequestAsList endpointUri={}, queryParams={}", (Object)endpointUri, queryParams);
        String respAsString = KeycloakApi.doGetRequest(userSession, endpointUri, queryParams);
        return JsonUtil.getInstance().jsonStringAsList(respAsString);
    }

    private static String doGetRequest(UserSession userSession, String endpointUri, Map<String, Object> queryParams) throws InterruptedException, ExecutionException, TimeoutException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("doGetRequest endpointUri={}, queryParams={}", (Object)endpointUri, queryParams);
        return KeycloakApi.callApi(userSession, endpointUri, queryParams, "GET", null);
    }

    static String doPutRequest(UserSession userSession, String endpointUri, Map<String, Object> queryParams, Map<String, Object> jsonBody) throws InterruptedException, ExecutionException, TimeoutException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("doPutRequest endpointUri={}, queryParams={}, jsonBody=...", (Object)endpointUri, queryParams);
        return KeycloakApi.callApi(userSession, endpointUri, queryParams, "PUT", Entity.json(jsonBody));
    }

    static String doDeleteRequest(UserSession userSession, String endpointUri, Map<String, Object> queryParams) throws InterruptedException, ExecutionException, TimeoutException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("doDeleteRequest endpointUri={}, queryParams={}", (Object)endpointUri, queryParams);
        return KeycloakApi.callApi(userSession, endpointUri, queryParams, "DELETE", null);
    }

    static String doPostRequest(UserSession userSession, String endpointUri, Map<String, Object> queryParams, Map<String, Object> jsonBody) throws InterruptedException, ExecutionException, TimeoutException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("doPutRequest endpointUri={}, queryParams={}, jsonBody=...", (Object)endpointUri, queryParams);
        return KeycloakApi.callApi(userSession, endpointUri, queryParams, "POST", Entity.json(jsonBody));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String callApi(UserSession userSession, String endpointUri, Map<String, Object> queryParams, String method, Entity<?> body) throws InterruptedException, ExecutionException, TimeoutException, KeycloakException, RestWebServiceClientInitException {
        LOGGER.info("callApi endpointUri={}, queryParams={}, method={}", (Object)endpointUri, queryParams, (Object)method);
        Object object = KEYCLOAK_CALLS_LOCK;
        synchronized (object) {
            try (Client client = null;){
                client = RestWebServiceClientFactory.newClient(false);
                client.register(JacksonJsonProvider.class);
                UriBuilder uriBuilder = UriBuilder.fromUri((String)endpointUri);
                if (queryParams != null) {
                    for (String queryParamName : queryParams.keySet()) {
                        Object queryParamValue = queryParams.get(queryParamName);
                        uriBuilder.queryParam(queryParamName, new Object[]{queryParamValue});
                    }
                }
                WebTarget target = client.target(uriBuilder);
                Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
                invocationBuilder.accept(new String[]{"application/json"});
                invocationBuilder.header("Authorization", (Object)("Bearer " + userSession.getSensitiveCustomData().get("oidc.accessToken")));
                Future response = invocationBuilder.build(method, body).submit(Response.class);
                Response r = (Response)response.get(60L, TimeUnit.SECONDS);
                if (Response.Status.Family.SUCCESSFUL == r.getStatusInfo().getFamily()) {
                    String responseAsString = (String)r.readEntity(String.class);
                    LOGGER.info("callApi response status: {}", (Object)r.getStatus());
                    LOGGER.debug("callApi response body:{}", (Object)responseAsString);
                    String string = responseAsString;
                    return string;
                }
                LOGGER.warn("Error Status={} Response: {}", (Object)r.getStatus(), r.readEntity(String.class));
                if (Response.Status.FORBIDDEN.getStatusCode() == r.getStatus()) {
                    throw new KeycloakException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_FORBIDDEN, "CORE_ERROR_IDENTITY_PROVIDER_API_FORBIDDEN", MapUtil.mapOf("url", endpointUri));
                }
                throw new KeycloakException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_API_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_API_ERROR");
            }
        }
    }
}

