/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.internationalization;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.InternationalizationService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.internationalization.InternationalizationException;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.util.MapUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="i18n")
@Tag(name="Internationalization API", description="These are the internationalization endpoints.")
public class InternationalizationEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(InternationalizationEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<InternationalizationService> internationalizationServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public InternationalizationEndpoint(BundleContext bundleContext) {
        LOGGER.info("InternationalizationEndpoint");
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.internationalizationServiceTracker = new BpcServicesTracker<InternationalizationService>(this.bundleContext, InternationalizationService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private String getDefaultLanguage() {
        try {
            return this.internationalizationServiceTracker.getService().getFallbackLanguage();
        }
        catch (Exception e) {
            return "en";
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/languages")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the languages used by the translations.", description="Get the languages used by the translations.")
    @ReturnDescription(value="The languages as JSON. Example response when `only_keys=false` and `currentLanguage=de`\n\n[source,json]\n----\n[\n     {\n         \"nativeName\": \"Deutsch\",\n         \"name\": \"Deutsch\",\n         \"id\": \"de\"\n     },\n     {\n         \"nativeName\": \"English\",\n         \"name\": \"Englisch\",\n         \"id\": \"en\"\n     },\n     {\n         \"nativeName\": \"fran\u00e7ais\",\n         \"name\": \"Franz\u00f6sisch\",\n         \"id\": \"fr\"\n     }\n]\n----\n\nExample response when only_keys=true\n\n[source,json]\n----\n[\n     \"de\", \"en\", \"fr\"\n]\n----\n")
    public Response getUsedLanguages(@Parameter(description="true to get only the keys, false to get a more detailed list") @QueryParam(value="only_keys") @DefaultValue(value="false") boolean onlyKeys, @Parameter(description="the current language used to determine the language names") @QueryParam(value="currentLanguage") @DefaultValue(value="en") String currentLanguage) {
        LOGGER.info("getUsedLanguages");
        try {
            if (onlyKeys) {
                return Response.ok(this.internationalizationServiceTracker.getService().getKeysOfUsedLanguages(), (String)"application/json").build();
            }
            return Response.ok(this.internationalizationServiceTracker.getService().getUsedLanguages(currentLanguage), (String)"application/json").build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/languages/all")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get all supported languages.", description="Get all supported languages.")
    @ReturnDescription(value="The languages as JSON. Example response when `only_keys=false` and `currentLanguage=de`\n\n[source,json]\n----\n[\n     {\n         \"nativeName\": \"Deutsch\",\n         \"name\": \"Deutsch\",\n         \"id\": \"de\"\n     },\n     {\n         \"nativeName\": \"English\",\n         \"name\": \"Englisch\",\n         \"id\": \"en\"\n     },\n     ...\n]\n----\n\nExample response when only_keys=true\n\n[source,json]\n----\n[\n     \"de\", \"en\", ...\n]\n----\n")
    public Response getAllLanguages(@Parameter(description="true to get only the keys, false to get a more detailed list") @QueryParam(value="only_keys") @DefaultValue(value="false") boolean onlyKeys, @Parameter(description="the current language used to determine the language names") @QueryParam(value="currentLanguage") @DefaultValue(value="en") String currentLanguage) {
        LOGGER.info("getAllLanguages onlyKeys={}", (Object)onlyKeys);
        try {
            if (onlyKeys) {
                return Response.ok(this.internationalizationServiceTracker.getService().getKeysOfAllLanguages(), (String)"application/json").build();
            }
            return Response.ok(this.internationalizationServiceTracker.getService().getAllLanguages(currentLanguage), (String)"application/json").build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/translations")
    @BpcRoleOrRightRequired(role="TRANSLATIONS_ADMIN", right="TRANSLATIONS_RELOAD", message="You are not allowed to force a translations reload.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Forces a re-load of the translations.", description="Forces a re-load of the translations.")
    public Response forceTranslationsReload() {
        LOGGER.info("forceTranslationsReload");
        try {
            this.internationalizationServiceTracker.getService().forceTranslationsReload();
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/translations/{lang}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Language not found")})
    @OperationDescription(summary="Get all translations for a specific language.", description="Get all translations for a specific language. This is a collection of the translations found in all\nmodules/bundles and the ones from our custom translations setting `Core_CustomTranslations`. In case\na module/bundle does not provide translations in the requested language the translations for the\ndefault language set by the setting 'Core_TranslationsFallbackLanguage' gets used.\n")
    @ReturnDescription(value="JSON object with the translations. The keys are sorted in ascending order.")
    public Response getTranslations(@Parameter(description="the language to get the translations for. Like 'de', 'en', 'fr' etc.") @PathParam(value="lang") String lang, @Parameter(description="`true` to ignore the translation from the custom translations setting, `false` to include them.") @QueryParam(value="ict") @DefaultValue(value="false") boolean ignoreCustomTranslations, @Parameter(description="`true` to return entries in the default language as fallback when a translation key is missing in the requested language, `false` to return only the entries that exist in the requested language.") @QueryParam(value="fallback") @DefaultValue(value="true") boolean fallbackToDefaultLanguageWhenMissing) {
        LOGGER.info("getTranslations lang={}, ignoreCustomTranslations={}, fallbackToDefaultLanguageWhenMissing={}", (Object)lang, (Object)ignoreCustomTranslations, (Object)fallbackToDefaultLanguageWhenMissing);
        try {
            InternationalizationService internationalizationService = this.internationalizationServiceTracker.getService();
            if (!fallbackToDefaultLanguageWhenMissing && !internationalizationService.getKeysOfUsedLanguages().contains(lang.toLowerCase())) {
                throw new InternationalizationException((ErrorCode)CoreErrorCode.INTERNATIONALIZATION_LANGUAGE_NOT_FOUND, "Failed to get translations. The language '${lang}' does not exist.", MapUtil.mapOf("lang", lang));
            }
            Map<String, Object> translationsForLanguage = internationalizationService.getTranslationsForLanguage(lang.toLowerCase(), ignoreCustomTranslations, fallbackToDefaultLanguageWhenMissing);
            TreeMap<String, Object> sortedTranslationsForLanguage = new TreeMap<String, Object>(translationsForLanguage);
            return Response.ok(sortedTranslationsForLanguage, (String)"application/json").build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to collect the translations", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/language/{lang}/valid")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Checks if the provided language is known to the backend.", description="Checks if the provided language is known to the backend. Returns the default/fallback language if not.")
    @ReturnDescription(value="The given language when valid, otherwise the default language.\n\nExample response\n\n[source,json]\n----\n{\n   \"language\": \"en\"\n}\n----\n")
    public Response getValidLanguage(@Parameter(description="the language to do the check for") @PathParam(value="lang") String lang) {
        LOGGER.info("getValidLanguage lang={}", (Object)lang);
        try {
            InternationalizationService internationalizationService = this.internationalizationServiceTracker.getService();
            if (!internationalizationService.getKeysOfUsedLanguages().contains(lang.toLowerCase())) {
                lang = this.getDefaultLanguage();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to validate the language=" + lang, (Throwable)ex);
            lang = this.getDefaultLanguage();
        }
        return Response.ok(MapUtil.mapOf("language", lang.toLowerCase()), (String)"application/json").build();
    }
}

