/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.lookupjoins;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchType;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class LookupJoin {
    private static final Logger LOGGER = LogManager.getLogger(LookupJoin.class);
    private static final Map<String, Object> NotFound = new HashMap<String, Object>();
    private final String keyField;
    private final String keyFieldValuesSeparator;
    private final String lookupIndex;
    private final String lookupKeyField;
    private final String resultFieldsPrefix;
    private final String[] resultFieldsIncluded;
    private final String[] resultFieldsExcluded;
    private final boolean cachingEnabled;
    private final Map<Object, Map<String, Object>> cache;

    public LookupJoin(Map<String, Object> lookupJoinConfig) {
        this.keyField = MapUtil.getValueAsString(lookupJoinConfig, "keyField", null);
        this.keyFieldValuesSeparator = MapUtil.getValueAsString(lookupJoinConfig, "keyFieldValuesSeparator", null);
        this.lookupIndex = MapUtil.getValueAsString(lookupJoinConfig, "lookupIndex", null);
        this.lookupKeyField = MapUtil.getValueAsString(lookupJoinConfig, "lookupKeyField", null);
        this.resultFieldsPrefix = MapUtil.getValueAsString(lookupJoinConfig, "resultFieldsPrefix", null);
        this.resultFieldsIncluded = MapUtil.getValueAsStringArray(lookupJoinConfig, "resultFieldsIncluded", null);
        this.resultFieldsExcluded = MapUtil.getValueAsStringArray(lookupJoinConfig, "resultFieldsExcluded", null);
        this.cachingEnabled = MapUtil.getValueAsBoolean(lookupJoinConfig, "caching", true);
        this.cache = new HashMap<Object, Map<String, Object>>();
    }

    public void clearCache() {
        LOGGER.debug("clearCache");
        this.cache.clear();
    }

    public String getKeyField() {
        return this.keyField;
    }

    public boolean isMultiValueKeyField() {
        return !StringUtil.isNullOrEmpty(this.keyFieldValuesSeparator);
    }

    public String getKeyFieldValuesSeparator() {
        return this.keyFieldValuesSeparator;
    }

    public String getLookupIndex() {
        return this.lookupIndex;
    }

    public String getLookupKeyField() {
        return this.lookupKeyField;
    }

    public String getResultFieldsPrefix() {
        return this.resultFieldsPrefix;
    }

    public String[] getResultFieldsIncluded() {
        return this.resultFieldsIncluded;
    }

    public String[] getResultFieldsExcluded() {
        return this.resultFieldsExcluded;
    }

    public String getResultFieldName(String fieldName) {
        return this.resultFieldsPrefix + fieldName;
    }

    public Map<String, Object> getAlreadyPrefixedLookupData(OpenSearchService oss, Object keyValue) throws OpenSearchRelatedException {
        LOGGER.debug("getAlreadyPrefixedLookupData oss=..., keyValue={}", keyValue);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isMultiValueKeyField()) {
            List<String> values = StringUtil.explode((String)keyValue, this.keyFieldValuesSeparator);
            if (values != null) {
                boolean previousLookupDataNotFound = false;
                for (String value : values) {
                    Map<String, Object> lookupData = this.getLookupData(oss, value);
                    if (!lookupData.isEmpty()) {
                        if (previousLookupDataNotFound) {
                            lookupData.forEach((lookupDataKey, lookupDataValue) -> {
                                String resultFieldName = this.getResultFieldName((String)lookupDataKey);
                                Object existingResultFieldValueObject = result.get(resultFieldName);
                                if (existingResultFieldValueObject == null) {
                                    result.put(resultFieldName, this.keyFieldValuesSeparator);
                                } else {
                                    result.put(resultFieldName, existingResultFieldValueObject + this.keyFieldValuesSeparator);
                                }
                            });
                        }
                        previousLookupDataNotFound = false;
                        lookupData.forEach((lookupDataKey, lookupDataValue) -> {
                            String resultFieldName = this.getResultFieldName((String)lookupDataKey);
                            String resultFieldValueAsString = lookupDataValue == null ? null : lookupDataValue.toString();
                            Object existingResultFieldValueObject = result.get(resultFieldName);
                            if (existingResultFieldValueObject == null) {
                                result.put(resultFieldName, resultFieldValueAsString);
                            } else {
                                result.put(resultFieldName, existingResultFieldValueObject + this.keyFieldValuesSeparator + resultFieldValueAsString);
                            }
                        });
                        continue;
                    }
                    previousLookupDataNotFound = true;
                }
            }
        } else {
            Map<String, Object> lookupData = this.getLookupData(oss, keyValue);
            if (!lookupData.isEmpty()) {
                lookupData.forEach((lookupDataKey, lookupDataValue) -> {
                    String resultFieldName = this.getResultFieldName((String)lookupDataKey);
                    result.put(resultFieldName, lookupDataValue);
                });
            }
        }
        return result;
    }

    private Map<String, Object> getLookupData(OpenSearchService oss, Object keyValue) throws OpenSearchRelatedException {
        Map<String, Object> cachedResult;
        LOGGER.debug("getLookupData keyValue={}", keyValue);
        if (keyValue == null) {
            return NotFound;
        }
        if (this.cachingEnabled && (cachedResult = this.cache.get(keyValue)) != null) {
            if (cachedResult.size() == 0) {
                LOGGER.debug("{}: No cached result found", keyValue);
                return NotFound;
            }
            LOGGER.debug("{}: Returning cached result: {}", keyValue, cachedResult);
            return cachedResult;
        }
        try {
            RestHighLevelClient osClient = oss.getClient();
            SearchRequest searchReq = new SearchRequest().indices(this.lookupIndex).source(new SearchSourceBuilder().from(0).size(2).query(QueryBuilders.constantScoreQuery(QueryBuilders.termQuery(this.lookupKeyField, keyValue))).fetchSource(this.resultFieldsIncluded, this.resultFieldsExcluded)).searchType(SearchType.DEFAULT);
            SearchResponse response = osClient.search(searchReq, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            Map<String, Object> result = null;
            if (hits == null || hits.length == 0) {
                LOGGER.debug("{}: No lookup document found. {}", keyValue, (Object)this);
            } else if (hits.length > 1) {
                LOGGER.error("{}: No unique lookup document found. They must be unique. {}", keyValue, (Object)this);
            } else {
                result = hits[0].getSourceAsMap();
                LOGGER.debug("{}: Found the lookup document: {}", keyValue, result);
            }
            if (this.cachingEnabled) {
                if (result == null) {
                    LOGGER.debug("{}: Caching the 'Not found' result", keyValue);
                    this.cache.put(keyValue, NotFound);
                } else {
                    LOGGER.debug("{}: Caching the found result: {}", keyValue, result);
                    this.cache.put(keyValue, result);
                }
            }
            return result == null ? NotFound : result;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public String toString() {
        return "LookupJoin{keyField='" + this.keyField + "', keyFieldValuesSeparator='" + this.keyFieldValuesSeparator + "', lookupIndex='" + this.lookupIndex + "', lookupKeyField='" + this.lookupKeyField + "', resultFieldsPrefix='" + this.resultFieldsPrefix + "', resultFieldsIncluded=" + Arrays.toString(this.resultFieldsIncluded) + ", resultFieldsExcluded=" + Arrays.toString(this.resultFieldsExcluded) + ", cachingEnabled=" + this.cachingEnabled + "}";
    }
}

