/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.Broadcast;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BroadcastCollector {
    private static final Logger LOGGER = LogManager.getLogger(BroadcastCollector.class);
    private final Broadcast broadcast;
    private final List<Runnable> entries;

    public BroadcastCollector(EventManager eventManager) throws ServiceNotFoundException {
        this.broadcast = eventManager.broadcast();
        this.entries = new ArrayList<Runnable>();
    }

    public List<Runnable> getEntries() {
        return this.entries;
    }

    public void moduleInstanceCreated(final String moduleId, final String instanceId, final String instanceType) {
        LOGGER.info("moduleInstanceCreated moduleId={}, instanceId={}, instanceType={}", (Object)moduleId, (Object)instanceId, (Object)instanceType);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceCreated(moduleId, instanceId, instanceType);
            }
        });
    }

    public void moduleUpdated(final String moduleId) {
        LOGGER.info("moduleUpdated moduleId={}", (Object)moduleId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleUpdated(moduleId);
            }
        });
    }

    public void moduleInstanceUpdated(final String moduleId, final String instanceId, final String instanceType) {
        LOGGER.info("moduleInstanceUpdated moduleId={}, instanceId={}, instanceType={}", (Object)moduleId, (Object)instanceId, (Object)instanceType);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceUpdated(moduleId, instanceId, instanceType);
            }
        });
    }

    public void moduleInstanceDeleted(final String moduleId, final String instanceId) {
        LOGGER.info("moduleInstanceDeleted moduleId={}, instanceId={}", (Object)moduleId, (Object)instanceId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceDeleted(moduleId, instanceId);
            }
        });
    }

    public void moduleSettingDeleted(final String moduleId, final String settingName) {
        LOGGER.info("moduleSettingDeleted moduleId={}, settingName={}", (Object)moduleId, (Object)settingName);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleSettingDeleted(moduleId, settingName);
            }
        });
    }

    public void moduleInstanceSettingDeleted(final String moduleId, final String instanceId, final String instanceType, final String settingName) {
        LOGGER.info("moduleInstanceSettingDeleted moduleId={}, instanceId={}, instanceType={}, settingName={}", (Object)moduleId, (Object)instanceId, (Object)instanceType, (Object)settingName);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceSettingDeleted(moduleId, instanceId, instanceType, settingName);
            }
        });
    }

    public void moduleRelatedStoreItemDeleted(final String moduleId, final String storeId, final String storeItemId) {
        LOGGER.info("moduleRelatedStoreItemDeleted moduleId={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)storeId, (Object)storeItemId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleRelatedStoreItemDeleted(moduleId, storeId, storeItemId);
            }
        });
    }

    public void moduleRelatedStoreItemCreated(final String moduleId, final String storeId, final String storeItemId) {
        LOGGER.info("moduleRelatedStoreItemCreated moduleId={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)storeId, (Object)storeItemId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleRelatedStoreItemCreated(moduleId, storeId, storeItemId);
            }
        });
    }

    public void moduleRelatedStoreItemUpdated(final String moduleId, final String storeId, final String storeItemId) {
        LOGGER.info("moduleRelatedStoreItemUpdated moduleId={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)storeId, (Object)storeItemId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleRelatedStoreItemUpdated(moduleId, storeId, storeItemId);
            }
        });
    }

    public void moduleInstanceRelatedStoreItemDeleted(final String moduleId, final String instanceId, final String instanceType, final String storeId, final String storeItemId) {
        LOGGER.info("moduleInstanceRelatedStoreItemDeleted moduleId={}, instanceId={}, instanceType={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)instanceId, (Object)instanceType, (Object)storeId, (Object)storeItemId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceRelatedStoreItemDeleted(moduleId, instanceId, instanceType, storeId, storeItemId);
            }
        });
    }

    public void moduleInstanceRelatedStoreItemCreated(final String moduleId, final String instanceId, final String instanceType, final String storeId, final String storeItemId) {
        LOGGER.info("moduleInstanceRelatedStoreItemCreated moduleId={}, instanceId={}, instanceType={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)instanceId, (Object)instanceType, (Object)storeId, (Object)storeItemId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceRelatedStoreItemCreated(moduleId, instanceId, instanceType, storeId, storeItemId);
            }
        });
    }

    public void moduleInstanceRelatedStoreItemUpdated(final String moduleId, final String instanceId, final String instanceType, final String storeId, final String storeItemId) {
        LOGGER.info("moduleInstanceRelatedStoreItemUpdated moduleId={}, instanceId={}, instanceType={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)instanceId, (Object)instanceType, (Object)storeId, (Object)storeItemId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceRelatedStoreItemUpdated(moduleId, instanceId, instanceType, storeId, storeItemId);
            }
        });
    }
}

