/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.MapUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion11To12
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion11To12.class);
    private static final boolean testRun = false;
    private final DateTimeFormatter expiresOnFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneOffset.UTC);

    public BpcConfigurationIndexMigrationFromModelVersion11To12(OpenSearchService oss) {
        super(oss, 12);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Object apiKeysObject;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if ("_core".equals(sourceValues.get("moduleId")) && "apiKeys".equals(sourceValues.get("name")) && (apiKeysObject = sourceValues.get("value")) instanceof Map) {
            try {
                Map originalApiKeys = (Map)apiKeysObject;
                Map updatedApiKeys = MapUtil.deepCopy(originalApiKeys);
                for (String apiKey : updatedApiKeys.keySet()) {
                    Map apiKeyDetails = (Map)updatedApiKeys.get(apiKey);
                    if (!apiKeyDetails.containsKey("issuedOn") || !apiKeyDetails.containsKey("expiresIn")) continue;
                    String issuedOn = (String)apiKeyDetails.get("issuedOn");
                    String expiresIn = (String)apiKeyDetails.get("expiresIn");
                    LocalDateTime issuedOnAsDate = ZonedDateTime.parse(issuedOn).toLocalDateTime();
                    LocalDateTime expiresOnAsDate = DateUtil.addRelativeValue(expiresIn, issuedOnAsDate);
                    String expiresOnFormatted = this.expiresOnFormatter.format(expiresOnAsDate);
                    apiKeyDetails.put("expiresOn", expiresOnFormatted);
                    apiKeyDetails.remove("expiresIn");
                }
                HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                updatedSourceValues.put("value", updatedApiKeys);
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, (MediaType)XContentType.JSON));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to convert the API keys.", (Throwable)ex);
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }
}

