/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.plugin;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.BroadcastImpl;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfosDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupSnapshotInfoDTO;
import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModuleDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageFactory;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobDeleteWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobInfosRequestWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobInfosResponseWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobScheduleWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobStartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupSnapshotCreatedInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllExceptSenderWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ClearLookupJoinCachesOfReplicationJobsWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexCreatedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexDeletedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexOperationWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.RefreshLookupJoinsOfReplicationJobWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobForcedStartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobForcedStartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobRestartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobRestartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStartActionWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStatsRequestWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStatsResponseWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStopAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStopActionWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerLoadedModulesWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerStateInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.SetAsMasterServerWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.WebsocketMessageForFrontendSession;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class OpenSearchBpcPluginListener
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchBpcPluginListener.class);
    public static final String RETRY_INTERVAL_IN_SECONDS_PROPERTY_NAME = "de.virtimo.bpc.core.os-bpc-plugin.retryInterval";
    public static final int RETRY_INTERVAL_IN_SECONDS_DEFAULT_VALUE = 5;
    private final BundleContext bundleContext;
    private BpcServicesTracker<EventManager> eventManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private final OpenSearchBpcPluginManager openSearchBpcPluginManager;
    private WebSocketClient websocketClient = null;

    public OpenSearchBpcPluginListener(BundleContext bundleContext, OpenSearchBpcPluginManager openSearchBpcPluginManager) {
        this.bundleContext = bundleContext;
        this.openSearchBpcPluginManager = openSearchBpcPluginManager;
    }

    public void destroy() {
        LOGGER.info("destroy");
        if (this.websocketClient != null) {
            try {
                this.websocketClient.stop();
                this.websocketClient = null;
            }
            catch (Exception e) {
                LOGGER.warn("Could not stop the websocket connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOGGER.info("run");
        if (this.websocketClient != null) {
            if (this.websocketClient.isRunning()) {
                LOGGER.info("Nothing to do ... there is already a running websocket connection.");
                return;
            }
            LOGGER.warn("Should not happen ... previously used websocket client is in state: {}", (Object)this.websocketClient.getState());
            try {
                this.websocketClient.stop();
                this.websocketClient = null;
            }
            catch (Exception ex) {
                LOGGER.error("Failed to stop an old/previously used websocket client.", (Throwable)ex);
            }
        }
        OpenSearchBpcPluginSocket socket = new OpenSearchBpcPluginSocket();
        EventRegistration eventRegistration = new EventRegistration(this.bundleContext);
        eventRegistration.forEventTopic("de/virtimo/os-bpc-plugin-send-broadcast-message-to-all", new SendBroadcastMessageToAllEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/os-bpc-plugin-send-broadcast-message", new SendBroadcastMessageEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/os-bpc-plugin-send-state-info-message", new SendStateInfoMessageEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/os-bpc-plugin-send-percolator-hit-message", new SendPercolatorHitMessageEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/os-bpc-plugin-send-replicationjob-stats-message", new SendReplicationJobStatsMessageEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/os-bpc-plugin-send-backupjob-infos-message", new SendBackupJobInfosMessageEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/os-bpc-plugin-send-backup-created-info-message", new SendBackupCreatedInfoMessageEventHandler(socket));
        eventRegistration.forAnyBackendModuleLoadedEvents(new LoadedModulesChangedEventHandler(socket));
        eventRegistration.forAnyBackendModuleUnloadedEvents(new LoadedModulesChangedEventHandler(socket));
        eventRegistration.forOpenSearchPluginWebsocketConnectedEvents(new LoadedModulesChangedEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/bpc/core/replication/job/state/stopped", new ReplicationJobStoppedEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/bpc/core/replication/job/state/started", new ReplicationJobStartedEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/bpc/core/replication/job/state/forcedStarted", new ReplicationJobForcedStartedEventHandler(socket));
        eventRegistration.forEventTopic("de/virtimo/bpc/core/replication/job/state/restarted", new ReplicationJobRestartedEventHandler(socket));
        LOGGER.info("Establishing Websocket connection");
        try {
            this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
            this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
            this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
            this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
            this.websocketClient = new WebSocketClient();
            this.websocketClient.start();
            this.websocketClient.setConnectTimeout(10000L);
            this.websocketClient.setMaxIdleTimeout(0L);
            URI openSearchBpcPluginWebsocketURI = new URI(this.openSearchBpcPluginManager.getOpenSearchBpcPluginWebsocketUrl());
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            this.websocketClient.connect((Object)socket, openSearchBpcPluginWebsocketURI, request);
            LOGGER.info("Connecting to : {}", (Object)openSearchBpcPluginWebsocketURI);
            socket.await();
            LOGGER.info("Websocket client stopped");
            return;
        }
        catch (InterruptedException ex) {
            LOGGER.info("The websocket connection has been interrupted. Maybe just the core bundle stopped.");
            this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED);
            return;
        }
        catch (Throwable t) {
            LOGGER.error("Could not establish the websocket connection", t);
            this.openSearchBpcPluginManager.addError("Could not establish the websocket connection.", t);
            this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED_DUE_TO_ERROR);
            return;
        }
        finally {
            eventRegistration.unregisterAllEventHandler();
            if (this.websocketClient != null) {
                try {
                    this.websocketClient.stop();
                }
                catch (Exception e) {
                    LOGGER.warn("Could not stop the websocket connection", (Throwable)e);
                }
                finally {
                    this.websocketClient = null;
                }
            }
            BpcServicesTracker.stopAll(this);
        }
    }

    @WebSocket(maxTextMessageSize=262144)
    public class OpenSearchBpcPluginSocket {
        private final CountDownLatch closeLatch = new CountDownLatch(1);
        private final Map<Class<? extends WebsocketMessage>, WebsocketMessageProcessor<? extends WebsocketMessage>> websocketMessageProcessors = new HashMap<Class<? extends WebsocketMessage>, WebsocketMessageProcessor<? extends WebsocketMessage>>();
        private Session session;
        private RemoteEndpoint remote;

        public OpenSearchBpcPluginSocket() {
            this.initializeWebsocketMessageProcessors();
        }

        public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
            return this.closeLatch.await(duration, unit);
        }

        public void await() throws InterruptedException {
            this.closeLatch.await();
        }

        @OnWebSocketConnect
        public void onConnect(Session session) {
            LOGGER.info("{}.onConnect: {}", (Object)this.getClass().getSimpleName(), (Object)session);
            this.session = session;
            this.remote = this.session.getRemote();
            OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.CONNECTED);
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            LOGGER.info("{}.onClose: {} - {}", (Object)this.getClass().getSimpleName(), (Object)statusCode, (Object)reason);
            this.session = null;
            this.remote = null;
            this.closeLatch.countDown();
            OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED);
        }

        @OnWebSocketError
        public void onError(Throwable cause) {
            LOGGER.error("{}.onError", (Object)this.getClass().getSimpleName(), (Object)cause);
            this.session = null;
            this.remote = null;
            this.closeLatch.countDown();
            OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Closing websocket session due to received transport error.", cause);
            OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED_DUE_TO_ERROR);
        }

        private void initializeWebsocketMessageProcessors() {
            LOGGER.info("{}.initializeWebsocketMessageProcessors", (Object)this.getClass().getSimpleName());
            this.websocketMessageProcessors.put(WebsocketMessageForFrontendSession.class, new WebsocketMessageForFrontendSessionProcessor());
            this.websocketMessageProcessors.put(BroadcastWebsocketMessage.class, new BroadcastWebsocketMessageProcessor());
            this.websocketMessageProcessors.put(IndexOperationWebsocketMessage.class, new IndexOperationWebsocketMessageProcessor());
            this.websocketMessageProcessors.put(IndexDeletedWebsocketMessage.class, new IndexDeletedWebsocketMessageProcessor());
            this.websocketMessageProcessors.put(IndexCreatedWebsocketMessage.class, new IndexCreatedWebsocketMessageProcessor());
            this.websocketMessageProcessors.put(SetAsMasterServerWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("SetAsMasterServer"));
            this.websocketMessageProcessors.put(ReplicationJobStopActionWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("StopReplicationJobAction"));
            this.websocketMessageProcessors.put(ReplicationJobStartActionWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("StartReplicationJobAction"));
            this.websocketMessageProcessors.put(ReplicationJobForcedStartWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("ForcedStartOfReplicationJobAction"));
            this.websocketMessageProcessors.put(ReplicationJobRestartWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("RestartOfReplicationJobAction"));
            this.websocketMessageProcessors.put(RefreshLookupJoinsOfReplicationJobWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("RefreshLookupJoinsOfReplicationJobAction"));
            this.websocketMessageProcessors.put(RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("RefreshLookupJoinsOfAllReplicationJobsAction"));
            this.websocketMessageProcessors.put(ClearLookupJoinCachesOfReplicationJobsWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("ClearLookupJoinCachesOfReplicationJobsAction"));
            this.websocketMessageProcessors.put(ReplicationJobStatsRequestWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("GetReplicationJobStatsAction"));
            this.websocketMessageProcessors.put(BackupJobInfosRequestWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("GetBackupJobInfosAction"));
            this.websocketMessageProcessors.put(BackupJobDeleteWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("DeleteBackupJobAction"));
            this.websocketMessageProcessors.put(BackupJobStartWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("StartBackupJobAction"));
            this.websocketMessageProcessors.put(BackupJobScheduleWebsocketMessage.class, new SimpleEventFiringWebsocketMessageProcessor("ScheduleBackupJobAction"));
        }

        @OnWebSocketMessage
        public void onMessage(String msg) {
            LOGGER.info("{}.onMessage: {}", (Object)this.getClass().getSimpleName(), (Object)msg);
            try {
                WebsocketMessage websocketMessage = WebsocketMessageFactory.create((String)msg);
                if (websocketMessage == null) {
                    return;
                }
                LOGGER.debug("{}: os-bpc-plugin onMessage: {}", (Object)this.getClass().getSimpleName(), (Object)websocketMessage);
                WebsocketMessageProcessor<? extends WebsocketMessage> websocketMessageProcessor = this.websocketMessageProcessors.get(websocketMessage.getClass());
                if (websocketMessageProcessor != null) {
                    websocketMessageProcessor.process((WebsocketMessage)websocketMessage);
                } else {
                    LOGGER.error("{}: Could not find a WebsocketMessageProcessor for class {}", (Object)this.getClass().getSimpleName(), websocketMessage.getClass());
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to process the received websocket message from the os-bpc-plugin.", t);
            }
        }

        private void sendWebsocketMessageSync(WebsocketMessage websocketMessage) {
            block5: {
                String msg;
                LOGGER.info("{}.sendWebsocketMessageSync websocketMessage=...", (Object)this.getClass().getSimpleName());
                try {
                    msg = websocketMessage.getMessageToSend();
                }
                catch (WebsocketMessageException ex) {
                    LOGGER.error(this.getClass().getSimpleName() + ".sendWebsocketMessageSync : Failed to get the message to send.", (Throwable)ex);
                    return;
                }
                Future fut = null;
                try {
                    fut = this.remote.sendStringByFuture(msg);
                    fut.get(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error(this.getClass().getSimpleName() + ".sendWebsocketMessageSync : Could not send the websocket message: " + msg, (Throwable)e);
                }
                catch (TimeoutException e) {
                    LOGGER.error(this.getClass().getSimpleName() + ".sendWebsocketMessageSync : Timeout (15 seconds) while sending the websocket message: " + msg, (Throwable)e);
                    if (fut == null) break block5;
                    fut.cancel(true);
                }
            }
        }

        private void sendWebsocketMessageAsync(WebsocketMessage websocketMessage) {
            String msg;
            LOGGER.info("{}.sendWebsocketMessageAsync websocketMessage=...", (Object)this.getClass().getSimpleName());
            try {
                msg = websocketMessage.getMessageToSend();
            }
            catch (WebsocketMessageException ex) {
                LOGGER.error(this.getClass().getSimpleName() + ".sendWebsocketMessageAsync : Failed to get the message to send.", (Throwable)ex);
                return;
            }
            this.remote.sendStringByFuture(msg);
        }
    }

    private class SendBroadcastMessageToAllEventHandler
    extends AbstractPluginRelatedEventHandler {
        public SendBroadcastMessageToAllEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            Object msgObject = event.getProperty("msg");
            if (msgObject instanceof BroadcastWebsocketMessage) {
                BroadcastWebsocketMessage broadcastWebsocketMessage = (BroadcastWebsocketMessage)msgObject;
                try {
                    BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage = new BroadcastToAllWebsocketMessage((WebsocketMessage)broadcastWebsocketMessage);
                    this.sendWebsocketMessageSync((WebsocketMessage)broadcastToAllWebsocketMessage);
                }
                catch (WebsocketMessageException ex) {
                    LOGGER.error(this.getClass().getSimpleName() + ".processEvent : Failed to send a broadcast to all websocket message.", (Throwable)ex);
                }
            }
        }
    }

    private class SendBroadcastMessageEventHandler
    extends AbstractPluginRelatedEventHandler {
        public SendBroadcastMessageEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            Object msgObject = event.getProperty("msg");
            if (msgObject instanceof BroadcastWebsocketMessage) {
                BroadcastWebsocketMessage broadcastWebsocketMessage = (BroadcastWebsocketMessage)msgObject;
                try {
                    BroadcastToAllExceptSenderWebsocketMessage broadcastToAllExceptSenderWebsocketMessage = new BroadcastToAllExceptSenderWebsocketMessage((WebsocketMessage)broadcastWebsocketMessage);
                    this.sendWebsocketMessageSync((WebsocketMessage)broadcastToAllExceptSenderWebsocketMessage);
                }
                catch (WebsocketMessageException ex) {
                    LOGGER.error(this.getClass().getSimpleName() + ".processEvent : Failed to send a broadcast websocket message.", (Throwable)ex);
                }
            }
        }
    }

    private class SendStateInfoMessageEventHandler
    extends AbstractPluginRelatedEventHandler {
        public SendStateInfoMessageEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            Object msgObject = event.getProperty("msg");
            if (msgObject instanceof ServerStateInfoDTO) {
                ServerStateInfoDTO serverStateInfoDTO = (ServerStateInfoDTO)msgObject;
                ServerStateInfoWebsocketMessage serverStateInfoWebsocketMessage = new ServerStateInfoWebsocketMessage(serverStateInfoDTO);
                this.sendWebsocketMessageSync((WebsocketMessage)serverStateInfoWebsocketMessage);
            }
        }
    }

    private class SendPercolatorHitMessageEventHandler
    extends AbstractPluginRelatedEventHandler {
        public SendPercolatorHitMessageEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                String serverUUID = (String)event.getProperty("serverUUID");
                String sessionId = (String)event.getProperty("sessionId");
                String jsonMsg = (String)event.getProperty("jsonMsg");
                Object websocketMessage = !StringUtil.isNullOrEmpty(serverUUID) ? new BroadcastToWebsocketMessage(List.of(serverUUID), (WebsocketMessage)new WebsocketMessageForFrontendSession(sessionId, jsonMsg)) : new BroadcastToAllWebsocketMessage((WebsocketMessage)new WebsocketMessageForFrontendSession(sessionId, jsonMsg));
                this.sendWebsocketMessageSync((WebsocketMessage)websocketMessage);
            }
            catch (WebsocketMessageException ex) {
                LOGGER.error(this.getClass().getSimpleName() + ".processEvent : Failed not create the websocket message instances for the percolators hit message.", (Throwable)ex);
            }
        }
    }

    private class SendReplicationJobStatsMessageEventHandler
    extends AbstractPluginRelatedEventHandler {
        public SendReplicationJobStatsMessageEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String communicationId = (String)event.getProperty("communicationId");
            Object msgObject = event.getProperty("replicationJobStats");
            if (msgObject instanceof ReplicationJobsWithRuntimeStatsFromServerDTO) {
                ReplicationJobsWithRuntimeStatsFromServerDTO replicationJobsWithRuntimeStatsFromServerDTO = (ReplicationJobsWithRuntimeStatsFromServerDTO)msgObject;
                ReplicationJobStatsResponseWebsocketMessage replicationJobResponseWebsocketMessage = new ReplicationJobStatsResponseWebsocketMessage(communicationId, replicationJobsWithRuntimeStatsFromServerDTO);
                this.sendWebsocketMessageAsync((WebsocketMessage)replicationJobResponseWebsocketMessage);
            }
        }
    }

    private class SendBackupJobInfosMessageEventHandler
    extends AbstractPluginRelatedEventHandler {
        public SendBackupJobInfosMessageEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String communicationId = (String)event.getProperty("communicationId");
            Object msgObject = event.getProperty("backupJobInfos");
            BackupJobInfosResponseWebsocketMessage backupJobInfosResponseWebsocketMessage = new BackupJobInfosResponseWebsocketMessage(communicationId, (BackupJobInfosDTO)msgObject);
            this.sendWebsocketMessageAsync((WebsocketMessage)backupJobInfosResponseWebsocketMessage);
        }
    }

    private class SendBackupCreatedInfoMessageEventHandler
    extends AbstractPluginRelatedEventHandler {
        public SendBackupCreatedInfoMessageEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String communicationId = (String)event.getProperty("communicationId");
            Object msgObject = event.getProperty("backupSnapshotInfo");
            Map<String, Object> exceptionAsResponseMap = this.exceptionAsResponseMap(event.getProperty("exception"));
            BackupSnapshotInfoDTO backupSnapshotInfoDTO = exceptionAsResponseMap != null ? BackupSnapshotInfoDTO.createForExceptionAsResponseMap(exceptionAsResponseMap) : (BackupSnapshotInfoDTO)msgObject;
            BackupSnapshotCreatedInfoWebsocketMessage backupSnapshotCreatedInfoWebsocketMessage = new BackupSnapshotCreatedInfoWebsocketMessage(communicationId, backupSnapshotInfoDTO);
            this.sendWebsocketMessageAsync((WebsocketMessage)backupSnapshotCreatedInfoWebsocketMessage);
        }

        private Map<String, Object> exceptionAsResponseMap(Object exceptionObject) {
            if (exceptionObject instanceof Exception) {
                Map<String, Object> map;
                block9: {
                    Exception exception = (Exception)exceptionObject;
                    ErrorResponseService errorResponseService = OpenSearchBpcPluginListener.this.errorResponseServiceTracker.getService();
                    Response responseForException = errorResponseService.responseForException(exception);
                    try {
                        map = errorResponseService.asMap(responseForException);
                        if (responseForException == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (responseForException != null) {
                                try {
                                    responseForException.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ServiceNotFoundException ex) {
                            LOGGER.error("Failed to get the ErrorResponseService to serialize an exception to be sent to the os-bpc-plugin.", (Throwable)ex);
                        }
                    }
                    responseForException.close();
                }
                return map;
            }
            return null;
        }
    }

    private class LoadedModulesChangedEventHandler
    extends AbstractPluginRelatedEventHandler {
        public LoadedModulesChangedEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                ModuleManager moduleManager = OpenSearchBpcPluginListener.this.moduleManagerTracker.getService();
                LoadedModulesDTO serverLoadedModules = new LoadedModulesDTO();
                for (Module module : moduleManager.getLoadedModules().values()) {
                    serverLoadedModules.addLoadedModule(new LoadedModuleDTO(module.getModuleId(), module.getModuleBundle().getVersion().toString()));
                }
                ServerLoadedModulesWebsocketMessage serverLoadedModulesWebsocketMessage = new ServerLoadedModulesWebsocketMessage(serverLoadedModules);
                this.sendWebsocketMessageSync((WebsocketMessage)serverLoadedModulesWebsocketMessage);
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.warn(this.getClass().getSimpleName() + ".processEvent : Failed to inform the os-bpc-plugin about my loaded modules.", (Throwable)ex);
            }
        }
    }

    private class ReplicationJobStoppedEventHandler
    extends AbstractPluginRelatedEventHandler {
        public ReplicationJobStoppedEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String replicationJobId = (String)event.getProperty("replicationJobId");
            String serverUUID = (String)event.getProperty("serverUUID");
            String transactionId = (String)event.getProperty("transactionId");
            ReplicationJobStopAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = new ReplicationJobStopAcknowledgementWebsocketMessage(replicationJobId, serverUUID, transactionId);
            this.sendWebsocketMessageAsync((WebsocketMessage)acknowledgementWebsocketMessage);
        }
    }

    private class ReplicationJobStartedEventHandler
    extends AbstractPluginRelatedEventHandler {
        public ReplicationJobStartedEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String replicationJobId = (String)event.getProperty("replicationJobId");
            String serverUUID = (String)event.getProperty("serverUUID");
            String transactionId = (String)event.getProperty("transactionId");
            ReplicationJobStartAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = new ReplicationJobStartAcknowledgementWebsocketMessage(replicationJobId, serverUUID, transactionId);
            this.sendWebsocketMessageAsync((WebsocketMessage)acknowledgementWebsocketMessage);
        }
    }

    private class ReplicationJobForcedStartedEventHandler
    extends AbstractPluginRelatedEventHandler {
        public ReplicationJobForcedStartedEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String replicationJobId = (String)event.getProperty("replicationJobId");
            String serverUUID = (String)event.getProperty("serverUUID");
            String transactionId = (String)event.getProperty("transactionId");
            ReplicationJobForcedStartAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = new ReplicationJobForcedStartAcknowledgementWebsocketMessage(replicationJobId, serverUUID, transactionId);
            this.sendWebsocketMessageAsync((WebsocketMessage)acknowledgementWebsocketMessage);
        }
    }

    private class ReplicationJobRestartedEventHandler
    extends AbstractPluginRelatedEventHandler {
        public ReplicationJobRestartedEventHandler(OpenSearchBpcPluginSocket socket) {
            super(socket);
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String replicationJobId = (String)event.getProperty("replicationJobId");
            String serverUUID = (String)event.getProperty("serverUUID");
            String transactionId = (String)event.getProperty("transactionId");
            ReplicationJobRestartAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = new ReplicationJobRestartAcknowledgementWebsocketMessage(replicationJobId, serverUUID, transactionId);
            this.sendWebsocketMessageAsync((WebsocketMessage)acknowledgementWebsocketMessage);
        }
    }

    private abstract class AbstractPluginRelatedEventHandler
    extends AbstractEventHandler {
        private final OpenSearchBpcPluginSocket socket;

        protected AbstractPluginRelatedEventHandler(OpenSearchBpcPluginSocket socket) {
            this.socket = socket;
        }

        protected void sendWebsocketMessageSync(WebsocketMessage websocketMessage) {
            this.socket.sendWebsocketMessageSync(websocketMessage);
        }

        protected void sendWebsocketMessageAsync(WebsocketMessage websocketMessage) {
            this.socket.sendWebsocketMessageAsync(websocketMessage);
        }
    }

    private class IndexCreatedWebsocketMessageProcessor
    implements WebsocketMessageProcessor<IndexCreatedWebsocketMessage> {
        private IndexCreatedWebsocketMessageProcessor() {
        }

        @Override
        public void process(IndexCreatedWebsocketMessage websocketMessage) {
            LOGGER.info("{}.process websocketMessage=...", (Object)this.getClass().getSimpleName());
        }
    }

    private class IndexDeletedWebsocketMessageProcessor
    implements WebsocketMessageProcessor<IndexDeletedWebsocketMessage> {
        private IndexDeletedWebsocketMessageProcessor() {
        }

        @Override
        public void process(IndexDeletedWebsocketMessage websocketMessage) {
            LOGGER.info("{}.process websocketMessage=...", (Object)this.getClass().getSimpleName());
            try {
                String index = websocketMessage.getIndexName();
                if (index != null && !index.endsWith("_creation_lock")) {
                    String aliasOfBpcIndex = OpenSearchBpcPluginListener.this.openSearchServiceTracker.getService().aliasFromBpcIndexName(index);
                    OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "IndexDeleted", MapUtil.mapOf("index", index, "aliasOfBpcIndex", aliasOfBpcIndex));
                }
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("{}: Failed to process the WebSocket message due to missing service.", (Object)this.getClass().getSimpleName(), (Object)ex);
                OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
            }
        }
    }

    private class IndexOperationWebsocketMessageProcessor
    implements WebsocketMessageProcessor<IndexOperationWebsocketMessage> {
        private IndexOperationWebsocketMessageProcessor() {
        }

        @Override
        public void process(IndexOperationWebsocketMessage websocketMessage) {
            LOGGER.info("{}.process websocketMessage=...", (Object)this.getClass().getSimpleName());
            try {
                IndexOperationDTO indexOperation = websocketMessage.getIndexOperation();
                if (indexOperation != null) {
                    OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "IndexOperation", indexOperation);
                }
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("{}: Failed to process the WebSocket message due to missing service.", (Object)this.getClass().getSimpleName(), (Object)ex);
                OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
            }
        }
    }

    private class BroadcastWebsocketMessageProcessor
    implements WebsocketMessageProcessor<BroadcastWebsocketMessage> {
        private BroadcastWebsocketMessageProcessor() {
        }

        @Override
        public void process(BroadcastWebsocketMessage websocketMessage) {
            LOGGER.info("{}.process websocketMessage=...", (Object)this.getClass().getSimpleName());
            try {
                if (websocketMessage.isType(BroadcastImpl.BroadcastType.ClientEvent.name())) {
                    Map eventData = websocketMessage.getData();
                    OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/client/" + eventData.get("event"), "data", eventData.get("data"));
                } else {
                    OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "BroadcastMessage", websocketMessage);
                }
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("{}: Failed to process the WebSocket message due to missing service.", (Object)this.getClass().getSimpleName(), (Object)ex);
                OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
            }
        }
    }

    private class WebsocketMessageForFrontendSessionProcessor
    implements WebsocketMessageProcessor<WebsocketMessageForFrontendSession> {
        private WebsocketMessageForFrontendSessionProcessor() {
        }

        @Override
        public void process(WebsocketMessageForFrontendSession websocketMessage) {
            LOGGER.info("{}.process websocketMessage=...", (Object)this.getClass().getSimpleName());
            try {
                String sessionId = websocketMessage.getSessionId();
                String json = websocketMessage.getMessage();
                ClientSessionManager clientSessionManager = OpenSearchBpcPluginListener.this.clientSessionManagerTracker.getService();
                if (sessionId.equalsIgnoreCase("ALL")) {
                    clientSessionManager.broadcastMessage(json);
                } else {
                    clientSessionManager.sendByWebsocket(sessionId, json);
                }
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("{}: Failed to process the WebSocket message due to missing service.", (Object)this.getClass().getSimpleName(), (Object)ex);
                OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the ClientSessionManager service", ex);
            }
        }
    }

    private class SimpleEventFiringWebsocketMessageProcessor<T extends WebsocketMessage>
    implements WebsocketMessageProcessor<T> {
        private final String eventPropertyName;

        public SimpleEventFiringWebsocketMessageProcessor(String eventPropertyName) {
            this.eventPropertyName = eventPropertyName;
        }

        @Override
        public void process(T websocketMessage) {
            LOGGER.info("{}.process websocketMessage=... ({})", (Object)this.getClass().getSimpleName(), (Object)this.eventPropertyName);
            try {
                OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", this.eventPropertyName, websocketMessage);
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("{}: Failed to fire the received websocket message as os-bpc-plugin event with the property name '{}'.", (Object)this.getClass().getSimpleName(), (Object)this.eventPropertyName, (Object)ex);
                OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
            }
        }
    }

    private static interface WebsocketMessageProcessor<T extends WebsocketMessage> {
        public void process(T var1);
    }
}

