/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.replicator.DbColumnNamesToOpenSearchFieldNamesConverter;
import de.virtimo.bpc.core.replicator.DbResultSetToJsonConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.opensearch.core.xcontent.XContentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VamSpecificXmlTypeProcessor {
    private final MappingFields mappingFields;
    private final DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter;

    public VamSpecificXmlTypeProcessor(OpenSearchService oss, String indexName, DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter) {
        this(new MappingFields(oss, indexName), dbColumnNamesToOpenSearchFieldNamesConverter);
    }

    public VamSpecificXmlTypeProcessor(MappingFields mappingFields, DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter) {
        this.mappingFields = mappingFields;
        this.dbColumnNamesToOpenSearchFieldNamesConverter = dbColumnNamesToOpenSearchFieldNamesConverter;
    }

    public void appendVAMAttributes(OpenSearchService oss, XContentBuilder jsonObject, LookupJoins lookupJoins, DOMSource columnValue) throws IOException, OpenSearchRelatedException {
        Element root = ((Document)columnValue.getNode()).getDocumentElement();
        NodeList l = root.getChildNodes();
        for (int i = l.getLength() - 1; i >= 0; --i) {
            Node n = l.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals("attribute")) continue;
            this.appendVAMAttributeDescendants(oss, jsonObject, lookupJoins, "VA__", (Element)n);
        }
    }

    private void appendVAMAttributeDescendants(OpenSearchService oss, XContentBuilder jsonObject, LookupJoins lookupJoins, String prefix, Element attribute) throws IOException, OpenSearchRelatedException {
        List<Map<String, Object>> rows;
        Object columnName = this.childElementText(attribute, "key");
        if (columnName == null) {
            return;
        }
        columnName = ((String)columnName).replaceAll("[^\\p{L}0-9_-]", "_");
        columnName = prefix + (String)columnName;
        String openSearchFieldName = this.dbColumnNamesToOpenSearchFieldNamesConverter.convert((String)columnName);
        boolean columnIsOrCouldBeJsonField = this.mappingFields.isOrCouldBeJsonField((String)columnName);
        boolean columnIsJsonField = this.mappingFields.isJsonField((String)columnName);
        Element valueElement = this.childElement(attribute, "value");
        List<Map<String, Object>> list = rows = columnIsOrCouldBeJsonField ? this.getRows(valueElement) : null;
        if (rows != null) {
            jsonObject.field(openSearchFieldName, rows);
            this.mappingFields.keepFieldInfo((String)columnName, true);
        } else {
            String value = this.elementText(valueElement);
            if (value != null) {
                if (columnIsJsonField) {
                    value = null;
                }
                jsonObject.field(openSearchFieldName, value);
                DbResultSetToJsonConverter.appendLookupData(oss, jsonObject, lookupJoins, (String)columnName, value, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                if (!columnIsJsonField) {
                    this.mappingFields.keepFieldInfo((String)columnName, false);
                }
            } else {
                Element group = this.childElement(attribute, "attributes");
                if (group != null) {
                    NodeList l = group.getChildNodes();
                    for (int i = l.getLength() - 1; i >= 0; --i) {
                        Node n = l.item(i);
                        if (n.getNodeType() != 1 || !n.getNodeName().equals("attribute")) continue;
                        this.appendVAMAttributeDescendants(oss, jsonObject, lookupJoins, (String)columnName + "__", (Element)n);
                    }
                }
            }
        }
    }

    private String childElementText(Element e, String name) {
        return this.elementText(this.childElement(e, name));
    }

    private String elementText(Element result) {
        String s = result != null ? result.getTextContent() : null;
        return "".equals(s) ? null : s;
    }

    private Element childElement(Element e, String name) {
        Element result = null;
        NodeList l = e.getChildNodes();
        for (int i = l.getLength() - 1; i >= 0; --i) {
            Node c = l.item(i);
            if (c.getNodeType() != 1 || !c.getNodeName().equals(name)) continue;
            if (result != null) {
                return null;
            }
            result = (Element)c;
        }
        return result;
    }

    private List<Map<String, Object>> getRows(Element valueElement) {
        if (valueElement == null || valueElement.getNodeType() != 1) {
            return null;
        }
        NodeList valueChildNodes = valueElement.getChildNodes();
        if (valueChildNodes == null || valueChildNodes.getLength() <= 0) {
            return null;
        }
        Node rowsNode = null;
        for (int m = 0; m < valueChildNodes.getLength(); ++m) {
            Node valueChildNode = valueChildNodes.item(m);
            if (valueChildNode.getNodeType() != 1 || !"rows".equals(valueChildNode.getNodeName())) continue;
            rowsNode = valueChildNode;
            break;
        }
        if (rowsNode == null) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        NodeList rowsChildNodes = rowsNode.getChildNodes();
        for (int l = 0; l < rowsChildNodes.getLength(); ++l) {
            Node rowNode = rowsChildNodes.item(l);
            if (!rowNode.hasChildNodes()) continue;
            HashMap<String, String> rowMap = new HashMap<String, String>();
            NodeList rowEntries = rowNode.getChildNodes();
            for (int m = 0; m < rowEntries.getLength(); ++m) {
                Node rowEntryNode = rowEntries.item(m);
                if (rowEntryNode.getNodeType() != 1) continue;
                String rowAttributeName = rowEntryNode.getNodeName();
                String rowAttributeValue = rowEntryNode.getTextContent();
                if (rowAttributeValue != null && rowAttributeValue.trim().length() == 0) {
                    rowAttributeValue = null;
                }
                rowMap.put(rowAttributeName, rowAttributeValue);
            }
            result.add(rowMap);
        }
        return result;
    }

    public static class MappingFields {
        private Map<String, Boolean> knownJsonFields;

        public MappingFields() {
            this.knownJsonFields = new HashMap<String, Boolean>();
        }

        public MappingFields(OpenSearchService oss, String indexName) {
            Map<String, Object> currentMapping = oss.getMapping(indexName);
            this.knownJsonFields = this.getJsonFieldsFromIndexMapping(currentMapping);
        }

        public boolean isOrCouldBeJsonField(String fieldName) {
            return !this.knownJsonFields.containsKey(fieldName) || this.knownJsonFields.get(fieldName) == true;
        }

        public boolean isJsonField(String fieldName) {
            return this.knownJsonFields.containsKey(fieldName) && this.knownJsonFields.get(fieldName) == true;
        }

        public void keepFieldInfo(String fieldName, boolean jsonField) {
            this.knownJsonFields.put(fieldName, jsonField);
        }

        private Map<String, Boolean> getJsonFieldsFromIndexMapping(Map<String, Object> mapping) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            if (mapping == null || !mapping.containsKey("properties")) {
                return result;
            }
            Map properties = (Map)mapping.get("properties");
            properties.forEach((fieldName, settings) -> {
                Object typeValueObject = settings.get("type");
                if (typeValueObject == null) {
                    result.put((String)fieldName, true);
                } else if (typeValueObject instanceof String && "nested".equalsIgnoreCase((String)typeValueObject)) {
                    result.put((String)fieldName, true);
                } else if (settings.containsKey("properties")) {
                    result.put((String)fieldName, true);
                } else {
                    result.put((String)fieldName, false);
                }
            });
            return result;
        }
    }
}

