/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckResult;
import java.util.Date;

public class ConsistencyCheck {
    public static final String REPLICATION_CONSISTENCY_CHECK_FREQUENCY_FIELD = "replicationConsistencyCheckFrequency";
    public static final int DEFAULT_REPLICATION_CONSISTENCY_CHECK_FREQUENCY = 0;
    private boolean sourceAndTargetConsistent = true;
    private int consistencyCheckFrequency;
    private boolean running;
    private long runCount;
    private long errorCount;
    private Date lastRunStart;
    private Date lastRunEnd;
    private long lastRunSourceDocsCount;
    private long lastRunTargetDocsCount;

    public ConsistencyCheck(ModuleConfiguration jobConfig) {
        this.consistencyCheckFrequency = jobConfig.getSettingValue(REPLICATION_CONSISTENCY_CHECK_FREQUENCY_FIELD).asInt(0);
    }

    public void started() {
        this.running = true;
        this.lastRunStart = new Date();
        this.lastRunEnd = null;
    }

    public void increaseRunCount() {
        ++this.runCount;
    }

    public void increaseErrorCount() {
        ++this.errorCount;
    }

    public void setLastRunResult(ConsistencyCheckResult consistencyCheckResult) {
        this.sourceAndTargetConsistent = consistencyCheckResult.areSourceAndTargetConsistent();
        this.lastRunSourceDocsCount = consistencyCheckResult.getNumberOfSourceRows();
        this.lastRunTargetDocsCount = consistencyCheckResult.getNumberOfTargetDocuments();
    }

    public void stopped() {
        this.running = false;
        this.lastRunEnd = new Date();
    }

    public boolean areSourceAndTargetConsistent() {
        return this.sourceAndTargetConsistent;
    }

    public int getConsistencyCheckFrequency() {
        return this.consistencyCheckFrequency;
    }

    public boolean isEnabled() {
        return this.consistencyCheckFrequency > 0;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getRunCount() {
        return this.runCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public Date getLastRunStart() {
        return this.lastRunStart;
    }

    public Date getLastRunEnd() {
        return this.lastRunEnd;
    }

    public long getLastRunSourceDocsCount() {
        return this.lastRunSourceDocsCount;
    }

    public long getLastRunTargetDocsCount() {
        return this.lastRunTargetDocsCount;
    }

    public String toString() {
        return "ConsistencyCheck{sourceAndTargetConsistent=" + this.sourceAndTargetConsistent + ", consistencyCheckFrequency=" + this.consistencyCheckFrequency + "}";
    }
}

