/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserFlowIdentityProvider;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ModuleConfigurationNotFoundException;
import de.virtimo.bpc.api.exception.ModuleInstanceCreateException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotInstantiableException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexInfo;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.SettingsImpl;
import de.virtimo.bpc.core.apikey.APIKey;
import de.virtimo.bpc.core.auth.keycloak.KeycloakIdentityProvider;
import de.virtimo.bpc.core.deployment.DeploymentInitiatorImpl;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.exception.SettingNotFoundException;
import de.virtimo.bpc.core.resource.response.MaskPasswords;
import de.virtimo.bpc.core.resource.response.UserSessionBasedGlobalConfigImpl;
import de.virtimo.bpc.core.resource.response.UserSessionBasedModuleConfigImpl;
import de.virtimo.bpc.core.resource.response.UserSessionBasedModuleInstanceConfigImpl;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.module.simple.SimpleSettingSerializer;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.UUIDGenerator;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="configuration")
@Tag(name="Configuration API", description="These are the configuration endpoints.")
public class ConfigurationEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<EventManager> eventManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private BpcServicesTracker<CoreBundleService> coreBundleServiceTracker;

    public ConfigurationEndpoint(BundleContext bundleContext) {
        LOGGER.info("ConfigurationEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(this.bundleContext, OpenSearchBpcPluginManager.class);
        this.coreBundleServiceTracker = new BpcServicesTracker<CoreBundleService>(this.bundleContext, CoreBundleService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private String serializeGlobalConfig(GlobalConfig globalConfig, UserSession userSession, ModuleManager moduleManager) throws JsonProcessingException {
        return this._serializeWithSpecialMapper(globalConfig, userSession, moduleManager);
    }

    private String serializeModuleConfig(UserSessionBasedModuleConfigImpl moduleConfig, UserSession userSession, ModuleManager moduleManager) throws JsonProcessingException {
        return this._serializeWithSpecialMapper(moduleConfig, userSession, moduleManager);
    }

    private String serializeModuleInstanceConfig(UserSessionBasedModuleInstanceConfigImpl moduleInstanceConfig, UserSession userSession, ModuleManager moduleManager) throws JsonProcessingException {
        return this._serializeWithSpecialMapper(moduleInstanceConfig, userSession, moduleManager);
    }

    private String _serializeWithSpecialMapper(Object objectToSerialize, UserSession userSession, ModuleManager moduleManager) throws JsonProcessingException {
        ObjectMapper mapper = ObjectMapperPool.createCustomizedObjectMapper();
        mapper.setConfig(SimpleSettingSerializer.getSerializationConfig(mapper, userSession, moduleManager));
        return mapper.writeValueAsString(objectToSerialize);
    }

    @OperationDescription(summary="Get a complete version of the BPC configuration.", description="Get a complete version of the BPC configuration.\n\nIt will contain all modules, instances and their settings, but restricted to the rights the user has.\n\nEvery module provides the default configuration of itself and for instances.\n\nAdditionally, some metadata like the model version and infos about the used `bpc-configuration` index is provided.\n\n[source,json]\n----\n{\n   \"metadata\": {\n     \"modelVersion\": {current model version},\n     \"fromIndex\": { settings and mappings of the bpc-configuration index }\n   },\n   \"modules\": [\n     {\n         \"moduleId\": \"{id of the module}\",\n         \"moduleName\": \"{name of the module}\",\n         \"settings\": [ ... ],\n         \"instances\": [ ... ],\n         \"defaultConfiguration\": [ ... ],\n         \"instancesDefaultConfiguration\": [ ... ]\n     },\n     ...\n   ]\n}\n----\n")
    @ReturnDescription(value="The requested data as JSON")
    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getConfiguration(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getConfiguration");
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            BpcIndexInfo fromIndex = oss.getBpcIndexInfoUsingIndexAlias("bpc-configuration");
            boolean embedMetadata = userSession != null && userSession.hasRole("bpcadmin") || CoreModule.isRequestFromOtherBpcServer(hh, coreBundleConfiguration, openSearchBpcPluginManager);
            boolean embedDefaultConfigurations = userSession != null && userSession.hasRole("bpcadmin") || CoreModule.isRequestFromOtherBpcServer(hh, coreBundleConfiguration, openSearchBpcPluginManager);
            boolean embedStorageServiceData = userSession != null && DeploymentInitiatorImpl.isRequestFromDeploymentInitiator(hh);
            UserSessionBasedGlobalConfigImpl globalConfig = new UserSessionBasedGlobalConfigImpl(moduleManager, fromIndex, userSession, true, false, false, embedMetadata, true, embedDefaultConfigurations, embedStorageServiceData);
            return Response.ok((Object)this.serializeGlobalConfig(globalConfig, userSession, moduleManager)).build();
        }
        catch (Exception ex) {
            LOGGER.error("Get configuration failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Get a compact version of the BPC configuration.", description="Get a compact version of the BPC configuration.\n\nIt will contain all modules, instances and their settings, but restricted to the rights the user has.\nAnd it will return only the settings were the `_mandatoryForFrontend` flag is set to `true`.\n\nAdditionally, the metadata about the model version is provided.\n\n[source,json]\n----\n{\n   \"metadata\": {\n     \"modelVersion\": {current model version}\n   },\n   \"modules\": [\n     {\n         \"moduleId\": \"{id of the module}\",\n         \"moduleName\": \"{name of the module}\",\n         \"settings\": [ ... ],\n         \"instances\": [ ... ]\n     },\n     ...\n   ]\n}\n----\n")
    @ReturnDescription(value="The requested data as JSON")
    @GET
    @Path(value="/compact")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getCompactConfiguration(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getCompactConfiguration");
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            BpcIndexInfo fromIndex = oss.getBpcIndexInfoUsingIndexAlias("bpc-configuration");
            boolean embedMetadata = userSession != null && userSession.hasRole("bpcadmin");
            UserSessionBasedGlobalConfigImpl globalConfig = new UserSessionBasedGlobalConfigImpl(moduleManager, fromIndex, userSession, true, false, true, embedMetadata, false, false, false);
            return Response.ok((Object)this.serializeGlobalConfig(globalConfig, userSession, moduleManager)).build();
        }
        catch (Exception ex) {
            LOGGER.error("Get configuration failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/init")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the base BPC configuration to initialize the frontend.", description="Get the base BPC configuration to initialize the frontend.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getInitConfiguration(@Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("getInitConfiguration");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            ModuleConfiguration coreModuleConfig = coreModule.getConfiguration();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            CoreBundleService coreBundleService = this.coreBundleServiceTracker.getService();
            HashMap<String, Object> settingMap = new HashMap<String, Object>();
            settingMap.put("themes_available", coreBundleService.getThemeBundles());
            settingMap.put("login_showTenant", coreModuleConfig.getSettingValue("login_showTenant").asBoolean(true));
            settingMap.put("login_tenantDefaultValue", coreModuleConfig.getSettingValue("login_tenantDefaultValue").asString(null));
            settingMap.put("theme_name", coreModuleConfig.getSettingValue("theme_name").asString(null));
            settingMap.put("login_welcomeMsg", coreModuleConfig.getSettingValue("login_welcomeMsg").asString(null));
            settingMap.put("welcomeNotification", coreModuleConfig.getSettingValue("welcomeNotification").asString(null));
            settingMap.put("login_title", coreModuleConfig.getSettingValue("login_title").asString(null));
            settingMap.put("login_showReset", coreModuleConfig.getSettingValue("login_showReset").asBoolean(false));
            settingMap.put("browser_title", coreModuleConfig.getSettingValue("browser_title").asString(null));
            settingMap.put("core_name", coreBundleConfiguration.getBpcName());
            settingMap.put("maintenanceMode_enabled", coreBundleConfiguration.isMaintenanceModeEnabled());
            settingMap.put("maintenanceMode_message", coreBundleConfiguration.getMaintenanceModeMessage());
            settingMap.put("bpc_cookie_name", coreBundleConfiguration.getCookieName());
            settingMap.put("login_defaultLanguage", coreModuleConfig.getSettingValue("login_defaultLanguage").asString(null));
            settingMap.put("login_showLanguageSelector", coreModuleConfig.getSettingValue("login_showLanguageSelector").asBoolean(true));
            settingMap.put("baseUrl", coreModuleConfig.getSettingValue("baseUrl").asString(null));
            settingMap.put("moduleUrl", coreModuleConfig.getSettingValue("moduleUrl").asString(null));
            settingMap.put("cookie_showBanner", coreModuleConfig.getSettingValue("cookie_showBanner").asBoolean(false));
            settingMap.put("cookie_bannerText", coreModuleConfig.getSettingValue("cookie_bannerText").asString(null));
            IdentityProvider identityProvider = coreModule.getIdentityProvider();
            if (identityProvider instanceof UserFlowIdentityProvider) {
                UserFlowIdentityProvider userFlowIdentityProvider = (UserFlowIdentityProvider)identityProvider;
                settingMap.put("login_redirectUrl", userFlowIdentityProvider.createAuthenticationRequestURI(req.getRequestURL().toString()));
                if (identityProvider instanceof KeycloakIdentityProvider) {
                    KeycloakIdentityProvider keycloakIdentityProvider = (KeycloakIdentityProvider)identityProvider;
                    settingMap.put("identityProvider_updateProfileUrl", keycloakIdentityProvider.getUpdateProfileUrl(req.getRequestURL().toString()));
                    settingMap.put("identityProvider_updatePasswordUrl", keycloakIdentityProvider.getUpdatePasswordUrl(req.getRequestURL().toString()));
                    settingMap.put("identityProvider_configureTotp", keycloakIdentityProvider.getConfigureTotpUrl(req.getRequestURL().toString()));
                }
            }
            settingMap.put("gui_favIcon", coreModuleConfig.getSettingValue("gui_favIcon").asString(null));
            ModuleConfiguration idpBackendConnectionConfig = ((InstantiableModule)this.moduleManagerTracker.getService().getModuleById("backendconnection")).getInstanceConfiguration(coreModuleConfig.getSettingValue("identityProviderBackendConnection").asString(null));
            settingMap.put("identityProvider_ussChangeOrganisationEnabled", idpBackendConnectionConfig.getSettingValue("identityProvider_ussChangeOrganisationEnabled").asBoolean(false));
            settingMap.put("identityProvider_ussChangePasswordEnabled", idpBackendConnectionConfig.getSettingValue("identityProvider_ussChangePasswordEnabled").asBoolean(false));
            return Response.ok(settingMap).build();
        }
        catch (Exception ex) {
            LOGGER.error("Get init configuration failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/uuid/generate")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Generates unique IDs using \"SHA-256\".", description="Generates unique IDs using \"SHA-256\". The result is a 256bit long UUID as HEX String.")
    @ReturnDescription(value="The requested UUIDs as JSON array.")
    public Response generateUUIDs(@Parameter(description="the number of UUIDs to generate. Must be in the range 1-1000.") @QueryParam(value="count") @DefaultValue(value="1") int count, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("generateUUIDs count={}", (Object)count);
        try {
            if (count < 1 || count > 1000) {
                throw new IllegalArgumentException("'count' must be in the range 1-1000");
            }
            ArrayList<String> uuids = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                uuids.add(UUIDGenerator.randomUUID());
            }
            return Response.ok(uuids).build();
        }
        catch (Exception ex) {
            LOGGER.error("Generation of UUIDs failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Generates a unique API key.", description="Generates a unique API key using \"SHA-256\" (256bit long UUID as HEX String) and the ID of the API key.\n\n.example response\n[source,json]\n----\n{\n   \"apiKey\": \"039c969b4ec2e3d8f23cfca226c932403318d5b53e6653782f8e0e163c772e1e\",\n   \"id\": \"API-34c05ef\"\n}\n----\n")
    @ReturnDescription(value="The requested data as JSON object.")
    @GET
    @Path(value="/apikey/generate")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response generateAPIKey(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("generateAPIKey");
        try {
            String apiKey = UUIDGenerator.randomUUID();
            Map<String, String> result = Map.of("apiKey", apiKey, "id", APIKey.generateId(apiKey));
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOGGER.error("Generation of API key failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{moduleId}/{instanceType}/newInstanceId")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get a new instance ID for the provided module and module type.", description="Get a new instance ID for the provided module and module type.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getNewModuleInstanceId(@Parameter(description="the ID of the module to get a new instance ID for") @PathParam(value="moduleId") String moduleId, @Parameter(description="the instance type, provide 'none' in case the module does not support different types") @PathParam(value="instanceType") String instanceType, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getNewModuleInstanceId moduleId={}", (Object)moduleId);
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Module module = moduleManager.getModule(moduleId);
            if (module == null) {
                HashSet<String> moduleIDsOfLoadedInstantiableModules = new HashSet<String>();
                Map<String, Module> loadedModules = moduleManager.getLoadedModules();
                for (Module loadedModule : loadedModules.values()) {
                    if (!(loadedModule instanceof InstantiableModule)) continue;
                    moduleIDsOfLoadedInstantiableModules.add(loadedModule.getModuleId());
                }
                throw new SystemException((ErrorCode)BpcErrorCode.MODULE_NOT_FOUND, "Please use the ID of one of the loaded and instantiable modules: ${loadedInstantiableModules}", MapUtil.mapOf("loadedInstantiableModules", StringUtil.implode(", ", moduleIDsOfLoadedInstantiableModules)));
            }
            if (!(module instanceof InstantiableModule)) {
                throw new ModuleNotInstantiableException(moduleId);
            }
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            InstantiableModule instantiableModule = (InstantiableModule)module;
            String[] instanceTypes = instantiableModule.getSupportedInstanceTypes();
            if (instanceTypes != null) {
                Set<String> its = SetUtil.setOf(instanceTypes);
                if (!its.contains(instanceType)) {
                    throw new SystemException((ErrorCode)BpcErrorCode.MODULE_NOT_FOUND, "Please use one of the instance types the module '${moduleId}' supports: ${instanceTypes}", MapUtil.mapOf("moduleId", moduleId, "instanceTypes", StringUtil.implode(", ", instanceTypes)));
                }
            } else if (!instanceType.equals("none")) {
                throw new SystemException((ErrorCode)BpcErrorCode.MODULE_NOT_FOUND, "Please use 'none' as instance type.");
            }
            long instanceId = System.currentTimeMillis();
            HashMap<String, Object> resp = new HashMap<String, Object>();
            resp.put("moduleId", moduleId);
            resp.put("instanceType", instanceType);
            resp.put("instanceId", "" + instanceId);
            return Response.ok(resp).build();
        }
        catch (Exception ex) {
            LOGGER.error("Get new module instance id failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private UserSessionBasedModuleConfigImpl _getModuleConfig(String moduleId, ModuleManager moduleManager, UserSession userSession) throws ModuleNotFoundException {
        LOGGER.info("_getModuleConfig moduleId={}, moduleManager=..., userSession=...", (Object)moduleId);
        moduleId = this.cleanUpModuleId(moduleId);
        Module module = moduleManager.getModuleById(moduleId);
        if (!userSession.hasLoadModuleRight(module)) {
            throw new ModuleNotFoundException(moduleId);
        }
        return new UserSessionBasedModuleConfigImpl(module, userSession, false, true, false, true, false);
    }

    private UserSessionBasedModuleInstanceConfigImpl _getModuleInstanceConfig(String moduleId, String moduleInstanceId, ModuleManager moduleManager, UserSession userSession) throws ModuleNotFoundException, ModuleNotInstantiableException, ModuleInstanceNotFoundException {
        LOGGER.info("_getModuleInstanceConfig moduleId={}, moduleInstanceId={}, moduleManager=..., userSession=...", (Object)moduleId, (Object)moduleInstanceId);
        moduleId = this.cleanUpModuleId(moduleId);
        Module module = moduleManager.getModuleById(moduleId);
        if (!(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId);
        }
        if (!userSession.hasLoadModuleRight(module)) {
            throw new ModuleNotFoundException(moduleId);
        }
        ModuleInstance moduleInstance = ((InstantiableModule)module).getModuleInstanceById(moduleInstanceId);
        if (!userSession.hasUseModuleInstanceRight(moduleInstance)) {
            throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
        }
        return new UserSessionBasedModuleInstanceConfigImpl(moduleInstance, userSession, false, false);
    }

    @OperationDescription(summary="Get the configuration of a specific module.", description="Get the configuration of a specific module.\n\nThe result contains the settings of the module, but restricted to the rights the user has.\n\nAdditionally, the default configuration of itself and for instances is provided.\n\nContains a compact list of instances with the ID, type and name when it is an instantiable module.\n\n[source,json]\n----\n{\n   \"moduleId\": \"{id of the module}\",\n   \"moduleName\": \"{name of the related module}\",\n   \"settings\": [ ... ],\n   \"instancesCompact\": [ ... ],\n   \"defaultConfiguration\": [ ... ],\n   \"instancesDefaultConfiguration\": [ ... ]\n}\n----\n")
    @ReturnDescription(value="The requested data as JSON")
    @Produces(value={"application/json"})
    @GET
    @Path(value="/{moduleId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getModuleConfiguration(@Parameter(description="the ID of the module") @PathParam(value="moduleId") String moduleId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getModuleConfiguration moduleId={}", (Object)moduleId);
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            UserSessionBasedModuleConfigImpl moduleConfig = this._getModuleConfig(moduleId, moduleManager, userSession);
            return Response.ok((Object)this.serializeModuleConfig(moduleConfig, userSession, moduleManager)).build();
        }
        catch (Exception ex) {
            LOGGER.error("Get module configuration failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Get the configuration of a specific module instance.", description="Get the configuration of a specific module instance.\n\nIn case the configuration of an instance is requested, just the settings the user has access rights for are returned.\n\n[source,json]\n----\n{\n   \"moduleId\": \"{moduleInstanceId}\",\n   \"moduleName\": \"{name of the related module}\",\n   \"instanceType\": \"none\\|{instance type}\",\n   \"settings\": [ ... ]\n}\n----\n\nIn case the configuration of a module is requested, it returns the same as the endpoint without the `moduleInstanceId` path parameter.\n")
    @ReturnDescription(value="The requested data as JSON")
    @Produces(value={"application/json"})
    @GET
    @Path(value="/{moduleId}/{moduleInstanceId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getModuleConfiguration(@Parameter(description="the ID of the related module") @PathParam(value="moduleId") String moduleId, @Parameter(description="the ID of the module instance, can be set to 'noinstance' to get the module configuration instead") @PathParam(value="moduleInstanceId") String moduleInstanceId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getModuleConfiguration moduleId={}, moduleInstanceId={}", (Object)moduleId, (Object)moduleInstanceId);
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            if ("noinstance".equalsIgnoreCase(moduleInstanceId)) {
                UserSessionBasedModuleConfigImpl moduleConfig = this._getModuleConfig(moduleId, moduleManager, userSession);
                return Response.ok((Object)this.serializeModuleConfig(moduleConfig, userSession, moduleManager)).build();
            }
            UserSessionBasedModuleInstanceConfigImpl moduleInstanceConfig = this._getModuleInstanceConfig(moduleId, moduleInstanceId, moduleManager, userSession);
            return Response.ok((Object)this.serializeModuleInstanceConfig(moduleInstanceConfig, userSession, moduleManager)).build();
        }
        catch (Exception ex) {
            LOGGER.error("Get module instance configuration failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Response _setModuleConfiguration(String moduleId, List<Setting> settingsList, boolean force, UserSession userSession, HttpHeaders hh, ModuleManager moduleManager, EventManager eventManager) throws ModuleNotFoundException, SettingException, ValidationException, ServiceNotFoundException {
        CoreModule coreModule;
        LOGGER.info("_setModuleConfiguration moduleId={}, settingsList=..., force={}, userSession=..., hh=..., moduleManager=..., eventManager=...", (Object)moduleId, (Object)force);
        moduleId = this.cleanUpModuleId(moduleId);
        if (settingsList == null) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No 'settings' given");
        }
        Module module = moduleManager.getModuleById(moduleId);
        SettingsImpl settings = new SettingsImpl(settingsList);
        if (!userSession.hasLoadModuleRight(module)) {
            throw new ModuleNotFoundException(moduleId);
        }
        if (!userSession.hasWriteAccessToSettings(module, settings)) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "Not allowed to change the setting(s) of module '${moduleId}'.", MapUtil.mapOf("moduleId", moduleId));
        }
        SettingsImpl existingSettings = new SettingsImpl(module.getConfiguration().getSettings().values());
        settings.unmaskPasswords(existingSettings);
        Settings oldSettings = module.getConfiguration().getSettingsByName(settings.getNames());
        SettingsImpl newSettings = new SettingsImpl(settings);
        List<FrontendWarningException> frontendWarnings = null;
        if (!force) {
            frontendWarnings = moduleManager.validateModuleSettings(moduleId, existingSettings, settings);
        }
        if ((coreModule = (CoreModule)moduleManager.getModuleById("_core")).isBpcConfigurationIndexBackupOnChangesEnabled() && coreModule.isBpcConfigurationIndexBackupNecessary(settings)) {
            coreModule.createBpcConfigurationSnapshot(userSession);
        }
        for (Setting setting : settings) {
            setting.setModuleId(moduleId);
            setting.setInstanceId("noinstance");
            module.getConfiguration().updateSetting(setting);
        }
        UserAuditLog.info(userSession, "ModuleUpdated", "Settings of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") updated: " + StringUtil.implode(", ", settings.getNames()), (Object)JsonUtil.getInstance().convertPojoToJsonString(oldSettings.maskPasswords(), null), (Object)JsonUtil.getInstance().convertPojoToJsonString(newSettings.maskPasswords(), null));
        eventManager.broadcast().moduleUpdated(moduleId);
        if (frontendWarnings == null || frontendWarnings.isEmpty()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity(FrontendWarningException.asWarningsResponseMap(frontendWarnings, hh)).build();
    }

    private Response _setModuleInstanceConfiguration(String moduleId, String moduleInstanceId, String instanceType, boolean force, List<Setting> settingsList, UserSession userSession, HttpHeaders hh, ModuleManager moduleManager, EventManager eventManager) throws ModuleNotFoundException, ModuleNotInstantiableException, LicenseException, ValidationException, ModuleInstanceCreateException, SettingException, ModuleInstanceNotFoundException, ServiceNotFoundException {
        CoreModule coreModule;
        LOGGER.info("setModuleInstanceConfiguration moduleId={}, moduleInstanceId={}, instanceType={}, force={}, settingsList=..., userSession=..., hh=..., moduleManager=..., eventManager=...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType, (Object)force);
        moduleId = this.cleanUpModuleId(moduleId);
        Module module = moduleManager.getModuleById(moduleId);
        SettingsImpl settings = new SettingsImpl(settingsList);
        if (!userSession.hasLoadModuleRight(module)) {
            throw new ModuleNotFoundException(moduleId);
        }
        if (!(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId);
        }
        InstantiableModule instantiableModule = (InstantiableModule)module;
        ModuleInstance moduleInstance = instantiableModule.getModuleInstance(moduleInstanceId);
        if (moduleInstance == null) {
            Map<String, Module> allModules = moduleManager.getAllModules();
            for (String idOfModule : allModules.keySet()) {
                if (!idOfModule.equalsIgnoreCase(moduleInstanceId)) continue;
                throw new ModuleInstanceCreateException("Failed to create the instance '${instanceId}' of module '${moduleId}'. The used instance ID must no be the same as a module ID.", MapUtil.mapOf("moduleId", moduleId, "instanceId", moduleInstanceId));
            }
        }
        if (moduleInstance == null && !userSession.hasCreateModuleInstancesRight(instantiableModule)) {
            throw new ModuleInstanceCreateException("Failed to create the instance '${instanceId}' of module '${moduleId}'. Access right missing.", MapUtil.mapOf("moduleId", moduleId, "instanceId", moduleInstanceId));
        }
        if (moduleInstance == null) {
            for (Module m : moduleManager.getLoadedModules().values()) {
                InstantiableModule im;
                if (!(m instanceof InstantiableModule) || m.getModuleId().equalsIgnoreCase(moduleId) || (im = (InstantiableModule)m).getModuleInstance(moduleInstanceId) == null) continue;
                throw new ModuleInstanceCreateException("Failed to create the instance '${instanceId}' of module '${moduleId}'. A '${otherModuleId}' instance uses this id already.", MapUtil.mapOf("moduleId", moduleId, "instanceId", moduleInstanceId, "otherModuleId", m.getModuleId()));
            }
        }
        if (moduleInstance != null && !userSession.hasUseModuleInstanceRight(moduleInstance)) {
            throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
        }
        if (moduleInstance != null && !userSession.hasWriteAccessToSettings((Module)moduleInstance, settings)) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "Not allowed to change the setting(s) of instance '${instanceId}' of module '${moduleId}'.", MapUtil.mapOf("moduleId", moduleId, "instanceId", moduleInstanceId));
        }
        SettingsImpl existingSettings = null;
        if (moduleInstance != null) {
            existingSettings = new SettingsImpl(moduleInstance.getConfiguration().getSettings().values());
            settings.unmaskPasswords(existingSettings);
        }
        Settings oldSettings = moduleInstance == null ? null : moduleInstance.getConfiguration().getSettingsByName(settings.getNames());
        SettingsImpl newSettings = new SettingsImpl(settings);
        if (instanceType == null && moduleInstance != null) {
            instanceType = moduleInstance.getInstanceType();
        }
        List<FrontendWarningException> frontendWarnings = null;
        if (!force) {
            frontendWarnings = moduleManager.validateModuleInstanceSettings(moduleId, moduleInstanceId, instanceType, existingSettings, settings);
        }
        if ((coreModule = (CoreModule)moduleManager.getModuleById("_core")).isBpcConfigurationIndexBackupOnChangesEnabled() && coreModule.isBpcConfigurationIndexBackupNecessary(settings)) {
            coreModule.createBpcConfigurationSnapshot(userSession);
        }
        Response.ResponseBuilder positiveResponseBuild = Response.ok();
        if (moduleInstance == null) {
            SimpleModuleConfig instanceModuleConfiguration = new SimpleModuleConfig(settings);
            moduleInstance = instantiableModule.createModuleInstance(moduleInstanceId, instanceType, instanceModuleConfiguration);
            positiveResponseBuild.status(Response.Status.CREATED);
            UserAuditLog.info(userSession, "ModuleInstanceCreated", "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + moduleInstanceId + ") of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") created");
            instantiableModule.moduleInstanceCreated(moduleInstance);
            eventManager.broadcast().moduleInstanceCreated(moduleId, moduleInstanceId, instanceType);
        } else {
            for (Setting setting : settings) {
                setting.setModuleId(moduleId);
                setting.setInstanceId(moduleInstanceId);
                moduleInstance.getConfiguration().updateSetting(setting);
            }
            UserAuditLog.info(userSession, "ModuleInstanceUpdated", "Settings of module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + moduleInstanceId + ") of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") updated: " + StringUtil.implode(", ", settings.getNames()), (Object)JsonUtil.getInstance().convertPojoToJsonString(oldSettings.maskPasswords(), null), (Object)JsonUtil.getInstance().convertPojoToJsonString(newSettings.maskPasswords(), null));
            instantiableModule.moduleInstanceUpdated(moduleInstance);
            eventManager.broadcast().moduleInstanceUpdated(moduleId, moduleInstanceId, instanceType);
        }
        if (frontendWarnings == null || frontendWarnings.isEmpty()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity(FrontendWarningException.asWarningsResponseMap(frontendWarnings, hh)).build();
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/{moduleId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Set the module configuration provided in the body.", description="Set the module configuration provided in the body.")
    public Response setModuleConfiguration(@Parameter(description="the ID of the module to update") @PathParam(value="moduleId") String moduleId, List<SimpleSettingImpl> simpleSettings, @Parameter(description="`true` to skip the settings validation, `false` to perform a validation") @QueryParam(value="force") @DefaultValue(value="false") boolean force, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("setModuleConfiguration moduleId={}", (Object)moduleId);
        try {
            ArrayList<Setting> settings = new ArrayList<Setting>(simpleSettings);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            EventManager eventManager = this.eventManagerTracker.getService();
            return this._setModuleConfiguration(moduleId, settings, force, userSession, hh, moduleManager, eventManager);
        }
        catch (Exception ex) {
            LOGGER.error("Set module configuration failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/{moduleId}/{moduleInstanceId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Set the module instance configuration provided in the body.", description="Set the module instance configuration provided in the body.")
    public Response setModuleInstanceConfiguration(@Parameter(description="the ID of the related module") @PathParam(value="moduleId") String moduleId, @Parameter(description="the ID of the module instance to update") @PathParam(value="moduleInstanceId") String moduleInstanceId, @Parameter(description="the type of the module instance. Set to 'noinstance' if types are not supported by the module") @QueryParam(value="instanceType") String instanceType, @Parameter(description="`true` to skip the settings validation, `false` to perform a validation") @QueryParam(value="force") @DefaultValue(value="false") boolean force, List<SimpleSettingImpl> simpleSettings, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("setModuleInstanceConfiguration moduleId={}, moduleInstanceId={}, instanceType={}", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        try {
            ArrayList<Setting> settings = new ArrayList<Setting>(simpleSettings);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            EventManager eventManager = this.eventManagerTracker.getService();
            if ("noinstance".equals(moduleInstanceId)) {
                return this._setModuleConfiguration(moduleId, settings, force, userSession, hh, moduleManager, eventManager);
            }
            return this._setModuleInstanceConfiguration(moduleId, moduleInstanceId, instanceType, force, settings, userSession, hh, moduleManager, eventManager);
        }
        catch (Exception ex) {
            LOGGER.error("Set module instance configuration failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{moduleId}/{moduleInstanceId}/settings/{settingName}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Delete a single setting from a module instance.", description="Delete a single setting from a module instance. If this instance has a default value for this setting, the default will be restored.")
    public Response deleteModuleSetting(@Parameter(description="the ID of the related module") @PathParam(value="moduleId") String moduleId, @Parameter(description="the ID of the related module instance") @PathParam(value="moduleInstanceId") String moduleInstanceId, @Parameter(description="the name of the setting to delete") @PathParam(value="settingName") String settingName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("deleteModuleSetting moduleId={}, moduleInstanceId={}", (Object)moduleId, (Object)moduleInstanceId);
        try {
            moduleId = this.cleanUpModuleId(moduleId);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Module module = moduleManager.getModuleById(moduleId);
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            if (module instanceof InstantiableModule && !ModuleConfiguration.isNoModuleInstanceId(moduleInstanceId) && !userSession.hasUseModuleInstanceRight((ModuleInstance)(module = ((InstantiableModule)module).getModuleInstanceById(moduleInstanceId)))) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            Setting targetSetting = module.getConfiguration().getSetting(settingName);
            if (!userSession.hasWriteAccessToSetting(module, targetSetting)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "Not allowed to delete the setting of module '${moduleId}'.", MapUtil.mapOf("moduleId", moduleId));
            }
            CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
            if (coreModule.isBpcConfigurationIndexBackupOnChangesEnabled() && coreModule.isBpcConfigurationIndexBackupNecessary(Collections.singletonList(targetSetting))) {
                coreModule.createBpcConfigurationSnapshot(userSession);
            }
            this.deleteSetting(userSession, module, targetSetting);
            if (module instanceof ModuleInstance) {
                ModuleInstance moduleInstance = (ModuleInstance)module;
                moduleInstance.getParentModule().moduleInstanceUpdated(moduleInstance);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Delete module setting failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{moduleId}/{moduleInstanceId}/settings")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Delete a list of settings from a module instance.", description="Delete a list of settings (provided in the body) from a module instance.")
    public Response deleteModuleSettings(@Parameter(description="the ID of the module") @PathParam(value="moduleId") String moduleId, @Parameter(description="the ID of the module instance") @PathParam(value="moduleInstanceId") String moduleInstanceId, List<SimpleSettingImpl> simpleSettings, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("deleteModuleSettings moduleId={}, moduleInstanceId={}", (Object)moduleId, (Object)moduleInstanceId);
        try {
            moduleId = this.cleanUpModuleId(moduleId);
            ArrayList<Setting> settings = new ArrayList<Setting>(simpleSettings);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Module module = moduleManager.getModuleById(moduleId);
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            if (module instanceof InstantiableModule && !ModuleConfiguration.isNoModuleInstanceId(moduleInstanceId) && !userSession.hasUseModuleInstanceRight((ModuleInstance)(module = ((InstantiableModule)module).getModuleInstanceById(moduleInstanceId)))) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            if (!userSession.hasWriteAccessToSettings(module, settings)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "Not allowed to delete the setting(s) of module '${moduleId}'.", MapUtil.mapOf("moduleId", moduleId));
            }
            CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
            if (coreModule.isBpcConfigurationIndexBackupOnChangesEnabled() && coreModule.isBpcConfigurationIndexBackupNecessary(settings)) {
                coreModule.createBpcConfigurationSnapshot(userSession);
            }
            for (Setting setting : settings) {
                this.deleteSetting(userSession, module, setting);
            }
            if (module instanceof ModuleInstance) {
                ModuleInstance moduleInstance = (ModuleInstance)module;
                moduleInstance.getParentModule().moduleInstanceUpdated(moduleInstance);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Delete module setting failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{moduleId}/{moduleInstanceId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Delete a specific module instance.", description="Delete a specific module instance.")
    public Response deleteModuleInstance(@Parameter(description="the ID of the related module") @PathParam(value="moduleId") String moduleId, @Parameter(description="the ID of the module instance to delete") @PathParam(value="moduleInstanceId") String moduleInstanceId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("deleteModuleInstance moduleId={}, moduleInstanceId={}", (Object)moduleId, (Object)moduleInstanceId);
        try {
            moduleId = this.cleanUpModuleId(moduleId);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            EventManager eventManager = this.eventManagerTracker.getService();
            Module module = moduleManager.getModuleById(moduleId);
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            if (!(module instanceof InstantiableModule)) {
                throw new ModuleNotInstantiableException(moduleId);
            }
            InstantiableModule instantiableModule = (InstantiableModule)module;
            ModuleInstance moduleInstance = instantiableModule.getModuleInstanceById(moduleInstanceId);
            if (!userSession.hasUseModuleInstanceRight(moduleInstance)) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            if (!userSession.hasDeleteModuleInstancesRight(moduleInstance)) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
            if (coreModule.isBpcConfigurationIndexBackupOnChangesEnabled()) {
                coreModule.createBpcConfigurationSnapshot(userSession);
            }
            moduleInstance.deleteInstance();
            UserAuditLog.info(userSession, "ModuleInstanceDeleted", "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + moduleInstanceId + ") of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") deleted");
            instantiableModule.moduleInstanceDeleted(moduleInstance);
            eventManager.broadcast().moduleInstanceDeleted(moduleId, moduleInstanceId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Delete module instance failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/test/{moduleId}/{moduleInstanceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Module or module instance not found"), @ApiResponse(responseCode="406", description="Module cannot have module instances"), @ApiResponse(responseCode="500", description="Connection test failed"), @ApiResponse(responseCode="501", description="No suitable connection tester implementation exists")})
    @OperationDescription(summary="Performs a connection test on a specific module instance.", description="Performs a connection test on a specific module instance.\nAdditional data to perform can be provided in the POST body as JSON object.\n")
    @ReturnDescription(value="The error result as JSON, nothing when successful")
    public Response testModuleInstance(@Parameter(description="the ID of the related module") @PathParam(value="moduleId") String moduleId, @Parameter(description="the ID of the module instance to do the connection test for") @PathParam(value="moduleInstanceId") String moduleInstanceId, @Context UriInfo uriInfo, @Context UserSession userSession, @Context HttpHeaders hh, Map<String, Object> testData) {
        LOGGER.info("testModuleInstance moduleId={}, moduleInstanceId={}", (Object)moduleId, (Object)moduleInstanceId);
        try {
            moduleId = this.cleanUpModuleId(moduleId);
            testData.put("___uriInfo___", uriInfo);
            testData.put("___userSession___", userSession);
            testData.put("___httpHeaders___", hh);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Module module = moduleManager.getModuleById(moduleId);
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            if (!(module instanceof InstantiableModule)) {
                throw new ModuleNotInstantiableException(moduleId);
            }
            InstantiableModule instantiableModule = (InstantiableModule)module;
            ModuleInstance moduleInstance = instantiableModule.getModuleInstanceById(moduleInstanceId);
            if (!userSession.hasUseModuleInstanceRight(moduleInstance)) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            moduleManager.performConnectionTest(moduleInstance, testData);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Connection testing the module instance failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/jsonschema/{moduleId}/{setting}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* Module not found\n* Module configuration missing\n* Setting not found\n"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Setting without set JSON schema\n* JSON schema set but not found or invalid\n")})
    @OperationDescription(summary="Get the JSON schema to validate a JSON based module setting.", description="Get the JSON schema to validate a JSON based module setting.")
    @ReturnDescription(value="The requested data as JSON")
    public Response getJsonSchema(@Parameter(description="the ID of the module") @PathParam(value="moduleId") String moduleId, @Parameter(description="the name of the setting") @PathParam(value="setting") String settingName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getJsonSchema moduleId={}, settingName={}", (Object)moduleId, (Object)settingName);
        try {
            Module module = this.moduleManagerTracker.getService().getModuleById(moduleId);
            ModuleConfiguration defaultModuleConfiguration = module.getDefaultConfiguration();
            if (defaultModuleConfiguration == null) {
                throw new ModuleConfigurationNotFoundException("The module '${module}' does not have a default configuration.", MapUtil.mapOf("module", moduleId));
            }
            Setting setting = defaultModuleConfiguration.getSetting(settingName);
            if (setting == null) {
                throw new SettingNotFoundException(moduleId, settingName);
            }
            String jsonSchemaFile = setting.getCustomFields().getStringValue("_schema");
            if (StringUtil.isNullOrEmpty(jsonSchemaFile)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "The setting '${setting}' of module '${module} does not have a JSON schema.", MapUtil.mapOf("module", moduleId, "setting", settingName));
            }
            Map<String, Object> jsonSchema = JsonDefaultsUtil.loadJsonFileAsMap(module.getModuleBundle(), jsonSchemaFile);
            if (jsonSchema == null) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to load the JSON schema (${schema}) from setting '${setting} of module '${module}.", MapUtil.mapOf("module", moduleId, "setting", settingName, "schema", jsonSchemaFile));
            }
            return Response.ok(jsonSchema).build();
        }
        catch (Exception ex) {
            LOGGER.error("Getting the requested JSON schema failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/jsonschema/{moduleId}/{instanceType}/{setting}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* Module not found\n* Module is non instantiable\n* Module configuration missing\n* Setting not found\n"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Setting without set JSON schema\n* JSON schema set but not found or invalid\n")})
    @OperationDescription(summary="Get the JSON schema to validate a JSON based module instance setting.", description="Get the JSON schema to validate a JSON based module instance setting.")
    @ReturnDescription(value="The requested data as JSON")
    public Response getJsonSchema(@Parameter(description="the ID of the module") @PathParam(value="moduleId") String moduleId, @Parameter(description="the instance type. set to 'none' when the module does not support instance types") @PathParam(value="instanceType") String instanceType, @Parameter(description="the name of the setting") @PathParam(value="setting") String settingName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getJsonSchema moduleId={}, instanceType={}, settingName={}", (Object)moduleId, (Object)instanceType, (Object)settingName);
        try {
            Module module = this.moduleManagerTracker.getService().getModuleById(moduleId);
            if (!(module instanceof InstantiableModule)) {
                throw new ModuleNotFoundException(moduleId);
            }
            InstantiableModule instantiableModule = (InstantiableModule)module;
            ModuleConfiguration defaultModuleInstanceConfiguration = instantiableModule.getDefaultInstanceConfiguration(instanceType);
            if (defaultModuleInstanceConfiguration == null) {
                throw new ModuleConfigurationNotFoundException("The instantiable module '${module}' does not have a default instance configuration.", MapUtil.mapOf("module", moduleId, "instanceType", instanceType));
            }
            Setting setting = defaultModuleInstanceConfiguration.getSetting(settingName);
            if (setting == null) {
                throw new SettingNotFoundException(moduleId, settingName);
            }
            String jsonSchemaFile = setting.getCustomFields().getStringValue("_schema");
            if (StringUtil.isNullOrEmpty(jsonSchemaFile)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "The setting '${setting}' of module '${module} and the instance type '${instanceType}' does not have a JSON schema.", MapUtil.mapOf("module", moduleId, "instanceType", instanceType, "setting", settingName));
            }
            Map<String, Object> jsonSchema = JsonDefaultsUtil.loadJsonFileAsMap(instantiableModule.getModuleBundle(), jsonSchemaFile);
            if (jsonSchema == null) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to load the JSON schema (${schema}) from setting '${setting} of module '${module} and instance type '${instanceType}'.", MapUtil.mapOf("module", moduleId, "instanceType", instanceType, "setting", settingName, "schema", jsonSchemaFile));
            }
            return Response.ok(jsonSchema).build();
        }
        catch (Exception ex) {
            LOGGER.error("Getting the requested JSON schema failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private String cleanUpModuleId(String moduleId) {
        return moduleId;
    }

    private void deleteSetting(UserSession userSession, Module module, Setting setting) throws SettingException, ServiceNotFoundException {
        LOGGER.debug("deleteSetting");
        String settingName = setting.getName();
        String moduleId = module.getModuleId();
        module.getConfiguration().removeSetting(setting);
        EventManager eventManager = this.eventManagerTracker.getService();
        if (!(module instanceof ModuleInstance)) {
            UserAuditLog.info(userSession, "ModuleSettingDeleted", "Setting of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") deleted: " + settingName, (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(Collections.singletonList(setting)), null), null);
            eventManager.broadcast().moduleSettingDeleted(moduleId, settingName);
        } else {
            String parentModuleId = ((ModuleInstance)module).getParentModule().getModuleId();
            UserAuditLog.info(userSession, "ModuleInstanceSettingDeleted", "Setting of module instance '" + ConfigurationEndpoint.getModuleInstanceName((ModuleInstance)module) + "' (" + moduleId + ") and module '" + module.getModuleName() + "' (" + parentModuleId + ") deleted: " + settingName, (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(Collections.singletonList(setting)), null), null);
            eventManager.broadcast().moduleInstanceSettingDeleted(parentModuleId, moduleId, ((ModuleInstance)module).getInstanceType(), settingName);
        }
    }

    public static String getModuleInstanceName(ModuleInstance moduleInstance) {
        try {
            return ConfigurationEndpoint.getModuleInstanceName(moduleInstance.getConfiguration());
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getModuleInstanceName(ModuleConfiguration moduleInstanceConfiguration) {
        try {
            return String.valueOf(moduleInstanceConfiguration.getSetting("module_name").getValue());
        }
        catch (Exception ex) {
            return "";
        }
    }
}

