/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.db.DataSourceEntry;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginError;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.response.BpcStatus;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.db.DataSourceSettings;
import de.virtimo.bpc.core.exception.TimestampedException;
import de.virtimo.bpc.core.license.License;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.license.NoLicense;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.resource.response.ActiveSessions;
import de.virtimo.bpc.core.resource.response.BpcStatusUserImpl;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRuntimeStatsDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.util.ListUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Period;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.karaf.log.core.LogService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.XContentBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BpcStatusAdminImpl
extends BpcStatusUserImpl
implements BpcStatus {
    private static final Logger LOGGER = LogManager.getLogger(BpcStatusAdminImpl.class);
    private final ClientSessionManager clientSessionManager;
    private final ReplicationManager replicationManager;
    private final DatabaseManager databaseManager;
    private final OpenSearchService oss;
    private final OpenSearchBpcPluginManager openSearchBpcPluginManager;
    private final CoreModule coreModule;
    private final LogService karafLogService;
    private final ReplicationModule replicationModule;

    public BpcStatusAdminImpl(BundleContext bundleContext, ModuleManager moduleManager, CoreBundleConfiguration coreBundleConfiguration, LicenseService licenseService, ClientSessionManager clientSessionManager, ReplicationManager replicationManager, DatabaseManager databaseManager, OpenSearchService oss, OpenSearchBpcPluginManager openSearchBpcPluginManager, LogService karafLogService) {
        super(bundleContext, moduleManager, coreBundleConfiguration, licenseService);
        this.clientSessionManager = clientSessionManager;
        this.replicationManager = replicationManager;
        this.databaseManager = databaseManager;
        this.oss = oss;
        this.openSearchBpcPluginManager = openSearchBpcPluginManager;
        this.coreModule = (CoreModule)moduleManager.getModule("_core");
        this.karafLogService = karafLogService;
        this.replicationModule = (ReplicationModule)moduleManager.getModule("replication");
    }

    public ActiveSessions getActiveSessions() {
        return new ActiveSessions(this.clientSessionManager.getAllSessions());
    }

    public String getIdentityProviderClassName() {
        IdentityProvider identityProvider = this.coreModule.getIdentityProvider();
        return identityProvider == null ? "" : identityProvider.getClass().getName();
    }

    public String getIdentityManagerClassName() {
        return this.coreModule.getIdentityManager().getClass().getName();
    }

    public String getBpcStatus() {
        List<TimestampedException> lastOccurredExceptions = this.coreModule.getLastOccurredExceptions();
        return (lastOccurredExceptions == null || lastOccurredExceptions.isEmpty()) && this.getOpenSearchStatus().startsWith("Connected to ") ? "OK" : "PROBLEMS";
    }

    public List getCurrentBpcProblems() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<TimestampedException> lastOccurredExceptions = this.coreModule.getLastOccurredExceptions();
        if (lastOccurredExceptions != null) {
            for (TimestampedException tex : lastOccurredExceptions) {
                Throwable ex = tex.getCause();
                if (ex instanceof SystemException) {
                    Map<String, Object> entry = ((SystemException)ex).asErrorResponseMap();
                    entry.put("timestamp", BpcStatusAdminImpl.formattedDate(tex.getTimestamp()));
                    result.add(entry);
                    continue;
                }
                HashMap<String, String> errorMap = new HashMap<String, String>();
                errorMap.put("message", ex.getLocalizedMessage());
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("timestamp", BpcStatusAdminImpl.formattedDate(tex.getTimestamp()));
                entry.put("error", errorMap);
                result.add(entry);
            }
        }
        return result;
    }

    public Boolean isMaintenanceModeEnabled() {
        CoreModule coreModule = (CoreModule)this.moduleManager.getModule("_core");
        return coreModule.isMaintenanceModeEnabled();
    }

    public String getOpenSearchStatus() {
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            if (osClient == null) {
                return "No OpenSearch client. Verify the OpenSearch connection settings.";
            }
            return "Connected to " + osClient.getLowLevelClient().getNodes();
        }
        catch (OpenSearchException ex) {
            return ex.getMessage();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public String getOpenSearchVersion() {
        try {
            return this.oss.getOpenSearchVersion();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public List<Map<String, Object>> getInstalledOpenSearchPlugins() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            List<Map<String, Object>> plugins = this.oss.getInstalledPlugins();
            for (Map<String, Object> plugin : plugins) {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("node", plugin.get("name"));
                entry.put("plugin", plugin.get("component"));
                entry.put("version", plugin.get("version"));
                result.add(entry);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the installed OpenSearch plugins.", (Throwable)ex);
        }
        return result;
    }

    public List<Map<String, Object>> getReplicationJobs() {
        try {
            List<ReplicationJobRuntimeStatsDTO> replicationJobsWithRuntimeStatsFromAllServers = this.replicationModule.getReplicationJobsWithRuntimeStatsFromAllServers();
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            jsonBuilder.startArray();
            for (ReplicationJobRuntimeStatsDTO replicationJobRuntimeStats : replicationJobsWithRuntimeStatsFromAllServers) {
                replicationJobRuntimeStats.toXContent(jsonBuilder, null);
            }
            jsonBuilder.endArray();
            return JsonUtil.asListOfMaps((XContentBuilder)jsonBuilder);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the replication jobs from all servers.", (Throwable)ex);
            return null;
        }
    }

    public List<Map<String, Object>> getLogServices() {
        ArrayList<Map<String, Object>> infoList = new ArrayList<Map<String, Object>>();
        Module module = this.moduleManager.getModule("logservice");
        if (module != null) {
            LogServiceModule logServiceModule = (LogServiceModule)module;
            Map<String, ModuleInstance> moduleInstances = logServiceModule.getModuleInstances();
            for (ModuleInstance moduleInstance : moduleInstances.values()) {
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                HashMap<String, Object> openSearchInfoObj = new HashMap<String, Object>();
                openSearchInfoObj.put("enabled", logServiceModuleInstance.isOpenSearchLoggingEnabled());
                if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
                    openSearchInfoObj.put("settings", logServiceModuleInstance.getConfiguration().getSetting("openSearch").getValue());
                }
                HashMap<String, Object> databaseInfoObj = new HashMap<String, Object>();
                databaseInfoObj.put("enabled", logServiceModuleInstance.isDatabaseLoggingEnabled());
                if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
                    databaseInfoObj.put("settings", logServiceModuleInstance.getConfiguration().getSetting("rdms").getValue());
                }
                ArrayList lookupJoinsList = new ArrayList();
                if (logServiceModuleInstance.getLookupJoins().hasEntries()) {
                    for (LookupJoin lookupJoinEntry : logServiceModuleInstance.getLookupJoins().getEntries()) {
                        HashMap<String, Object> lookupJoinMap = new HashMap<String, Object>();
                        lookupJoinMap.put("key", lookupJoinEntry.getKeyField());
                        lookupJoinMap.put("keyValuesSeparator", lookupJoinEntry.getKeyFieldValuesSeparator());
                        lookupJoinMap.put("lookup", lookupJoinEntry.getLookupIndex() + "/" + lookupJoinEntry.getLookupKeyField());
                        lookupJoinsList.add(lookupJoinMap);
                    }
                }
                HashMap<String, Object> infoObj = new HashMap<String, Object>();
                infoObj.put("id", logServiceModuleInstance.getModuleId());
                infoObj.put("name", logServiceModuleInstance.getConfiguration().getSetting("module_name").getValue());
                infoObj.put("maintenanceEnabled", logServiceModuleInstance.isMaintenanceEnabled());
                infoObj.put("opensearch", openSearchInfoObj);
                infoObj.put("rdms", databaseInfoObj);
                infoObj.put("joins", lookupJoinsList);
                infoObj.put("lookupJoinsRefreshable", logServiceModuleInstance.getLookupJoins().hasEntries());
                infoList.add(infoObj);
            }
        }
        return infoList;
    }

    public Map<String, Object> getReplicationScheduler() {
        ScheduledExecutorService scheduler = this.replicationManager.getReplicationScheduler();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (scheduler != null) {
            result.put("isShutdown", scheduler.isShutdown());
            result.put("isTerminated", scheduler.isTerminated());
        }
        return result;
    }

    public Map<String, Object> getRdmsInfo() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("dataSourceFactoryNames", this.databaseManager.getAllDataSourceFactoryNames());
            List<DataSourceEntry> karafDataSourceEntries = this.databaseManager.getDataSourceEntries();
            result.put("dataSourceNames", karafDataSourceEntries.stream().map(DataSourceEntry::getDataSourceName).collect(Collectors.toList()));
            result.put("dataSourceConfigurations", this.getDataSourcesInDetail(karafDataSourceEntries));
        }
        catch (Exception e) {
            result.put("error", "Can't get RDMS information: " + e.getLocalizedMessage());
        }
        return result;
    }

    private List<Map<String, Object>> getDataSourcesInDetail(List<DataSourceEntry> karafDataSourceEntries) throws ModuleNotFoundException, DataSourceException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map<String, Map<String, Object>> dataSourcesFromBackendConnections = this.getDataSourcesFromBackendConnections();
        Map<String, Map<String, Object>> dataSourcesFromKaraf = this.getDataSourcesFromKaraf(karafDataSourceEntries);
        for (String dataSourceName : dataSourcesFromKaraf.keySet()) {
            Map<String, Object> configFromKaraf = dataSourcesFromKaraf.get(dataSourceName);
            configFromKaraf.put("registeredWithKaraf", true);
            result.add(configFromKaraf);
        }
        for (String dataSourceName : dataSourcesFromBackendConnections.keySet()) {
            if (dataSourcesFromKaraf.containsKey(dataSourceName)) continue;
            Map<String, Object> configFromBackendConnection = dataSourcesFromBackendConnections.get(dataSourceName);
            configFromBackendConnection.put("registeredWithKaraf", false);
            result.add(configFromBackendConnection);
        }
        return result;
    }

    private Map<String, Map<String, Object>> getDataSourcesFromBackendConnections() throws ModuleNotFoundException {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)this.moduleManager.getModuleById("backendconnection");
        for (ModuleInstance dataSourceInstance : backendConnectionsModule.getModuleInstancesByInstanceType("data_source")) {
            String dataSourceName = dataSourceInstance.getModuleId();
            Map<String, Setting> dataSourceSettings = dataSourceInstance.getConfiguration().getSettings();
            Map<String, Object> paxJdbcDataSourceConfig = DataSourceSettings.asPaxJdbcDataSourceConfiguration(dataSourceName, dataSourceSettings);
            Map<String, Object> securedMap = this.securedDataSourceConfig(paxJdbcDataSourceConfig);
            result.put(dataSourceName, securedMap);
        }
        return result;
    }

    private Map<String, Map<String, Object>> getDataSourcesFromKaraf(List<DataSourceEntry> karafDataSourceEntries) throws DataSourceException {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        List<Map> allDataSourceConfigurationProperties = this.databaseManager.getDataSourceConfigurationProperties(karafDataSourceEntries);
        for (Map dataSourceConfigurationProperties : allDataSourceConfigurationProperties) {
            String dataSourceName = (String)dataSourceConfigurationProperties.get("dataSourceName");
            Map<String, Object> securedMap = this.securedDataSourceConfig(dataSourceConfigurationProperties);
            result.put(dataSourceName, securedMap);
        }
        return result;
    }

    private Map<String, Object> securedDataSourceConfig(Map dataSourceConfigurationProperties) {
        HashMap<String, Object> securedMap = new HashMap<String, Object>(dataSourceConfigurationProperties);
        if (securedMap.containsKey("password")) {
            securedMap.put("password", "******");
        }
        return securedMap;
    }

    public String getIdentityProvider() {
        try {
            CoreModule coreModule = (CoreModule)this.moduleManager.getModule("_core");
            if (coreModule.isForceLocalIdentityProviderEnabled()) {
                return "forced.karaf";
            }
            IdentityProviderConfiguration idpConfiguration = coreModule.getCurrentIdentityProviderConfiguration();
            if (idpConfiguration != null) {
                return idpConfiguration.getIdentityProviderName();
            }
            return "karaf";
        }
        catch (Exception ex) {
            return "karaf";
        }
    }

    public String getJvmUptime() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            long uptimeMillis = runtime.getUptime();
            Date uptimeDate = new Date(System.currentTimeMillis() - uptimeMillis);
            return BpcStatusAdminImpl.formattedDate(uptimeDate);
        }
        catch (Exception ex) {
            return "???";
        }
    }

    public Map getOpenSearchBpcPluginStatus() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("plugin", (Object)this.openSearchBpcPluginManager.getPluginState());
        result.put("websocket", (Object)this.openSearchBpcPluginManager.getWebsocketState());
        ArrayList formattedErrors = new ArrayList();
        for (OpenSearchBpcPluginError error : ListUtil.reversed(this.openSearchBpcPluginManager.getErrors())) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("at", BpcStatusAdminImpl.formattedDate(error.getDateTime().toDate()));
            entry.put("message", error.getMessage());
            if (error.getException() != null) {
                entry.put("error", error.getException().getLocalizedMessage());
            }
            formattedErrors.add(entry);
        }
        result.put("lastErrors", formattedErrors);
        return result;
    }

    @Override
    protected Map<String, Object> getBundleMap(Bundle bundle) {
        String symbolicName;
        Map<String, Object> bundleMap = super.getBundleMap(bundle);
        String stateString = BpcBundleUtil.getBundleState(this.bundleContext, bundle);
        bundleMap.put("state", stateString);
        String bundleFilename = BpcBundleUtil.getBundleFilename(bundle);
        if (bundleFilename != null) {
            bundleMap.put("filename", bundleFilename);
        }
        if ((symbolicName = bundle.getSymbolicName()) != null) {
            bundleMap.put("symbolicName", symbolicName);
        }
        return bundleMap;
    }

    public Map<String, Object> getServers() {
        try {
            List connectedServers = this.openSearchBpcPluginManager.getConnectedServers().getServers();
            boolean useSameModules = true;
            if (connectedServers.size() > 1) {
                for (int i = 0; i <= connectedServers.size() - 2; ++i) {
                    LoadedModulesDTO loadedModules2;
                    ConnectedServerDTO cs1 = (ConnectedServerDTO)connectedServers.get(i);
                    ConnectedServerDTO cs2 = (ConnectedServerDTO)connectedServers.get(i + 1);
                    LoadedModulesDTO loadedModules1 = cs1 == null ? null : cs1.getLoadedModules();
                    LoadedModulesDTO loadedModulesDTO = loadedModules2 = cs2 == null ? null : cs2.getLoadedModules();
                    if (this.areEqual(loadedModules1, loadedModules2)) continue;
                    useSameModules = false;
                    break;
                }
            }
            HashMap<String, Object> servers = new HashMap<String, Object>();
            servers.put("connected", connectedServers);
            servers.put("useSameModules", useSameModules);
            return servers;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean areEqual(LoadedModulesDTO loadedModules1, LoadedModulesDTO loadedModules2) {
        if (loadedModules1 == null && loadedModules2 == null) {
            return true;
        }
        if (loadedModules1 == null || loadedModules2 == null) {
            return false;
        }
        if (loadedModules1.isEmpty() && loadedModules2.isEmpty()) {
            return true;
        }
        if (loadedModules1.size() != loadedModules2.size()) {
            return false;
        }
        return loadedModules1.equals((Object)loadedModules2);
    }

    public List<Map<String, Object>> getLoggers() {
        Map loggers = this.karafLogService.getLevel("ALL");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String logger : loggers.keySet()) {
            result.add(Map.of("name", logger, "level", loggers.get(logger)));
        }
        return result;
    }

    public Map getLicenseInfo() {
        License license;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.licenseService != null && (license = this.licenseService.getLicense()) != null) {
            if (license instanceof NoLicense) {
                result.put("expired", true);
            } else {
                result.put("expired", license.isExpired());
                result.put("expirationDate", BpcStatusAdminImpl.formattedDate(license.getExpirationDate()));
                if (!license.isExpired()) {
                    result.put("expiresInDays", license.getExpiresInDays());
                    Period expiresInPeriod = license.getExpiresInPeriod();
                    if (expiresInPeriod != null) {
                        HashMap<String, Integer> expiresInMap = new HashMap<String, Integer>();
                        expiresInMap.put("years", expiresInPeriod.getYears());
                        expiresInMap.put("months", expiresInPeriod.getMonths());
                        expiresInMap.put("days", expiresInPeriod.getDays());
                        result.put("expiresIn", expiresInMap);
                    }
                }
            }
        }
        return result;
    }

    public Map getLicenseDetails() {
        if (this.licenseService != null) {
            return this.licenseService.getLicenseDetails();
        }
        return null;
    }
}

