/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class BpcKeyStore {
    private static final Logger LOGGER = LogManager.getLogger(BpcKeyStore.class);
    private static BpcKeyStore INSTANCE = null;
    private static final Object KEYSTORE_LOCK = new Object();
    private KeyStore cachedKeyStore = null;
    private long cachedKeyStoreFileLastModified = -1L;

    private BpcKeyStore() {
    }

    public static BpcKeyStore getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BpcKeyStore();
        }
        return INSTANCE;
    }

    public static void destroySingleton() {
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore(BundleContext bundleContext) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        LOGGER.info("getKeyStore bundleContext={}", (Object)bundleContext);
        Object object = KEYSTORE_LOCK;
        synchronized (object) {
            PaxWebKeyStoreData paxWebKeyStoreData = this.getPaxWebKeyStoreData(bundleContext);
            File keyStoreFile = new File(paxWebKeyStoreData.getKeyStoreFilePath());
            long keyStoreFileLastModified = keyStoreFile.lastModified();
            if (this.cachedKeyStore == null || keyStoreFileLastModified != this.cachedKeyStoreFileLastModified) {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream is = new FileInputStream(keyStoreFile);){
                    keyStore.load(is, paxWebKeyStoreData.getKeyStorePassword());
                }
                this.cachedKeyStore = keyStore;
                this.cachedKeyStoreFileLastModified = keyStoreFileLastModified;
            }
            return this.cachedKeyStore;
        }
    }

    public KeyStore createWorkaroundKeyStore(BundleContext bundleContext, String privateKeyAlias, char[] privateKeyPassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = this.getKeyStore(bundleContext);
        Key key = keyStore.getKey(privateKeyAlias, privateKeyPassword);
        Certificate[] certificateChain = keyStore.getCertificateChain(privateKeyAlias);
        KeyStore workaroundKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
        workaroundKeystore.load(null);
        workaroundKeystore.setKeyEntry(privateKeyAlias, key, privateKeyPassword, certificateChain);
        return workaroundKeystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaxWebKeyStoreData getPaxWebKeyStoreData(BundleContext bundleContext) throws IOException {
        ServiceReference configurationAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        try {
            ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(configurationAdminServiceReference);
            Configuration paxWebConf = configurationAdmin.getConfiguration("org.ops4j.pax.web");
            Object keyStorePath = paxWebConf.getProcessedProperties(null).get("org.ops4j.pax.web.ssl.keystore");
            Object keyStorePassword = paxWebConf.getProcessedProperties(null).get("org.ops4j.pax.web.ssl.keystore.password");
            PaxWebKeyStoreData paxWebKeyStoreData = new PaxWebKeyStoreData((String)keyStorePath, (String)keyStorePassword);
            return paxWebKeyStoreData;
        }
        finally {
            if (configurationAdminServiceReference != null) {
                bundleContext.ungetService(configurationAdminServiceReference);
            }
        }
    }

    public static class PaxWebKeyStoreData {
        private final String keyStoreFilePath;
        private final char[] keyStorePassword;

        public PaxWebKeyStoreData(String keyStoreFilePath, String keyStorePassword) {
            this.keyStoreFilePath = keyStoreFilePath;
            this.keyStorePassword = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
        }

        public String getKeyStoreFilePath() {
            return this.keyStoreFilePath;
        }

        public char[] getKeyStorePassword() {
            return this.keyStorePassword;
        }
    }
}

