/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public final class BinaryRange
extends Field {
    public static final int BYTES = 16;
    private static final FieldType TYPE = new FieldType();

    public BinaryRange(String name, byte[] encodedRange) {
        super(name, TYPE);
        if (encodedRange.length != 32) {
            throw new IllegalArgumentException("Unexpected encoded range length [" + encodedRange.length + "]");
        }
        this.fieldsData = new BytesRef(encodedRange);
    }

    public static Query newIntersectsQuery(String field, byte[] encodedRange) {
        return BinaryRange.newRelationQuery(field, encodedRange, RangeFieldQuery.QueryType.INTERSECTS);
    }

    static Query newRelationQuery(String field, byte[] encodedRange, RangeFieldQuery.QueryType relation) {
        return new RangeFieldQuery(field, encodedRange, 1, relation){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return "[" + String.valueOf(new BytesRef(ranges, 0, 16)) + " TO " + String.valueOf(new BytesRef(ranges, 16, 16)) + "]";
            }
        };
    }

    static {
        TYPE.setDimensions(2, 16);
        TYPE.freeze();
    }
}

