/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.matchhighlight.MatchRegionRetriever;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategy;

public final class OffsetsFromPositions
implements OffsetsRetrievalStrategy {
    private final String field;
    private final Analyzer analyzer;

    public OffsetsFromPositions(String field, Analyzer analyzer) {
        this.field = field;
        this.analyzer = analyzer;
    }

    @Override
    public List<OffsetRange> get(MatchesIterator matchesIterator, MatchRegionRetriever.FieldValueProvider doc) throws IOException {
        ArrayList<OffsetRange> positionRanges = new ArrayList<OffsetRange>();
        while (matchesIterator.next()) {
            int from = matchesIterator.startPosition();
            int to = matchesIterator.endPosition();
            if (from < 0 || to < 0) {
                throw new IOException("Matches API returned negative positions for field: " + this.field);
            }
            positionRanges.add(new OffsetRange(from, to));
        }
        return this.convertPositionsToOffsets(positionRanges, doc.getValues(this.field));
    }

    List<OffsetRange> convertPositionsToOffsets(ArrayList<OffsetRange> positionRanges, List<CharSequence> values) throws IOException {
        if (positionRanges.isEmpty()) {
            return positionRanges;
        }
        class PositionSpan
        extends OffsetRange {
            int leftOffset;
            int rightOffset;

            PositionSpan(int from, int to) {
                super(from, to);
                this.leftOffset = Integer.MAX_VALUE;
                this.rightOffset = Integer.MIN_VALUE;
            }

            @Override
            public String toString() {
                return "[from=" + this.from + ", to=" + this.to + ", L: " + this.leftOffset + ", R: " + this.rightOffset + "]";
            }
        }
        ArrayList<PositionSpan> spans = new ArrayList<PositionSpan>();
        int minPosition = Integer.MAX_VALUE;
        int maxPosition = Integer.MIN_VALUE;
        for (OffsetRange range : positionRanges) {
            spans.add(new PositionSpan(range.from, range.to));
            minPosition = Math.min(minPosition, range.from);
            maxPosition = Math.max(maxPosition, range.to);
        }
        PositionSpan[] spansTable = (PositionSpan[])spans.toArray(x$0 -> new PositionSpan[x$0]);
        int spanCount = spansTable.length;
        int position = -1;
        int valueOffset = 0;
        int max = values.size();
        for (int valueIndex = 0; valueIndex < max; ++valueIndex) {
            String value = values.get(valueIndex).toString();
            boolean lastValue = valueIndex + 1 == max;
            TokenStream ts = this.analyzer.tokenStream(this.field, value);
            OffsetAttribute offsetAttr = ts.getAttribute(OffsetAttribute.class);
            PositionIncrementAttribute posAttr = ts.getAttribute(PositionIncrementAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                if ((position += posAttr.getPositionIncrement()) < minPosition) continue;
                int startOffset = valueOffset + offsetAttr.startOffset();
                int endOffset = valueOffset + offsetAttr.endOffset();
                int j = 0;
                for (int i = 0; i < spanCount; ++i) {
                    PositionSpan span = spansTable[j] = spansTable[i];
                    if (position >= span.from) {
                        if (position > span.to) continue;
                        span.leftOffset = Math.min(span.leftOffset, startOffset);
                        span.rightOffset = Math.max(span.rightOffset, endOffset);
                    }
                    ++j;
                }
                spanCount = j;
                if (position <= maxPosition || !lastValue) continue;
                break;
            }
            ts.end();
            position += posAttr.getPositionIncrement() + this.analyzer.getPositionIncrementGap(this.field);
            valueOffset += offsetAttr.endOffset() + this.analyzer.getOffsetGap(this.field);
            ts.close();
        }
        ArrayList<OffsetRange> converted = new ArrayList<OffsetRange>(spans.size());
        for (PositionSpan span : spans) {
            if (span.leftOffset == Integer.MAX_VALUE || span.rightOffset == Integer.MIN_VALUE) {
                throw new RuntimeException("One of the offsets missing for position range: " + span);
            }
            converted.add(new OffsetRange(span.leftOffset, span.rightOffset));
        }
        return converted;
    }
}

