/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.replication;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.opensearch.action.support.replication.ReplicationMode;
import org.opensearch.action.support.replication.ReplicationOperation;
import org.opensearch.action.support.replication.ReplicationProxyRequest;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.core.action.ActionListener;

public abstract class ReplicationProxy<ReplicaRequest extends ReplicationRequest<ReplicaRequest>> {
    protected final ReplicationOperation.Replicas<ReplicaRequest> fullReplicationProxy;

    public ReplicationProxy(ReplicationOperation.Replicas<ReplicaRequest> fullReplicationProxy) {
        this.fullReplicationProxy = fullReplicationProxy;
    }

    final void performOnReplicaProxy(ReplicationProxyRequest<ReplicaRequest> proxyRequest, BiConsumer<Consumer<ActionListener<ReplicationOperation.ReplicaResponse>>, ReplicationProxyRequest<ReplicaRequest>> performOnReplicaConsumer) {
        ReplicationMode replicationMode = this.determineReplicationMode(proxyRequest.getShardRouting(), proxyRequest.getPrimaryRouting());
        if (replicationMode == ReplicationMode.NO_REPLICATION) {
            return;
        }
        this.performOnReplicaProxy(proxyRequest, replicationMode, performOnReplicaConsumer);
    }

    protected abstract void performOnReplicaProxy(ReplicationProxyRequest<ReplicaRequest> var1, ReplicationMode var2, BiConsumer<Consumer<ActionListener<ReplicationOperation.ReplicaResponse>>, ReplicationProxyRequest<ReplicaRequest>> var3);

    abstract ReplicationMode determineReplicationMode(ShardRouting var1, ShardRouting var2);

    protected Consumer<ActionListener<ReplicationOperation.ReplicaResponse>> getReplicasProxyConsumer(ReplicationOperation.Replicas<ReplicaRequest> proxy, ReplicationProxyRequest<ReplicaRequest> proxyRequest) {
        return listener -> proxy.performOn(proxyRequest.getShardRouting(), (Object)((ReplicationRequest)proxyRequest.getReplicaRequest()), proxyRequest.getPrimaryTerm(), proxyRequest.getGlobalCheckpoint(), proxyRequest.getMaxSeqNoOfUpdatesOrDeletes(), (ActionListener<ReplicationOperation.ReplicaResponse>)listener);
    }
}

