/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.unit;

import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.monitor.jvm.JvmInfo;

public final class MemorySizeValue
extends Enum<MemorySizeValue> {
    private static final /* synthetic */ MemorySizeValue[] $VALUES;

    public static MemorySizeValue[] values() {
        return (MemorySizeValue[])$VALUES.clone();
    }

    public static MemorySizeValue valueOf(String name) {
        return Enum.valueOf(MemorySizeValue.class, name);
    }

    public static ByteSizeValue parseBytesSizeValueOrHeapRatio(String sValue, String settingName) {
        settingName = Objects.requireNonNull(settingName);
        if (sValue != null && sValue.endsWith("%")) {
            String percentAsString = sValue.substring(0, sValue.length() - 1);
            try {
                double percent = Double.parseDouble(percentAsString);
                if (percent < 0.0 || percent > 100.0) {
                    throw new OpenSearchParseException("percentage should be in [0-100], got [{}]", percentAsString);
                }
                return new ByteSizeValue((long)(percent / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes()), ByteSizeUnit.BYTES);
            }
            catch (NumberFormatException e) {
                throw new OpenSearchParseException("failed to parse [{}] as a double", (Throwable)e, percentAsString);
            }
        }
        return ByteSizeValue.parseBytesSizeValue(sValue, settingName);
    }

    private static /* synthetic */ MemorySizeValue[] $values() {
        return new MemorySizeValue[0];
    }

    static {
        $VALUES = MemorySizeValue.$values();
    }
}

