/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.MetricAggregatorInfo;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeDocumentBitSetUtil;
import org.opensearch.index.mapper.FieldValueConverter;
import org.opensearch.index.mapper.NumberFieldMapper;

@ExperimentalApi
public abstract class AbstractDocumentsFileManager
implements Closeable {
    private static final Logger logger = LogManager.getLogger(AbstractDocumentsFileManager.class);
    protected final StarTreeField starTreeField;
    protected final List<MetricAggregatorInfo> metricAggregatorInfos;
    protected final int numMetrics;
    protected final TrackingDirectoryWrapper tmpDirectory;
    protected final SegmentWriteState state;
    protected int docSizeInBytes = -1;
    protected final int numDimensions;

    public AbstractDocumentsFileManager(SegmentWriteState state, StarTreeField starTreeField, List<MetricAggregatorInfo> metricAggregatorInfos, int numDimensions) {
        this.starTreeField = starTreeField;
        this.tmpDirectory = new TrackingDirectoryWrapper(state.directory);
        this.metricAggregatorInfos = metricAggregatorInfos;
        this.state = state;
        this.numMetrics = metricAggregatorInfos.size();
        this.numDimensions = numDimensions;
    }

    private void setDocSizeInBytes(int numBytes) {
        if (this.docSizeInBytes == -1) {
            this.docSizeInBytes = numBytes;
        }
        assert (this.docSizeInBytes == numBytes);
    }

    protected int writeStarTreeDocument(StarTreeDocument starTreeDocument, IndexOutput output, boolean isAggregatedDoc) throws IOException {
        int numBytes = this.calculateDocumentSize(starTreeDocument, isAggregatedDoc);
        byte[] bytes = new byte[numBytes];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder());
        this.writeDimensions(starTreeDocument, buffer);
        if (!isAggregatedDoc) {
            this.writeFlushMetrics(starTreeDocument, buffer);
        } else {
            this.writeMetrics(starTreeDocument, buffer, isAggregatedDoc);
        }
        output.writeBytes(bytes, bytes.length);
        this.setDocSizeInBytes(numBytes);
        return bytes.length;
    }

    protected void writeDimensions(StarTreeDocument starTreeDocument, ByteBuffer buffer) throws IOException {
        for (Long dimension : starTreeDocument.dimensions) {
            buffer.putLong(dimension == null ? 0L : dimension);
        }
        StarTreeDocumentBitSetUtil.writeBitSet(starTreeDocument.dimensions, buffer);
    }

    protected void writeFlushMetrics(StarTreeDocument starTreeDocument, ByteBuffer buffer) throws IOException {
        for (int i = 0; i < starTreeDocument.metrics.length; ++i) {
            buffer.putLong(starTreeDocument.metrics[i] == null ? 0L : (Long)starTreeDocument.metrics[i]);
        }
        StarTreeDocumentBitSetUtil.writeBitSet(starTreeDocument.metrics, buffer);
    }

    protected void writeMetrics(StarTreeDocument starTreeDocument, ByteBuffer buffer, boolean isAggregatedDoc) throws IOException {
        for (int i = 0; i < starTreeDocument.metrics.length; ++i) {
            FieldValueConverter aggregatedValueType = this.metricAggregatorInfos.get(i).getValueAggregators().getAggregatedValueType();
            if (aggregatedValueType.equals(NumberFieldMapper.NumberType.LONG)) {
                buffer.putLong(starTreeDocument.metrics[i] == null ? 0L : (Long)starTreeDocument.metrics[i]);
                continue;
            }
            if (aggregatedValueType.equals(NumberFieldMapper.NumberType.DOUBLE)) {
                if (isAggregatedDoc) {
                    long val = NumericUtils.doubleToSortableLong(starTreeDocument.metrics[i] == null ? 0.0 : (Double)starTreeDocument.metrics[i]);
                    buffer.putLong(val);
                    continue;
                }
                buffer.putLong(starTreeDocument.metrics[i] == null ? 0L : (Long)starTreeDocument.metrics[i]);
                continue;
            }
            throw new IllegalStateException("Unsupported metric type");
        }
        StarTreeDocumentBitSetUtil.writeBitSet(starTreeDocument.metrics, buffer);
    }

    private int calculateDocumentSize(StarTreeDocument starTreeDocument, boolean isAggregatedDoc) {
        int size = starTreeDocument.dimensions.length * 8;
        size += AbstractDocumentsFileManager.getLength(starTreeDocument.dimensions);
        for (int i = 0; i < starTreeDocument.metrics.length; ++i) {
            size += 8;
        }
        return size += AbstractDocumentsFileManager.getLength(starTreeDocument.metrics);
    }

    private static int getLength(Object[] array) {
        return array.length / 8 + (array.length % 8 == 0 ? 0 : 1);
    }

    protected StarTreeDocument readStarTreeDocument(RandomAccessInput input, long offset, boolean isAggregatedDoc) throws IOException {
        Long[] dimensions = new Long[this.numDimensions];
        long initialOffset = offset;
        offset = this.readDimensions(dimensions, input, offset);
        Object[] metrics = new Object[this.numMetrics];
        offset = !isAggregatedDoc ? this.readMetrics(input, offset, metrics) : this.readMetrics(input, offset, this.numMetrics, metrics, isAggregatedDoc);
        assert (offset - initialOffset == (long)this.docSizeInBytes);
        return new StarTreeDocument(dimensions, metrics);
    }

    protected long readDimensions(Long[] dimensions, RandomAccessInput input, long offset) throws IOException {
        for (int i = 0; i < dimensions.length; ++i) {
            try {
                dimensions[i] = input.readLong(offset);
            }
            catch (Exception e) {
                logger.error("Error reading dimension value at offset {} for dimension {}", (Object)offset, (Object)i);
                throw e;
            }
            offset += 8L;
        }
        offset += (long)StarTreeDocumentBitSetUtil.readBitSet(input, offset, dimensions, index -> null);
        return offset;
    }

    private long readMetrics(RandomAccessInput input, long offset, Object[] metrics) throws IOException {
        Object[] fieldMetrics = new Object[this.starTreeField.getMetrics().size()];
        for (int i = 0; i < this.starTreeField.getMetrics().size(); ++i) {
            fieldMetrics[i] = input.readLong(offset);
            offset += 8L;
        }
        offset += (long)StarTreeDocumentBitSetUtil.readBitSet(input, offset, fieldMetrics, index -> null);
        int fieldIndex = 0;
        int numMetrics = 0;
        for (Metric metric : this.starTreeField.getMetrics()) {
            for (MetricStat stat : metric.getBaseMetrics()) {
                metrics[numMetrics] = fieldMetrics[fieldIndex];
                ++numMetrics;
            }
            ++fieldIndex;
        }
        return offset;
    }

    private long readMetrics(RandomAccessInput input, long offset, int numMetrics, Object[] metrics, boolean isAggregatedDoc) throws IOException {
        for (int i = 0; i < numMetrics; ++i) {
            FieldValueConverter aggregatedValueType = this.metricAggregatorInfos.get(i).getValueAggregators().getAggregatedValueType();
            if (aggregatedValueType.equals(NumberFieldMapper.NumberType.LONG)) {
                metrics[i] = input.readLong(offset);
                offset += 8L;
                continue;
            }
            if (aggregatedValueType.equals(NumberFieldMapper.NumberType.DOUBLE)) {
                long val = input.readLong(offset);
                metrics[i] = isAggregatedDoc ? (Number)NumberFieldMapper.NumberType.DOUBLE.toDoubleValue(val) : (Number)val;
                offset += 8L;
                continue;
            }
            throw new IllegalStateException("Unsupported metric type");
        }
        offset += (long)StarTreeDocumentBitSetUtil.readBitSet(input, offset, metrics, index -> null);
        return offset;
    }

    public abstract void writeStarTreeDocument(StarTreeDocument var1, boolean var2) throws IOException;

    public abstract StarTreeDocument readStarTreeDocument(int var1, boolean var2) throws IOException;

    public abstract Long[] readDimensions(int var1) throws IOException;

    public abstract Long getDimensionValue(int var1, int var2) throws IOException;

    public void deleteFiles(boolean success) throws IOException {
        if (success) {
            for (String file : this.tmpDirectory.getCreatedFiles()) {
                this.tmpDirectory.deleteFile(file);
            }
        } else {
            this.deleteFilesIgnoringException();
        }
    }

    private void deleteFilesIgnoringException() throws IOException {
        for (String file : this.tmpDirectory.getCreatedFiles()) {
            try {
                this.tmpDirectory.deleteFile(file);
            }
            catch (IOException iOException) {}
        }
    }
}

