/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.KeywordField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.common.Booleans;
import org.opensearch.common.TriFunction;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.network.InetAddresses;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.mapper.BooleanFieldMapper;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoPointFieldMapper;
import org.opensearch.index.mapper.IpFieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.TextFieldMapper;

public enum DerivedFieldSupportedTypes {
    BOOLEAN("boolean", (name, context, indexAnalyzers) -> {
        BooleanFieldMapper.Builder builder = new BooleanFieldMapper.Builder((String)name);
        return builder.build((Mapper.BuilderContext)context);
    }, name -> o -> {
        Boolean value;
        if (o instanceof Boolean) {
            value = (Boolean)o;
        } else {
            String textValue = o.toString();
            value = Booleans.parseBooleanStrict(textValue, false);
        }
        return new Field((String)name, value != false ? "T" : "F", (IndexableFieldType)BooleanFieldMapper.Defaults.FIELD_TYPE);
    }, formatter -> o -> o),
    DATE("date", (name, context, indexAnalyzers) -> {
        DateFieldMapper.Builder builder = new DateFieldMapper.Builder((String)name, DateFieldMapper.Resolution.MILLISECONDS, DateFieldMapper.getDefaultDateTimeFormatter(), false, Version.CURRENT);
        return builder.build((Mapper.BuilderContext)context);
    }, name -> o -> new LongPoint((String)name, (Long)o), formatter -> o -> formatter == null ? DateFieldMapper.getDefaultDateTimeFormatter().formatMillis((Long)o) : formatter.formatMillis((Long)o)),
    GEO_POINT("geo_point", (name, context, indexAnalyzers) -> {
        GeoPointFieldMapper.Builder builder = new GeoPointFieldMapper.Builder((String)name);
        return builder.build((Mapper.BuilderContext)context);
    }, name -> o -> {
        if (!(o instanceof Tuple) || !(((Tuple)o).v1() instanceof Double) && ((Tuple)o).v2() instanceof Double) {
            throw new ClassCastException("geo_point should be in format emit(double lat, double lon) for derived fields");
        }
        return new LatLonPoint((String)name, (Double)((Tuple)o).v1(), (Double)((Tuple)o).v2());
    }, formatter -> o -> new GeoPoint((Double)((Tuple)o).v1(), (Double)((Tuple)o).v2())),
    IP("ip", (name, context, indexAnalyzers) -> {
        IpFieldMapper.Builder builder = new IpFieldMapper.Builder((String)name, false, Version.CURRENT);
        return builder.build((Mapper.BuilderContext)context);
    }, name -> o -> {
        InetAddress address = o instanceof InetAddress ? (InetAddress)o : InetAddresses.forString(o.toString());
        return new InetAddressPoint((String)name, address);
    }, formatter -> o -> o),
    KEYWORD("keyword", (name, context, indexAnalyzers) -> {
        FieldType dummyFieldType = new FieldType();
        dummyFieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        KeywordFieldMapper.Builder keywordBuilder = new KeywordFieldMapper.Builder((String)name);
        KeywordFieldMapper.KeywordFieldType keywordFieldType = keywordBuilder.buildFieldType((Mapper.BuilderContext)context, dummyFieldType);
        keywordFieldType.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        return new KeywordFieldMapper((String)name, dummyFieldType, keywordFieldType, keywordBuilder.multiFieldsBuilder.build(keywordBuilder, (Mapper.BuilderContext)context), keywordBuilder.copyTo.build(), keywordBuilder);
    }, name -> o -> new KeywordField((String)name, (String)o, Field.Store.NO), formatter -> o -> o),
    TEXT("text", (name, context, indexAnalyzers) -> {
        FieldType dummyFieldType = new FieldType();
        dummyFieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        TextFieldMapper.Builder textBuilder = new TextFieldMapper.Builder((String)name, (IndexAnalyzers)indexAnalyzers);
        return textBuilder.build((Mapper.BuilderContext)context);
    }, name -> o -> new TextField((String)name, (String)o, Field.Store.NO), formatter -> o -> o),
    LONG("long", (name, context, indexAnalyzers) -> {
        NumberFieldMapper.Builder longBuilder = new NumberFieldMapper.Builder((String)name, NumberFieldMapper.NumberType.LONG, false, false);
        return longBuilder.build((Mapper.BuilderContext)context);
    }, name -> o -> new LongField((String)name, Long.parseLong(o.toString()), Field.Store.NO), formatter -> o -> o),
    DOUBLE("double", (name, context, indexAnalyzers) -> {
        NumberFieldMapper.Builder doubleBuilder = new NumberFieldMapper.Builder((String)name, NumberFieldMapper.NumberType.DOUBLE, false, false);
        return doubleBuilder.build((Mapper.BuilderContext)context);
    }, name -> o -> new DoubleField((String)name, Double.parseDouble(o.toString()), Field.Store.NO), formatter -> o -> o),
    FLOAT("float", (name, context, indexAnalyzers) -> {
        NumberFieldMapper.Builder floatBuilder = new NumberFieldMapper.Builder((String)name, NumberFieldMapper.NumberType.FLOAT, false, false);
        return floatBuilder.build((Mapper.BuilderContext)context);
    }, name -> o -> new FloatField((String)name, Float.parseFloat(o.toString()), Field.Store.NO), formatter -> o -> o),
    OBJECT("object", (name, context, indexAnalyzers) -> {
        KeywordFieldMapper.Builder keywordBuilder = new KeywordFieldMapper.Builder((String)name);
        KeywordFieldMapper.KeywordFieldType keywordFieldType = keywordBuilder.buildFieldType((Mapper.BuilderContext)context, new FieldType());
        return new KeywordFieldMapper((String)name, new FieldType(), keywordFieldType, keywordBuilder.multiFieldsBuilder.build(keywordBuilder, (Mapper.BuilderContext)context), keywordBuilder.copyTo.build(), keywordBuilder);
    }, name -> o -> {
        throw new OpenSearchException("Cannot create IndexableField to execute queries on object derived field", new Object[0]);
    }, formatter -> o -> o);

    final String name;
    private final TriFunction<String, Mapper.BuilderContext, IndexAnalyzers, FieldMapper> builder;
    private final Function<String, Function<Object, IndexableField>> indexableFieldBuilder;
    private final Function<DateFormatter, Function<Object, Object>> valueForDisplay;
    private static final Map<String, DerivedFieldSupportedTypes> enumMap;

    private DerivedFieldSupportedTypes(String name, TriFunction<String, Mapper.BuilderContext, IndexAnalyzers, FieldMapper> builder, Function<String, Function<Object, IndexableField>> indexableFieldBuilder, Function<DateFormatter, Function<Object, Object>> valueForDisplay) {
        this.name = name;
        this.builder = builder;
        this.indexableFieldBuilder = indexableFieldBuilder;
        this.valueForDisplay = valueForDisplay;
    }

    public String getName() {
        return this.name;
    }

    private FieldMapper getFieldMapper(String name, Mapper.BuilderContext context, IndexAnalyzers indexAnalyzers) {
        return this.builder.apply(name, context, indexAnalyzers);
    }

    private Function<Object, IndexableField> getIndexableFieldGenerator(String name) {
        return this.indexableFieldBuilder.apply(name);
    }

    private Function<Object, Object> getValueForDisplayGenerator(DateFormatter formatter) {
        return this.valueForDisplay.apply(formatter);
    }

    public static FieldMapper getFieldMapperFromType(String type, String name, Mapper.BuilderContext context, IndexAnalyzers indexAnalyzers) {
        if (!enumMap.containsKey(type)) {
            throw new IllegalArgumentException("Type [" + type + "] isn't supported in Derived field context.");
        }
        return enumMap.get(type).getFieldMapper(name, context, indexAnalyzers);
    }

    public static Function<Object, IndexableField> getIndexableFieldGeneratorType(String type, String name) {
        if (!enumMap.containsKey(type)) {
            throw new IllegalArgumentException("Type [" + type + "] isn't supported in Derived field context.");
        }
        return enumMap.get(type).getIndexableFieldGenerator(name);
    }

    public static Function<Object, Object> getValueForDisplayGenerator(String type, DateFormatter formatter) {
        if (!enumMap.containsKey(type)) {
            throw new IllegalArgumentException("Type [" + type + "] isn't supported in Derived field context.");
        }
        return enumMap.get(type).getValueForDisplayGenerator(formatter);
    }

    static {
        enumMap = Arrays.stream(DerivedFieldSupportedTypes.values()).collect(Collectors.toMap(DerivedFieldSupportedTypes::getName, enumValue -> enumValue));
    }
}

