/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.opensearch.Version;
import org.opensearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.TextFieldMapper;
import org.opensearch.index.mapper.TextParams;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.SourceFieldMatchQuery;
import org.opensearch.index.similarity.SimilarityProvider;

public class MatchOnlyTextFieldMapper
extends TextFieldMapper {
    public static final FieldType FIELD_TYPE = new FieldType();
    public static final String CONTENT_TYPE = "match_only_text";
    private final String indexOptions = FieldMapper.indexOptionToString(FIELD_TYPE.indexOptions());
    private final boolean norms = !FIELD_TYPE.omitNorms();
    public static final ParametrizedFieldMapper.TypeParser PARSER;

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected MatchOnlyTextFieldMapper(String simpleName, FieldType fieldType, MatchOnlyTextFieldType mappedFieldType, TextFieldMapper.PrefixFieldMapper prefixFieldMapper, TextFieldMapper.PhraseFieldMapper phraseFieldMapper, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, fieldType, mappedFieldType, prefixFieldMapper, phraseFieldMapper, multiFields, copyTo, builder);
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion, this.indexAnalyzers).init(this);
    }

    static {
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.setStoreTermVectors(false);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.freeze();
        PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers()));
    }

    public static class Builder
    extends TextFieldMapper.Builder {
        final ParametrizedFieldMapper.Parameter<String> indexOptions = Builder.indexOptions(m -> ((MatchOnlyTextFieldMapper)m).indexOptions);
        final ParametrizedFieldMapper.Parameter<Boolean> norms = Builder.norms(m -> ((MatchOnlyTextFieldMapper)m).norms);
        final ParametrizedFieldMapper.Parameter<Boolean> indexPhrases = ParametrizedFieldMapper.Parameter.boolParam("index_phrases", false, m -> {
            Objects.requireNonNull((MatchOnlyTextFieldType)m.mappedFieldType);
            return false;
        }, false).setValidator(v -> {
            if (v.booleanValue()) {
                throw new MapperParsingException("Index phrases cannot be enabled on for match_only_text field. Use text field instead");
            }
        });
        final ParametrizedFieldMapper.Parameter<TextFieldMapper.PrefixConfig> indexPrefixes = new ParametrizedFieldMapper.Parameter<TextFieldMapper.PrefixConfig>("index_prefixes", false, () -> null, TextFieldMapper::parsePrefixConfig, m -> Optional.ofNullable(((MatchOnlyTextFieldType)m.mappedFieldType).prefixFieldType).map(p -> new TextFieldMapper.PrefixConfig(p.minChars, p.maxChars)).orElse(null)).acceptsNull().setValidator(v -> {
            if (v != null) {
                throw new MapperParsingException("Index prefixes cannot be enabled on for match_only_text field. Use text field instead");
            }
        });

        private static ParametrizedFieldMapper.Parameter<String> indexOptions(Function<FieldMapper, String> initializer) {
            return ParametrizedFieldMapper.Parameter.restrictedStringParam("index_options", false, initializer, "docs");
        }

        private static ParametrizedFieldMapper.Parameter<Boolean> norms(Function<FieldMapper, Boolean> initializer) {
            return ParametrizedFieldMapper.Parameter.boolParam("norms", false, initializer, false).setMergeValidator((o, n) -> o == n || o != false && n == false).setValidator(v -> {
                if (v.booleanValue()) {
                    throw new MapperParsingException("Norms cannot be enabled on for match_only_text field");
                }
            });
        }

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            super(name, indexAnalyzers);
        }

        public Builder(String name, Version indexCreatedVersion, IndexAnalyzers indexAnalyzers) {
            super(name, indexCreatedVersion, indexAnalyzers);
        }

        @Override
        public MatchOnlyTextFieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldType = TextParams.buildFieldType(this.index, this.store, this.indexOptions, this.norms, this.termVectors);
            MatchOnlyTextFieldType tft = this.buildFieldType(fieldType, context);
            return new MatchOnlyTextFieldMapper(this.name, fieldType, tft, this.buildPrefixMapper(context, fieldType, tft), this.buildPhraseMapper(fieldType, tft), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }

        @Override
        protected MatchOnlyTextFieldType buildFieldType(FieldType fieldType, Mapper.BuilderContext context) {
            NamedAnalyzer indexAnalyzer = this.analyzers.getIndexAnalyzer();
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.analyzers.getSearchQuoteAnalyzer();
            if (fieldType.indexOptions().compareTo(IndexOptions.DOCS) > 0) {
                throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
            }
            if ((Integer)this.positionIncrementGap.get() != -1) {
                if (fieldType.indexOptions().compareTo(IndexOptions.DOCS) < 0) {
                    throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without indexing enabled");
                }
                indexAnalyzer = new NamedAnalyzer(indexAnalyzer, (Integer)this.positionIncrementGap.get());
                searchAnalyzer = new NamedAnalyzer(searchAnalyzer, (Integer)this.positionIncrementGap.get());
                searchQuoteAnalyzer = new NamedAnalyzer(searchQuoteAnalyzer, (Integer)this.positionIncrementGap.get());
            }
            TextSearchInfo tsi = new TextSearchInfo(fieldType, (SimilarityProvider)this.similarity.getValue(), searchAnalyzer, searchQuoteAnalyzer);
            MatchOnlyTextFieldType ft = new MatchOnlyTextFieldType(this.buildFullName(context), (Boolean)this.index.getValue(), fieldType.stored(), tsi, (Map)this.meta.getValue());
            ft.setIndexAnalyzer(indexAnalyzer);
            ft.setEagerGlobalOrdinals((Boolean)this.eagerGlobalOrdinals.getValue());
            ft.setBoost(((Float)this.boost.getValue()).floatValue());
            if (((Boolean)this.fieldData.getValue()).booleanValue()) {
                ft.setFielddata(true, (TextFieldMapper.FielddataFrequencyFilter)this.freqFilter.getValue());
            }
            return ft;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.store, this.indexOptions, this.norms, this.termVectors, this.analyzers.indexAnalyzer, this.analyzers.searchAnalyzer, this.analyzers.searchQuoteAnalyzer, this.similarity, this.positionIncrementGap, this.fieldData, this.freqFilter, this.eagerGlobalOrdinals, this.indexPhrases, this.indexPrefixes, this.boost, this.meta);
        }
    }

    public static final class MatchOnlyTextFieldType
    extends TextFieldMapper.TextFieldType {
        private final boolean indexPhrases = false;
        private TextFieldMapper.PrefixFieldType prefixFieldType;

        @Override
        public String typeName() {
            return MatchOnlyTextFieldMapper.CONTENT_TYPE;
        }

        public MatchOnlyTextFieldType(String name, boolean indexed, boolean stored, TextSearchInfo tsi, Map<String, String> meta) {
            super(name, indexed, stored, tsi, meta);
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, QueryShardContext context) throws IOException {
            PhraseQuery phraseQuery = (PhraseQuery)super.phraseQuery(stream, slop, enablePosIncrements);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Term term : phraseQuery.getTerms()) {
                builder.add(new TermQuery(term), BooleanClause.Occur.FILTER);
            }
            return new SourceFieldMatchQuery(builder.build(), phraseQuery, this, context);
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, QueryShardContext context) throws IOException {
            MultiPhraseQuery multiPhraseQuery = (MultiPhraseQuery)super.multiPhraseQuery(stream, slop, enablePositionIncrements);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Term[] terms : multiPhraseQuery.getTermArrays()) {
                if (terms.length > 1) {
                    BooleanQuery.Builder disjunctions = new BooleanQuery.Builder();
                    for (Term term : terms) {
                        disjunctions.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
                    }
                    builder.add(disjunctions.build(), BooleanClause.Occur.FILTER);
                    continue;
                }
                builder.add(new TermQuery(terms[0]), BooleanClause.Occur.FILTER);
            }
            return new SourceFieldMatchQuery(builder.build(), multiPhraseQuery, this, context);
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, QueryShardContext context) throws IOException {
            Query phrasePrefixQuery = super.phrasePrefixQuery(stream, slop, maxExpansions);
            List<List<Term>> termArray = this.getTermsFromTokenStream(stream);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (int i = 0; i < termArray.size(); ++i) {
                if (i == termArray.size() - 1) {
                    MultiPhrasePrefixQuery mqb = new MultiPhrasePrefixQuery(this.name());
                    mqb.add(termArray.get(i).toArray(new Term[0]));
                    builder.add(mqb, BooleanClause.Occur.FILTER);
                    continue;
                }
                if (termArray.get(i).size() > 1) {
                    BooleanQuery.Builder disjunctions = new BooleanQuery.Builder();
                    for (Term term : termArray.get(i)) {
                        disjunctions.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
                    }
                    builder.add(disjunctions.build(), BooleanClause.Occur.FILTER);
                    continue;
                }
                builder.add(new TermQuery(termArray.get(i).get(0)), BooleanClause.Occur.FILTER);
            }
            return new SourceFieldMatchQuery(builder.build(), phrasePrefixQuery, this, context);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return new ConstantScoreQuery(super.termQuery(value, context));
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
            return new ConstantScoreQuery(super.termQueryCaseInsensitive(value, context));
        }

        private List<List<Term>> getTermsFromTokenStream(TokenStream stream) throws IOException {
            ArrayList<List<Term>> termArray = new ArrayList<List<Term>>();
            TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
            ArrayList<Term> currentTerms = new ArrayList<Term>();
            stream.reset();
            while (stream.incrementToken()) {
                if (posIncrAtt.getPositionIncrement() != 0) {
                    if (!currentTerms.isEmpty()) {
                        termArray.add(List.copyOf(currentTerms));
                    }
                    currentTerms.clear();
                }
                currentTerms.add(new Term(this.name(), termAtt.getBytesRef()));
            }
            termArray.add(List.copyOf(currentTerms));
            return termArray;
        }
    }
}

