/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.util.MovingAverage;
import org.opensearch.common.util.Streak;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.remote.RemoteTransferTracker;
import org.opensearch.index.shard.RemoteStoreRefreshListener;
import org.opensearch.index.store.DirectoryFileTransferTracker;

@PublicApi(since="2.10.0")
public class RemoteSegmentTransferTracker
extends RemoteTransferTracker {
    private final Logger logger;
    private volatile long localRefreshSeqNo;
    private volatile long localRefreshTimeMs;
    private volatile long localRefreshClockTimeMs;
    private volatile long remoteRefreshSeqNo;
    private volatile long remoteRefreshTimeMs;
    private volatile long remoteRefreshStartTimeMs = -1L;
    private volatile long remoteRefreshClockTimeMs;
    private volatile long refreshSeqNoLag;
    private volatile long lastSuccessfulRemoteRefreshBytes;
    private final AtomicLong rejectionCount = new AtomicLong();
    private final Map<String, AtomicLong> rejectionCountMap = ConcurrentCollections.newConcurrentMap();
    private final Map<String, Long> latestLocalFileNameLengthMap = ConcurrentCollections.newConcurrentMap();
    private final Set<String> latestUploadedFiles = ConcurrentCollections.newConcurrentSet();
    private volatile long bytesLag;
    private final Streak failures = new Streak();
    private final DirectoryFileTransferTracker directoryFileTransferTracker;

    public RemoteSegmentTransferTracker(ShardId shardId, DirectoryFileTransferTracker directoryFileTransferTracker, int movingAverageWindowSize) {
        super(shardId, movingAverageWindowSize);
        long currentTimeMs;
        this.logger = Loggers.getLogger(this.getClass(), shardId, new String[0]);
        long currentClockTimeMs = System.currentTimeMillis();
        this.localRefreshTimeMs = currentTimeMs = RemoteSegmentTransferTracker.currentTimeMsUsingSystemNanos();
        this.remoteRefreshTimeMs = currentTimeMs;
        this.remoteRefreshStartTimeMs = currentTimeMs;
        this.localRefreshClockTimeMs = currentClockTimeMs;
        this.remoteRefreshClockTimeMs = currentClockTimeMs;
        this.directoryFileTransferTracker = directoryFileTransferTracker;
    }

    public static long currentTimeMsUsingSystemNanos() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    @Override
    public void incrementTotalUploadsFailed() {
        super.incrementTotalUploadsFailed();
        this.failures.record(true);
    }

    @Override
    public void incrementTotalUploadsSucceeded() {
        super.incrementTotalUploadsSucceeded();
        this.failures.record(false);
    }

    public long getLocalRefreshSeqNo() {
        return this.localRefreshSeqNo;
    }

    void updateLocalRefreshSeqNo(long localRefreshSeqNo) {
        assert (localRefreshSeqNo >= this.localRefreshSeqNo) : "newLocalRefreshSeqNo=" + localRefreshSeqNo + " < currentLocalRefreshSeqNo=" + this.localRefreshSeqNo;
        this.localRefreshSeqNo = localRefreshSeqNo;
        this.computeRefreshSeqNoLag();
    }

    public long getLocalRefreshTimeMs() {
        return this.localRefreshTimeMs;
    }

    public long getLocalRefreshClockTimeMs() {
        return this.localRefreshClockTimeMs;
    }

    public void updateLocalRefreshTimeAndSeqNo() {
        this.updateLocalRefreshClockTimeMs(System.currentTimeMillis());
        this.updateLocalRefreshTimeMs(RemoteSegmentTransferTracker.currentTimeMsUsingSystemNanos());
        this.updateLocalRefreshSeqNo(this.getLocalRefreshSeqNo() + 1L);
    }

    synchronized void updateLocalRefreshTimeMs(long localRefreshTimeMs) {
        assert (localRefreshTimeMs >= this.localRefreshTimeMs) : "newLocalRefreshTimeMs=" + localRefreshTimeMs + " < currentLocalRefreshTimeMs=" + this.localRefreshTimeMs;
        boolean isRemoteInSyncBeforeLocalRefresh = this.localRefreshTimeMs == this.remoteRefreshTimeMs;
        this.localRefreshTimeMs = localRefreshTimeMs;
        if (isRemoteInSyncBeforeLocalRefresh) {
            this.remoteRefreshStartTimeMs = localRefreshTimeMs;
        }
    }

    private void updateLocalRefreshClockTimeMs(long localRefreshClockTimeMs) {
        this.localRefreshClockTimeMs = localRefreshClockTimeMs;
    }

    long getRemoteRefreshSeqNo() {
        return this.remoteRefreshSeqNo;
    }

    public void updateRemoteRefreshSeqNo(long remoteRefreshSeqNo) {
        assert (remoteRefreshSeqNo >= this.remoteRefreshSeqNo) : "newRemoteRefreshSeqNo=" + remoteRefreshSeqNo + " < currentRemoteRefreshSeqNo=" + this.remoteRefreshSeqNo;
        this.remoteRefreshSeqNo = remoteRefreshSeqNo;
        this.computeRefreshSeqNoLag();
    }

    long getRemoteRefreshTimeMs() {
        return this.remoteRefreshTimeMs;
    }

    long getRemoteRefreshClockTimeMs() {
        return this.remoteRefreshClockTimeMs;
    }

    public synchronized void updateRemoteRefreshTimeMs(long refreshTimeMs) {
        assert (refreshTimeMs >= this.remoteRefreshTimeMs) : "newRemoteRefreshTimeMs=" + refreshTimeMs + " < currentRemoteRefreshTimeMs=" + this.remoteRefreshTimeMs;
        this.remoteRefreshTimeMs = refreshTimeMs;
        this.remoteRefreshStartTimeMs = refreshTimeMs == this.localRefreshTimeMs ? -1L : this.localRefreshTimeMs;
    }

    public void updateRemoteRefreshClockTimeMs(long remoteRefreshClockTimeMs) {
        this.remoteRefreshClockTimeMs = remoteRefreshClockTimeMs;
    }

    private void computeRefreshSeqNoLag() {
        this.refreshSeqNoLag = this.localRefreshSeqNo - this.remoteRefreshSeqNo;
    }

    public long getRefreshSeqNoLag() {
        return this.refreshSeqNoLag;
    }

    public long getTimeMsLag() {
        if (this.remoteRefreshTimeMs == this.localRefreshTimeMs || this.bytesLag == 0L) {
            return 0L;
        }
        return RemoteSegmentTransferTracker.currentTimeMsUsingSystemNanos() - this.remoteRefreshStartTimeMs;
    }

    public long getBytesLag() {
        return this.bytesLag;
    }

    public long getInflightUploadBytes() {
        return this.uploadBytesStarted.get() - this.uploadBytesFailed.get() - this.uploadBytesSucceeded.get();
    }

    public long getInflightUploads() {
        return this.totalUploadsStarted.get() - this.totalUploadsFailed.get() - this.totalUploadsSucceeded.get();
    }

    public long getRejectionCount() {
        return this.rejectionCount.get();
    }

    public void incrementRejectionCount() {
        this.rejectionCount.incrementAndGet();
    }

    void incrementRejectionCount(String rejectionReason) {
        this.rejectionCountMap.computeIfAbsent(rejectionReason, k -> new AtomicLong()).incrementAndGet();
        this.incrementRejectionCount();
    }

    long getRejectionCount(String rejectionReason) {
        return this.rejectionCountMap.get(rejectionReason).get();
    }

    public Map<String, Long> getLatestLocalFileNameLengthMap() {
        return Collections.unmodifiableMap(this.latestLocalFileNameLengthMap);
    }

    public Map<String, Long> updateLatestLocalFileNameLengthMap(Collection<String> segmentFiles, CheckedFunction<String, Long, IOException> fileSizeFunction) {
        this.logger.debug("segmentFilesPostRefresh={} latestLocalFileNamesBeforeMapUpdate={}", segmentFiles, this.latestLocalFileNameLengthMap.keySet());
        segmentFiles.stream().filter(file -> !RemoteStoreRefreshListener.EXCLUDE_FILES.contains(file)).filter(file -> !this.latestLocalFileNameLengthMap.containsKey(file) || this.latestLocalFileNameLengthMap.get(file) == 0L).forEach(file -> {
            long fileSize = 0L;
            try {
                fileSize = (Long)fileSizeFunction.apply((String)file);
            }
            catch (IOException e) {
                this.logger.warn((Message)new ParameterizedMessage("Exception while reading the fileLength of file={}", file), (Throwable)e);
            }
            this.latestLocalFileNameLengthMap.put((String)file, fileSize);
        });
        HashSet<String> fileSet = new HashSet<String>(segmentFiles);
        this.latestLocalFileNameLengthMap.entrySet().removeIf(entry -> !fileSet.contains(entry.getKey()));
        this.computeBytesLag();
        return Collections.unmodifiableMap(this.latestLocalFileNameLengthMap);
    }

    public void addToLatestUploadedFiles(String file) {
        this.latestUploadedFiles.add(file);
        this.computeBytesLag();
    }

    public void setLatestUploadedFiles(Set<String> files) {
        this.latestUploadedFiles.clear();
        this.latestUploadedFiles.addAll(files);
        this.computeBytesLag();
    }

    private void computeBytesLag() {
        if (this.latestLocalFileNameLengthMap.isEmpty()) {
            return;
        }
        Set filesNotYetUploaded = this.latestLocalFileNameLengthMap.keySet().stream().filter(f -> !this.latestUploadedFiles.contains(f)).collect(Collectors.toSet());
        this.bytesLag = filesNotYetUploaded.stream().map(this.latestLocalFileNameLengthMap::get).mapToLong(Long::longValue).sum();
    }

    int getConsecutiveFailureCount() {
        return this.failures.length();
    }

    public DirectoryFileTransferTracker getDirectoryFileTransferTracker() {
        return this.directoryFileTransferTracker;
    }

    public Stats stats() {
        return new Stats(this.shardId, this.localRefreshClockTimeMs, this.remoteRefreshClockTimeMs, this.getTimeMsLag(), this.localRefreshSeqNo, this.remoteRefreshSeqNo, this.uploadBytesStarted.get(), this.uploadBytesSucceeded.get(), this.uploadBytesFailed.get(), this.totalUploadsStarted.get(), this.totalUploadsSucceeded.get(), this.totalUploadsFailed.get(), this.rejectionCount.get(), this.failures.length(), this.lastSuccessfulRemoteRefreshBytes, ((MovingAverage)this.uploadBytesMovingAverageReference.get()).getAverage(), ((MovingAverage)this.uploadBytesPerSecMovingAverageReference.get()).getAverage(), ((MovingAverage)this.uploadTimeMsMovingAverageReference.get()).getAverage(), this.getBytesLag(), this.totalUploadTimeInMillis.get(), this.directoryFileTransferTracker.stats());
    }

    @PublicApi(since="2.10.0")
    public static class Stats
    implements Writeable {
        public final ShardId shardId;
        public final long localRefreshClockTimeMs;
        public final long remoteRefreshClockTimeMs;
        public final long refreshTimeLagMs;
        public final long localRefreshNumber;
        public final long remoteRefreshNumber;
        public final long uploadBytesStarted;
        public final long uploadBytesFailed;
        public final long uploadBytesSucceeded;
        public final long totalUploadsStarted;
        public final long totalUploadsFailed;
        public final long totalUploadsSucceeded;
        public final long rejectionCount;
        public final long consecutiveFailuresCount;
        public final long lastSuccessfulRemoteRefreshBytes;
        public final double uploadBytesMovingAverage;
        public final double uploadBytesPerSecMovingAverage;
        public final long totalUploadTimeInMs;
        public final double uploadTimeMovingAverage;
        public final long bytesLag;
        public final DirectoryFileTransferTracker.Stats directoryFileTransferTrackerStats;

        public Stats(ShardId shardId, long localRefreshClockTimeMs, long remoteRefreshClockTimeMs, long refreshTimeLagMs, long localRefreshNumber, long remoteRefreshNumber, long uploadBytesStarted, long uploadBytesSucceeded, long uploadBytesFailed, long totalUploadsStarted, long totalUploadsSucceeded, long totalUploadsFailed, long rejectionCount, long consecutiveFailuresCount, long lastSuccessfulRemoteRefreshBytes, double uploadBytesMovingAverage, double uploadBytesPerSecMovingAverage, double uploadTimeMovingAverage, long bytesLag, long totalUploadTimeInMs, DirectoryFileTransferTracker.Stats directoryFileTransferTrackerStats) {
            this.shardId = shardId;
            this.localRefreshClockTimeMs = localRefreshClockTimeMs;
            this.remoteRefreshClockTimeMs = remoteRefreshClockTimeMs;
            this.refreshTimeLagMs = refreshTimeLagMs;
            this.localRefreshNumber = localRefreshNumber;
            this.remoteRefreshNumber = remoteRefreshNumber;
            this.uploadBytesStarted = uploadBytesStarted;
            this.uploadBytesFailed = uploadBytesFailed;
            this.uploadBytesSucceeded = uploadBytesSucceeded;
            this.totalUploadsStarted = totalUploadsStarted;
            this.totalUploadsFailed = totalUploadsFailed;
            this.totalUploadsSucceeded = totalUploadsSucceeded;
            this.rejectionCount = rejectionCount;
            this.consecutiveFailuresCount = consecutiveFailuresCount;
            this.lastSuccessfulRemoteRefreshBytes = lastSuccessfulRemoteRefreshBytes;
            this.uploadBytesMovingAverage = uploadBytesMovingAverage;
            this.uploadBytesPerSecMovingAverage = uploadBytesPerSecMovingAverage;
            this.uploadTimeMovingAverage = uploadTimeMovingAverage;
            this.bytesLag = bytesLag;
            this.totalUploadTimeInMs = totalUploadTimeInMs;
            this.directoryFileTransferTrackerStats = directoryFileTransferTrackerStats;
        }

        public Stats(StreamInput in) throws IOException {
            this.shardId = new ShardId(in);
            this.localRefreshClockTimeMs = in.readLong();
            this.remoteRefreshClockTimeMs = in.readLong();
            this.refreshTimeLagMs = in.readLong();
            this.localRefreshNumber = in.readLong();
            this.remoteRefreshNumber = in.readLong();
            this.uploadBytesStarted = in.readLong();
            this.uploadBytesFailed = in.readLong();
            this.uploadBytesSucceeded = in.readLong();
            this.totalUploadsStarted = in.readLong();
            this.totalUploadsFailed = in.readLong();
            this.totalUploadsSucceeded = in.readLong();
            this.rejectionCount = in.readLong();
            this.consecutiveFailuresCount = in.readLong();
            this.lastSuccessfulRemoteRefreshBytes = in.readLong();
            this.uploadBytesMovingAverage = in.readDouble();
            this.uploadBytesPerSecMovingAverage = in.readDouble();
            this.uploadTimeMovingAverage = in.readDouble();
            this.bytesLag = in.readLong();
            this.totalUploadTimeInMs = in.readLong();
            this.directoryFileTransferTrackerStats = in.readOptionalWriteable(DirectoryFileTransferTracker.Stats::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.shardId.writeTo(out);
            out.writeLong(this.localRefreshClockTimeMs);
            out.writeLong(this.remoteRefreshClockTimeMs);
            out.writeLong(this.refreshTimeLagMs);
            out.writeLong(this.localRefreshNumber);
            out.writeLong(this.remoteRefreshNumber);
            out.writeLong(this.uploadBytesStarted);
            out.writeLong(this.uploadBytesFailed);
            out.writeLong(this.uploadBytesSucceeded);
            out.writeLong(this.totalUploadsStarted);
            out.writeLong(this.totalUploadsFailed);
            out.writeLong(this.totalUploadsSucceeded);
            out.writeLong(this.rejectionCount);
            out.writeLong(this.consecutiveFailuresCount);
            out.writeLong(this.lastSuccessfulRemoteRefreshBytes);
            out.writeDouble(this.uploadBytesMovingAverage);
            out.writeDouble(this.uploadBytesPerSecMovingAverage);
            out.writeDouble(this.uploadTimeMovingAverage);
            out.writeLong(this.bytesLag);
            out.writeLong(this.totalUploadTimeInMs);
            out.writeOptionalWriteable(this.directoryFileTransferTrackerStats);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Stats other = (Stats)obj;
            return this.shardId.toString().equals(other.shardId.toString()) && this.localRefreshClockTimeMs == other.localRefreshClockTimeMs && this.remoteRefreshClockTimeMs == other.remoteRefreshClockTimeMs && this.refreshTimeLagMs == other.refreshTimeLagMs && this.localRefreshNumber == other.localRefreshNumber && this.remoteRefreshNumber == other.remoteRefreshNumber && this.uploadBytesStarted == other.uploadBytesStarted && this.uploadBytesFailed == other.uploadBytesFailed && this.uploadBytesSucceeded == other.uploadBytesSucceeded && this.totalUploadsStarted == other.totalUploadsStarted && this.totalUploadsFailed == other.totalUploadsFailed && this.totalUploadsSucceeded == other.totalUploadsSucceeded && this.rejectionCount == other.rejectionCount && this.consecutiveFailuresCount == other.consecutiveFailuresCount && this.lastSuccessfulRemoteRefreshBytes == other.lastSuccessfulRemoteRefreshBytes && Double.compare(this.uploadBytesMovingAverage, other.uploadBytesMovingAverage) == 0 && Double.compare(this.uploadBytesPerSecMovingAverage, other.uploadBytesPerSecMovingAverage) == 0 && Double.compare(this.uploadTimeMovingAverage, other.uploadTimeMovingAverage) == 0 && this.bytesLag == other.bytesLag && this.totalUploadTimeInMs == other.totalUploadTimeInMs && this.directoryFileTransferTrackerStats.equals(other.directoryFileTransferTrackerStats);
        }

        public int hashCode() {
            return Objects.hash(this.shardId, this.localRefreshClockTimeMs, this.remoteRefreshClockTimeMs, this.refreshTimeLagMs, this.localRefreshNumber, this.remoteRefreshNumber, this.uploadBytesStarted, this.uploadBytesFailed, this.uploadBytesSucceeded, this.totalUploadsStarted, this.totalUploadsFailed, this.totalUploadsSucceeded, this.rejectionCount, this.consecutiveFailuresCount, this.lastSuccessfulRemoteRefreshBytes, this.uploadBytesMovingAverage, this.uploadBytesPerSecMovingAverage, this.uploadTimeMovingAverage, this.bytesLag, this.totalUploadTimeInMs, this.directoryFileTransferTrackerStats);
        }
    }
}

