/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.io.Channels;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.OutputStreamStreamOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.translog.BufferedChecksumStreamInput;
import org.opensearch.index.translog.BufferedChecksumStreamOutput;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogCorruptedException;

public final class TranslogHeader {
    public static final String TRANSLOG_CODEC = "translog";
    public static final int VERSION_CHECKSUMS = 1;
    public static final int VERSION_CHECKPOINTS = 2;
    public static final int VERSION_PRIMARY_TERM = 3;
    public static final int CURRENT_VERSION = 3;
    private final String translogUUID;
    private final long primaryTerm;
    private final int headerSizeInBytes;

    TranslogHeader(String translogUUID, long primaryTerm) {
        this(translogUUID, primaryTerm, TranslogHeader.headerSizeInBytes(translogUUID));
        assert (primaryTerm >= 0L) : "Primary term must be non-negative; term [" + primaryTerm + "]";
    }

    private TranslogHeader(String translogUUID, long primaryTerm, int headerSizeInBytes) {
        this.translogUUID = translogUUID;
        this.primaryTerm = primaryTerm;
        this.headerSizeInBytes = headerSizeInBytes;
    }

    public String getTranslogUUID() {
        return this.translogUUID;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public int sizeInBytes() {
        return this.headerSizeInBytes;
    }

    static int headerSizeInBytes(String translogUUID) {
        return TranslogHeader.headerSizeInBytes(3, new BytesRef((CharSequence)translogUUID).length);
    }

    private static int headerSizeInBytes(int version, int uuidLength) {
        int size = CodecUtil.headerLength(TRANSLOG_CODEC);
        size += 4 + uuidLength;
        if (version >= 3) {
            size += 8;
            size += 4;
        }
        return size;
    }

    static int readHeaderVersion(Path path, FileChannel channel, StreamInput in) throws IOException {
        int version;
        try {
            version = CodecUtil.checkHeader(new InputStreamDataInput(in), TRANSLOG_CODEC, 1, 3);
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException e) {
            TranslogHeader.tryReportOldVersionError(path, channel);
            throw new TranslogCorruptedException(path.toString(), "translog header corrupted", e);
        }
        if (version == 1) {
            throw new IllegalStateException("pre-2.0 translog found [" + String.valueOf(path) + "]");
        }
        return version;
    }

    static TranslogHeader read(String translogUUID, Path path, FileChannel channel) throws IOException {
        TranslogHeader translogHeader = TranslogHeader.read(path, channel);
        BytesRef actualUUID = new BytesRef(translogHeader.translogUUID);
        BytesRef expectedUUID = new BytesRef(translogUUID);
        if (!actualUUID.bytesEquals(expectedUUID)) {
            throw new TranslogCorruptedException(path.toString(), "expected shard UUID " + translogUUID + " but got: " + translogHeader.translogUUID + " this translog file belongs to a different translog");
        }
        return translogHeader;
    }

    public static TranslogHeader read(Path path, FileChannel channel) throws IOException {
        try {
            long primaryTerm;
            BufferedChecksumStreamInput in = new BufferedChecksumStreamInput(new InputStreamStreamInput(java.nio.channels.Channels.newInputStream(channel), channel.size()), path.toString());
            int version = TranslogHeader.readHeaderVersion(path, channel, in);
            int uuidLen = in.readInt();
            if ((long)uuidLen > channel.size()) {
                throw new TranslogCorruptedException(path.toString(), "UUID length can't be larger than the translog");
            }
            if (uuidLen <= 0) {
                throw new TranslogCorruptedException(path.toString(), "UUID length must be positive");
            }
            BytesRef uuid = new BytesRef(uuidLen);
            uuid.length = uuidLen;
            in.read(uuid.bytes, uuid.offset, uuid.length);
            if (version == 3) {
                primaryTerm = in.readLong();
            } else {
                assert (version == 2) : "Unknown header version [" + version + "]";
                primaryTerm = 0L;
            }
            if (version >= 3) {
                Translog.verifyChecksum(in);
            }
            assert (primaryTerm >= 0L) : "Primary term must be non-negative [" + primaryTerm + "]; translog path [" + String.valueOf(path) + "]";
            int headerSizeInBytes = TranslogHeader.headerSizeInBytes(version, uuid.length);
            assert (channel.position() == (long)headerSizeInBytes) : "Header is not fully read; header size [" + headerSizeInBytes + "], position [" + channel.position() + "]";
            return new TranslogHeader(uuid.utf8ToString(), primaryTerm, headerSizeInBytes);
        }
        catch (EOFException e) {
            throw new TranslogCorruptedException(path.toString(), "translog header truncated", e);
        }
    }

    private static void tryReportOldVersionError(Path path, FileChannel channel) throws IOException {
        byte b1 = Channels.readFromFileChannel(channel, 0L, 1)[0];
        if (b1 == 63) {
            throw new TranslogCorruptedException(path.toString(), "translog looks like version 1 or later, but has corrupted header");
        }
        if (b1 == 0) {
            throw new IllegalStateException("pre-1.4 translog found [" + String.valueOf(path) + "]");
        }
    }

    void write(OutputStream outputStream) throws IOException {
        BufferedChecksumStreamOutput out = new BufferedChecksumStreamOutput(new OutputStreamStreamOutput(outputStream));
        CodecUtil.writeHeader(new OutputStreamDataOutput(out), TRANSLOG_CODEC, 3);
        BytesRef uuid = new BytesRef(this.translogUUID);
        out.writeInt(uuid.length);
        out.writeBytes(uuid.bytes, uuid.offset, uuid.length);
        out.writeLong(this.primaryTerm);
        out.writeInt((int)out.getChecksum());
        out.flush();
    }

    void write(FileChannel channel, boolean fsync) throws IOException {
        OutputStream outputStream = java.nio.channels.Channels.newOutputStream(channel);
        this.write(outputStream);
        if (fsync) {
            channel.force(true);
        }
        assert (channel.position() == (long)this.headerSizeInBytes) : "Header is not fully written; header size [" + this.headerSizeInBytes + "], channel position [" + channel.position() + "]";
    }
}

