/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.ToLongFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.DocIdSetBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesCollectorQueue;
import org.opensearch.search.aggregations.bucket.composite.SortedDocsProducer;

class PointsSortedDocsProducer
extends SortedDocsProducer {
    private final ToLongFunction<byte[]> bucketFunction;
    private final byte[] lowerPointQuery;
    private final byte[] upperPointQuery;

    PointsSortedDocsProducer(String field, ToLongFunction<byte[]> bucketFunction, byte[] lowerPointQuery, byte[] upperPointQuery) {
        super(field);
        this.bucketFunction = bucketFunction;
        this.lowerPointQuery = lowerPointQuery;
        this.upperPointQuery = upperPointQuery;
    }

    @Override
    DocIdSet processLeaf(Query query, CompositeValuesCollectorQueue queue, LeafReaderContext context, boolean fillDocIdSet) throws IOException {
        PointValues values = context.reader().getPointValues(this.field);
        if (values == null) {
            return DocIdSet.EMPTY;
        }
        long lowerBucket = Long.MIN_VALUE;
        Comparable lowerValue = queue.getLowerValueLeadSource();
        if (lowerValue != null) {
            if (lowerValue.getClass() != Long.class) {
                throw new IllegalStateException("expected Long, got " + String.valueOf(lowerValue.getClass()));
            }
            lowerBucket = (Long)lowerValue;
        }
        long upperBucket = Long.MAX_VALUE;
        Comparable upperValue = queue.getUpperValueLeadSource();
        if (upperValue != null) {
            if (upperValue.getClass() != Long.class) {
                throw new IllegalStateException("expected Long, got " + String.valueOf(upperValue.getClass()));
            }
            upperBucket = (Long)upperValue;
        }
        DocIdSetBuilder builder = fillDocIdSet ? new DocIdSetBuilder(context.reader().maxDoc(), values, this.field) : null;
        Visitor visitor = new Visitor(context, queue, builder, values.getBytesPerDimension(), lowerBucket, upperBucket);
        try {
            values.intersect(visitor);
            visitor.flush();
        }
        catch (CollectionTerminatedException collectionTerminatedException) {
            // empty catch block
        }
        return fillDocIdSet ? builder.build() : DocIdSet.EMPTY;
    }

    private class Visitor
    implements PointValues.IntersectVisitor {
        final LeafReaderContext context;
        final CompositeValuesCollectorQueue queue;
        final DocIdSetBuilder builder;
        final int maxDoc;
        final int bytesPerDim;
        final long lowerBucket;
        final long upperBucket;
        DocIdSetBuilder bucketDocsBuilder;
        DocIdSetBuilder.BulkAdder adder;
        int remaining;
        long lastBucket;
        boolean first = true;

        Visitor(LeafReaderContext context, CompositeValuesCollectorQueue queue, DocIdSetBuilder builder, int bytesPerDim, long lowerBucket, long upperBucket) {
            this.context = context;
            this.maxDoc = context.reader().maxDoc();
            this.queue = queue;
            this.builder = builder;
            this.lowerBucket = lowerBucket;
            this.upperBucket = upperBucket;
            this.bucketDocsBuilder = new DocIdSetBuilder(this.maxDoc);
            this.bytesPerDim = bytesPerDim;
        }

        @Override
        public void grow(int count) {
            this.remaining = count;
            this.adder = this.bucketDocsBuilder.grow(count);
        }

        @Override
        public void visit(int docID) throws IOException {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            if (this.compare(packedValue, packedValue) != PointValues.Relation.CELL_CROSSES_QUERY) {
                --this.remaining;
                return;
            }
            long bucket = PointsSortedDocsProducer.this.bucketFunction.applyAsLong(packedValue);
            if (!this.first && bucket != this.lastBucket) {
                DocIdSet docIdSet = this.bucketDocsBuilder.build();
                if (PointsSortedDocsProducer.this.processBucket(this.queue, this.context, docIdSet.iterator(), Long.valueOf(this.lastBucket), this.builder) && this.lowerBucket != this.lastBucket) {
                    throw new CollectionTerminatedException();
                }
                this.bucketDocsBuilder = new DocIdSetBuilder(this.maxDoc);
                assert (this.remaining > 0);
                this.adder = this.bucketDocsBuilder.grow(this.remaining);
            }
            this.lastBucket = bucket;
            this.first = false;
            this.adder.add(docID);
            --this.remaining;
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            long minBucket;
            long maxBucket;
            if (PointsSortedDocsProducer.this.upperPointQuery != null && Arrays.compareUnsigned(minPackedValue, 0, this.bytesPerDim, PointsSortedDocsProducer.this.upperPointQuery, 0, this.bytesPerDim) > 0 || PointsSortedDocsProducer.this.lowerPointQuery != null && Arrays.compareUnsigned(maxPackedValue, 0, this.bytesPerDim, PointsSortedDocsProducer.this.lowerPointQuery, 0, this.bytesPerDim) < 0) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (this.lowerBucket != Long.MIN_VALUE && (maxBucket = PointsSortedDocsProducer.this.bucketFunction.applyAsLong(maxPackedValue)) < this.lowerBucket) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (this.upperBucket != Long.MAX_VALUE && (minBucket = PointsSortedDocsProducer.this.bucketFunction.applyAsLong(minPackedValue)) > this.upperBucket) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        public void flush() throws IOException {
            if (!this.first) {
                DocIdSet docIdSet = this.bucketDocsBuilder.build();
                PointsSortedDocsProducer.this.processBucket(this.queue, this.context, docIdSet.iterator(), Long.valueOf(this.lastBucket), this.builder);
                this.bucketDocsBuilder = null;
            }
        }
    }
}

