/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.document.DocumentField;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.script.FieldScript;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;
import org.opensearch.search.fetch.subphase.ScriptFieldsContext;

public final class ScriptFieldsPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) {
        if (context.scriptFields() == null) {
            return null;
        }
        final List<ScriptFieldsContext.ScriptField> scriptFields = context.scriptFields().fields();
        return new FetchSubPhaseProcessor(){
            FieldScript[] leafScripts = null;

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
                this.leafScripts = ScriptFieldsPhase.this.createLeafScripts(readerContext, scriptFields);
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) {
                int docId = hitContext.docId();
                for (int i = 0; i < this.leafScripts.length; ++i) {
                    Object value;
                    this.leafScripts[i].setDocument(docId);
                    try {
                        value = this.leafScripts[i].execute();
                        CollectionUtils.ensureNoSelfReferences(value, "ScriptFieldsPhase leaf script " + i);
                    }
                    catch (RuntimeException e) {
                        if (((ScriptFieldsContext.ScriptField)scriptFields.get(i)).ignoreException()) continue;
                        throw e;
                    }
                    String scriptFieldName = ((ScriptFieldsContext.ScriptField)scriptFields.get(i)).name();
                    DocumentField hitField = hitContext.hit().field(scriptFieldName);
                    if (hitField != null) continue;
                    List<Object> values = value instanceof Collection ? new ArrayList<Object>((Collection)value) : Collections.singletonList(value);
                    hitField = new DocumentField(scriptFieldName, values);
                    hitContext.hit().setDocumentField(scriptFieldName, hitField);
                }
            }
        };
    }

    private FieldScript[] createLeafScripts(LeafReaderContext context, List<ScriptFieldsContext.ScriptField> scriptFields) {
        FieldScript[] scripts = new FieldScript[scriptFields.size()];
        for (int i = 0; i < scripts.length; ++i) {
            try {
                scripts[i] = scriptFields.get(i).script().newInstance(context);
                continue;
            }
            catch (IOException e1) {
                throw new IllegalStateException("Failed to load script " + scriptFields.get(i).name(), e1);
            }
        }
        return scripts;
    }
}

