/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class SearchShardTaskCancellationStats
implements ToXContentObject,
Writeable {
    private final long currentLongRunningCancelledTaskCount;
    private final long totalLongRunningCancelledTaskCount;

    public SearchShardTaskCancellationStats(long currentTaskCount, long totalTaskCount) {
        this.currentLongRunningCancelledTaskCount = currentTaskCount;
        this.totalLongRunningCancelledTaskCount = totalTaskCount;
    }

    public SearchShardTaskCancellationStats(StreamInput in) throws IOException {
        this.currentLongRunningCancelledTaskCount = in.readVLong();
        this.totalLongRunningCancelledTaskCount = in.readVLong();
    }

    protected long getCurrentLongRunningCancelledTaskCount() {
        return this.currentLongRunningCancelledTaskCount;
    }

    protected long getTotalLongRunningCancelledTaskCount() {
        return this.totalLongRunningCancelledTaskCount;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("current_count_post_cancel", this.currentLongRunningCancelledTaskCount);
        builder.field("total_count_post_cancel", this.totalLongRunningCancelledTaskCount);
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.currentLongRunningCancelledTaskCount);
        out.writeVLong(this.totalLongRunningCancelledTaskCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardTaskCancellationStats that = (SearchShardTaskCancellationStats)o;
        return this.currentLongRunningCancelledTaskCount == that.currentLongRunningCancelledTaskCount && this.totalLongRunningCancelledTaskCount == that.totalLongRunningCancelledTaskCount;
    }

    public int hashCode() {
        return Objects.hash(this.currentLongRunningCancelledTaskCount, this.totalLongRunningCancelledTaskCount);
    }
}

