/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.marshaller.raw;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.karaf.decanter.api.marshaller.Marshaller;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"dataFormat=raw"})
public class RawMarshaller
implements Marshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawMarshaller.class);

    public void marshal(Object obj, OutputStream out) {
        String result = this.marshal(obj);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            writer.write(result);
        }
        catch (Exception e) {
            LOGGER.warn("Can't marshal", (Throwable)e);
        }
    }

    public String marshal(Object obj) {
        return this.marshal((Event)obj);
    }

    private String marshal(Event event) {
        StringBuilder builder = new StringBuilder();
        for (String propertyName : event.getPropertyNames()) {
            Object propertyValue = event.getProperty(propertyName);
            if (propertyName == null || propertyValue == null) continue;
            builder.append(propertyName).append("=").append(propertyValue.toString()).append("\n");
        }
        return builder.toString();
    }
}

