/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;

public class StringUtil {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static String implode(String glue, String[] pieces) {
        StringBuilder result = new StringBuilder();
        if (pieces != null && pieces.length > 0) {
            for (int i = 0; i < pieces.length; ++i) {
                String piece = pieces[i];
                if (piece != null) {
                    result.append(piece);
                }
                if (glue == null || i >= pieces.length - 1) continue;
                result.append(glue);
            }
        }
        return result.toString();
    }

    public static String implode(String glue, Collection<String> pieces) {
        return StringUtil.implode(glue, pieces == null ? null : pieces.toArray(new String[0]));
    }

    public static List<String> explode(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        if (delimiter == null || delimiter.length() == 0) {
            return Arrays.asList(s);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, delimiter);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken().trim());
        }
        return result;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static String randomUUID() {
        String uuid = UUID.randomUUID().toString();
        try {
            MessageDigest salt = MessageDigest.getInstance("SHA-256");
            salt.update(uuid.getBytes(StandardCharsets.UTF_8));
            return StringUtil.bytesToHex(salt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return uuid;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

