/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobStatsGetActionDTO
implements OpenSearchPluginDTO {
    private final String communicationId;

    public ReplicationJobStatsGetActionDTO() {
        this.communicationId = String.valueOf(System.nanoTime());
    }

    public ReplicationJobStatsGetActionDTO(String communicationId) {
        if (StringUtil.isNullOrEmpty((String)communicationId)) {
            throw new NullPointerException("The 'communicationId' cannot be null or empty");
        }
        this.communicationId = communicationId;
    }

    public ReplicationJobStatsGetActionDTO(Map<String, Object> jobMap) {
        this(MapUtil.getValueAsString(jobMap, (String)"communicationId", null));
        this.checkForWellKnownKeys(jobMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> jobMap) {
        MapUtil.checkForWellKnownKeys(jobMap, Set.of("communicationId"));
    }

    public ReplicationJobStatsGetActionDTO(StreamInput in) throws IOException {
        this.communicationId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.communicationId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("communicationId", this.communicationId);
        builder.endObject();
        return builder;
    }

    public static ReplicationJobStatsGetActionDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobStatsGetActionDTO(parser.map());
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobStatsGetActionDTO that = (ReplicationJobStatsGetActionDTO)o;
        return Objects.equals(this.communicationId, that.communicationId);
    }

    public int hashCode() {
        return Objects.hash(this.communicationId);
    }

    public String toString() {
        return "ReplicationJobStatsGetActionDTO{communicationId='" + this.communicationId + "'}";
    }
}

