/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ServerStateInfoDTO
implements OpenSearchPluginDTO {
    private final String serverUUID;
    private final String serverVersion;
    private final String serverHostname;
    private final String serverAddress;
    private final String serverHttpPort;
    private final String serverHttpsPort;
    private final String bpcName;
    private final String bpcUrl;
    private final boolean maintenanceModeEnabled;
    private final boolean availableForReplicationEnabled;
    private final boolean masterServer;
    private final Instant sendedAtInUtc;

    public ServerStateInfoDTO(String serverUUID, String serverVersion, String serverHostname, String serverAddress, String serverHttpPort, String serverHttpsPort, String bpcName, String bpcUrl, boolean maintenanceModeEnabled, boolean availableForReplicationEnabled, boolean masterServer, Instant sendedAtInUtc) {
        this.serverUUID = serverUUID;
        this.serverVersion = serverVersion;
        this.serverHostname = serverHostname;
        this.serverAddress = serverAddress;
        this.serverHttpPort = serverHttpPort;
        this.serverHttpsPort = serverHttpsPort;
        this.bpcName = bpcName;
        this.bpcUrl = bpcUrl;
        this.maintenanceModeEnabled = maintenanceModeEnabled;
        this.availableForReplicationEnabled = availableForReplicationEnabled;
        this.masterServer = masterServer;
        this.sendedAtInUtc = sendedAtInUtc != null ? sendedAtInUtc : TimestampUtil.nowInUtc();
    }

    public ServerStateInfoDTO(String serverUUID, String serverVersion, String serverHostname, String serverAddress, String serverHttpPort, String serverHttpsPort, String bpcName, String bpcUrl, boolean maintenanceModeEnabled, boolean availableForReplicationEnabled, boolean masterServer) {
        this.serverUUID = serverUUID;
        this.serverVersion = serverVersion;
        this.serverHostname = serverHostname;
        this.serverAddress = serverAddress;
        this.serverHttpPort = serverHttpPort;
        this.serverHttpsPort = serverHttpsPort;
        this.bpcName = bpcName;
        this.bpcUrl = bpcUrl;
        this.maintenanceModeEnabled = maintenanceModeEnabled;
        this.availableForReplicationEnabled = availableForReplicationEnabled;
        this.masterServer = masterServer;
        this.sendedAtInUtc = TimestampUtil.nowInUtc();
    }

    public ServerStateInfoDTO(Map<String, Object> stateInfoMessage) {
        this.checkForWellKnownKeys(stateInfoMessage);
        this.serverUUID = MapUtil.getValueAsString(stateInfoMessage, (String)"serverUUID", null);
        this.serverVersion = MapUtil.getValueAsString(stateInfoMessage, (String)"serverVersion", null);
        this.serverHostname = MapUtil.getValueAsString(stateInfoMessage, (String)"serverHostname", null);
        this.serverAddress = MapUtil.getValueAsString(stateInfoMessage, (String)"serverAddress", null);
        this.serverHttpPort = MapUtil.getValueAsString(stateInfoMessage, (String)"serverHttpPort", null);
        this.serverHttpsPort = MapUtil.getValueAsString(stateInfoMessage, (String)"serverHttpsPort", null);
        this.bpcName = MapUtil.getValueAsString(stateInfoMessage, (String)"bpcName", null);
        this.bpcUrl = MapUtil.getValueAsString(stateInfoMessage, (String)"bpcUrl", null);
        this.maintenanceModeEnabled = MapUtil.getValueAsBoolean(stateInfoMessage, (String)"maintenanceModeEnabled", (boolean)false);
        this.availableForReplicationEnabled = MapUtil.getValueAsBoolean(stateInfoMessage, (String)"availableForReplicationEnabled", (boolean)true);
        this.masterServer = MapUtil.getValueAsBoolean(stateInfoMessage, (String)"masterServer", (boolean)false);
        this.sendedAtInUtc = MapUtil.getValueAsInstant(stateInfoMessage, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc());
    }

    private void checkForWellKnownKeys(Map<String, Object> stateInfoMessage) {
        MapUtil.checkForWellKnownKeys(stateInfoMessage, Set.of("serverUUID", "serverVersion", "serverHostname", "serverAddress", "serverHttpPort", "serverHttpsPort", "bpcName", "bpcUrl", "maintenanceModeEnabled", "availableForReplicationEnabled", "masterServer", "sendedAt"));
    }

    public ServerStateInfoDTO(StreamInput in) throws IOException {
        this.serverUUID = in.readString();
        this.serverVersion = in.readOptionalString();
        this.serverHostname = in.readOptionalString();
        this.serverAddress = in.readOptionalString();
        this.serverHttpPort = in.readOptionalString();
        this.serverHttpsPort = in.readOptionalString();
        this.bpcName = in.readOptionalString();
        this.bpcUrl = in.readOptionalString();
        this.maintenanceModeEnabled = in.readBoolean();
        this.availableForReplicationEnabled = in.readBoolean();
        this.masterServer = in.readBoolean();
        this.sendedAtInUtc = in.readOptionalInstant();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.serverUUID);
        out.writeOptionalString(this.serverVersion);
        out.writeOptionalString(this.serverHostname);
        out.writeOptionalString(this.serverAddress);
        out.writeOptionalString(this.serverHttpPort);
        out.writeOptionalString(this.serverHttpsPort);
        out.writeOptionalString(this.bpcName);
        out.writeOptionalString(this.bpcUrl);
        out.writeBoolean(this.maintenanceModeEnabled);
        out.writeBoolean(this.availableForReplicationEnabled);
        out.writeBoolean(this.masterServer);
        out.writeOptionalInstant(this.sendedAtInUtc);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("serverUUID", this.serverUUID);
        builder.field("serverVersion", this.serverVersion);
        builder.field("serverHostname", this.serverHostname);
        builder.field("serverAddress", this.serverAddress);
        builder.field("serverHttpPort", this.serverHttpPort);
        builder.field("serverHttpsPort", this.serverHttpsPort);
        builder.field("bpcName", this.bpcName);
        builder.field("bpcUrl", this.bpcUrl);
        builder.field("maintenanceModeEnabled", this.maintenanceModeEnabled);
        builder.field("availableForReplicationEnabled", this.availableForReplicationEnabled);
        builder.field("masterServer", this.masterServer);
        builder.field("sendedAt", TimestampUtil.formatAsIsoInstantString((Instant)this.sendedAtInUtc));
        builder.endObject();
        return builder;
    }

    public static ServerStateInfoDTO fromXContent(XContentParser parser) throws IOException {
        return new ServerStateInfoDTO(parser.map());
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getServerHostname() {
        return this.serverHostname;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerHttpPort() {
        return this.serverHttpPort;
    }

    public String getServerHttpsPort() {
        return this.serverHttpsPort;
    }

    public String getBpcName() {
        return this.bpcName;
    }

    public String getBpcUrl() {
        return this.bpcUrl;
    }

    public boolean isMaintenanceModeEnabled() {
        return this.maintenanceModeEnabled;
    }

    public boolean isAvailableForReplicationEnabled() {
        return this.availableForReplicationEnabled;
    }

    public boolean canBeUsedForReplication() {
        return this.availableForReplicationEnabled && !this.maintenanceModeEnabled;
    }

    public boolean isMasterServer() {
        return this.masterServer;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerStateInfoDTO that = (ServerStateInfoDTO)o;
        return this.maintenanceModeEnabled == that.maintenanceModeEnabled && this.availableForReplicationEnabled == that.availableForReplicationEnabled && this.masterServer == that.masterServer && Objects.equals(this.sendedAtInUtc, that.sendedAtInUtc) && Objects.equals(this.serverUUID, that.serverUUID) && Objects.equals(this.serverVersion, that.serverVersion) && Objects.equals(this.serverHostname, that.serverHostname) && Objects.equals(this.serverAddress, that.serverAddress) && Objects.equals(this.serverHttpPort, that.serverHttpPort) && Objects.equals(this.serverHttpsPort, that.serverHttpsPort) && Objects.equals(this.bpcName, that.bpcName) && Objects.equals(this.bpcUrl, that.bpcUrl);
    }

    public int hashCode() {
        return Objects.hash(this.serverUUID, this.serverVersion, this.serverHostname, this.serverAddress, this.serverHttpPort, this.serverHttpsPort, this.bpcName, this.bpcUrl, this.maintenanceModeEnabled, this.availableForReplicationEnabled, this.masterServer, this.sendedAtInUtc);
    }

    public String toString() {
        return "ServerStateInfoDTO{serverUUID='" + this.serverUUID + "', serverVersion='" + this.serverVersion + "', serverHostname='" + this.serverHostname + "', serverAddress='" + this.serverAddress + "', serverHttpPort='" + this.serverHttpPort + "', serverHttpsPort='" + this.serverHttpsPort + "', bpcName='" + this.bpcName + "', bpcUrl='" + this.bpcUrl + "', maintenanceModeEnabled=" + this.maintenanceModeEnabled + ", availableForReplicationEnabled=" + this.availableForReplicationEnabled + ", masterServer=" + this.masterServer + ", sendedAtInUtc=" + this.sendedAtInUtc + "}";
    }
}

