/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.rest.action.filter;

import de.virtimo.bpc.opensearch.plugin.ChangesFilter;
import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.dto.FilterDTO;
import de.virtimo.bpc.opensearch.plugin.dto.FiltersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.rest.action.BaseBpcPluginRestHandler;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.Loggers;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;

public class RestGetChangesFiltersAction
extends BaseBpcPluginRestHandler {
    private static final Logger LOGGER = Loggers.getLogger(RestGetChangesFiltersAction.class, (String[])new String[]{"os-bpc-plugin"});

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_bpc/filter"));
    }

    public String getName() {
        return "get_changes_filters_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient, Manager manager) throws IOException {
        LOGGER.debug("prepareRequest request={}, nodeClient={}, manager={}", (Object)request, (Object)nodeClient, (Object)manager);
        String serverUUID = request.param("serverUUID", null);
        LOGGER.debug("serverUUID={}", (Object)serverUUID);
        return channel -> {
            List<ChangesFilter> currentFilters = manager.getChangesFilters().getAll(serverUUID);
            FiltersDTO filters = this.convertToFiltersDTO(currentFilters);
            this.sendDTO((RestChannel)channel, (OpenSearchPluginDTO)filters);
        };
    }

    private FiltersDTO convertToFiltersDTO(List<ChangesFilter> changesFilters) {
        FiltersDTO filters = new FiltersDTO();
        if (changesFilters != null) {
            for (ChangesFilter changesFilter : changesFilters) {
                FilterDTO filter = new FilterDTO(changesFilter.getIndex(), changesFilter.isSendIndexEventsOnlyForModifiedSources());
                filters.setFilter(filter);
            }
        }
        return filters;
    }
}

